/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.ResourcePackFile;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.repository.PackDetector;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackSource;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import org.slf4j.Logger;

public class ResourcePackSourceFolder
implements ResourcePackSource {
    static final Logger LOGGER = LogUtils.getLogger();
    private final Path folder;
    private final EnumResourcePackType packType;
    private final PackSource packSource;
    private final DirectoryValidator validator;

    public ResourcePackSourceFolder(Path var0, EnumResourcePackType var1, PackSource var2, DirectoryValidator var3) {
        this.folder = var0;
        this.packType = var1;
        this.packSource = var2;
        this.validator = var3;
    }

    private static String nameFromPath(Path var0) {
        return var0.getFileName().toString();
    }

    @Override
    public void loadPacks(Consumer<ResourcePackLoader> var0) {
        try {
            FileUtils.createDirectoriesSafe(this.folder);
            ResourcePackSourceFolder.discoverPacks(this.folder, this.validator, false, (var1, var2) -> {
                String var3 = ResourcePackSourceFolder.nameFromPath(var1);
                ResourcePackLoader var4 = ResourcePackLoader.readMetaAndCreate("file/" + var3, IChatBaseComponent.literal(var3), false, var2, this.packType, ResourcePackLoader.Position.TOP, this.packSource);
                if (var4 != null) {
                    var0.accept(var4);
                }
            });
        }
        catch (IOException var12) {
            LOGGER.warn("Failed to list packs in {}", (Object)this.folder, (Object)var12);
        }
    }

    public static void discoverPacks(Path var0, DirectoryValidator var1, boolean var2, BiConsumer<Path, ResourcePackLoader.c> var3) throws IOException {
        a var4 = new a(var1, var2);
        try (DirectoryStream<Path> var5 = Files.newDirectoryStream(var0);){
            for (Path var7 : var5) {
                try {
                    ArrayList<ForbiddenSymlinkInfo> var8 = new ArrayList<ForbiddenSymlinkInfo>();
                    ResourcePackLoader.c var9 = (ResourcePackLoader.c)var4.detectPackResources(var7, var8);
                    if (!var8.isEmpty()) {
                        LOGGER.warn("Ignoring potential pack entry: {}", (Object)ContentValidationException.getMessage(var7, var8));
                        continue;
                    }
                    if (var9 != null) {
                        var3.accept(var7, var9);
                        continue;
                    }
                    LOGGER.info("Found non-pack entry '{}', ignoring", (Object)var7);
                }
                catch (IOException var8) {
                    LOGGER.warn("Failed to read properties of '{}', ignoring", (Object)var7, (Object)var8);
                }
            }
        }
    }

    static class a
    extends PackDetector<ResourcePackLoader.c> {
        private final boolean isBuiltin;

        protected a(DirectoryValidator var0, boolean var1) {
            super(var0);
            this.isBuiltin = var1;
        }

        @Override
        @Nullable
        protected ResourcePackLoader.c createZipPack(Path var0) {
            FileSystem var1 = var0.getFileSystem();
            if (var1 == FileSystems.getDefault() || var1 instanceof LinkFileSystem) {
                return new ResourcePackFile.a(var0, this.isBuiltin);
            }
            LOGGER.info("Can't open pack archive at {}", (Object)var0);
            return null;
        }

        @Override
        protected ResourcePackLoader.c createDirectoryPack(Path var0) {
            return new PathPackResources.a(var0, this.isBuiltin);
        }

        @Override
        protected /* synthetic */ Object createDirectoryPack(Path path) throws IOException {
            return this.createDirectoryPack(path);
        }

        @Override
        @Nullable
        protected /* synthetic */ Object createZipPack(Path path) throws IOException {
            return this.createZipPack(path);
        }
    }
}

