/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import net.minecraft.SharedConstants;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.PacketHandshakingInListener;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PacketStatusListener;

public class HandshakeListener
implements PacketHandshakingInListener {
    private static final IChatBaseComponent IGNORE_STATUS_REASON = IChatBaseComponent.translatable("disconnect.ignoring_status_request");
    private final MinecraftServer server;
    private final NetworkManager connection;

    public HandshakeListener(MinecraftServer var0, NetworkManager var1) {
        this.server = var0;
        this.connection = var1;
    }

    @Override
    public void handleIntention(PacketHandshakingInSetProtocol var0) {
        switch (var0.intention()) {
            case LOGIN: {
                this.connection.setClientboundProtocolAfterHandshake(ClientIntent.LOGIN);
                if (var0.protocolVersion() != SharedConstants.getCurrentVersion().getProtocolVersion()) {
                    IChatMutableComponent var1 = var0.protocolVersion() < 754 ? IChatBaseComponent.translatable("multiplayer.disconnect.outdated_client", SharedConstants.getCurrentVersion().getName()) : IChatBaseComponent.translatable("multiplayer.disconnect.incompatible", SharedConstants.getCurrentVersion().getName());
                    this.connection.send(new PacketLoginOutDisconnect(var1));
                    this.connection.disconnect(var1);
                    break;
                }
                this.connection.setListener(new LoginListener(this.server, this.connection));
                break;
            }
            case STATUS: {
                ServerPing var1 = this.server.getStatus();
                if (this.server.repliesToStatus() && var1 != null) {
                    this.connection.setClientboundProtocolAfterHandshake(ClientIntent.STATUS);
                    this.connection.setListener(new PacketStatusListener(var1, this.connection));
                    break;
                }
                this.connection.disconnect(IGNORE_STATUS_REASON);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid intention " + var0.intention());
            }
        }
    }

    @Override
    public void onDisconnect(IChatBaseComponent var0) {
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected();
    }
}

