/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;

public class ChunkProviderServer
extends IChunkProvider {
    private static final List<ChunkStatus> CHUNK_STATUSES = ChunkStatus.getStatusList();
    private final ChunkMapDistance distanceManager;
    final WorldServer level;
    final Thread mainThread;
    final LightEngineThreaded lightEngine;
    private final b mainThreadProcessor;
    public final PlayerChunkMap chunkMap;
    private final WorldPersistentData dataStorage;
    private long lastInhabitedUpdate;
    public boolean spawnEnemies = true;
    public boolean spawnFriendlies = true;
    private static final int CACHE_SIZE = 4;
    private final long[] lastChunkPos = new long[4];
    private final ChunkStatus[] lastChunkStatus = new ChunkStatus[4];
    private final IChunkAccess[] lastChunk = new IChunkAccess[4];
    @Nullable
    @VisibleForDebug
    private SpawnerCreature.d lastSpawnState;

    public ChunkProviderServer(WorldServer var0, Convertable.ConversionSession var1, DataFixer var2, StructureTemplateManager var3, Executor var4, ChunkGenerator var5, int var6, int var7, boolean var8, WorldLoadListener var9, ChunkStatusUpdateListener var10, Supplier<WorldPersistentData> var11) {
        this.level = var0;
        this.mainThreadProcessor = new b(var0);
        this.mainThread = Thread.currentThread();
        File var12 = var1.getDimensionPath(var0.dimension()).resolve("data").toFile();
        var12.mkdirs();
        this.dataStorage = new WorldPersistentData(var12, var2);
        this.chunkMap = new PlayerChunkMap(var0, var1, var2, var3, var4, this.mainThreadProcessor, this, var5, var9, var10, var11, var6, var8);
        this.lightEngine = this.chunkMap.getLightEngine();
        this.distanceManager = this.chunkMap.getDistanceManager();
        this.distanceManager.updateSimulationDistance(var7);
        this.clearCache();
    }

    @Override
    public LightEngineThreaded getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    private PlayerChunk getVisibleChunkIfPresent(long var0) {
        return this.chunkMap.getVisibleChunkIfPresent(var0);
    }

    public int getTickingGenerated() {
        return this.chunkMap.getTickingGenerated();
    }

    private void storeInCache(long var0, IChunkAccess var2, ChunkStatus var3) {
        for (int var4 = 3; var4 > 0; --var4) {
            this.lastChunkPos[var4] = this.lastChunkPos[var4 - 1];
            this.lastChunkStatus[var4] = this.lastChunkStatus[var4 - 1];
            this.lastChunk[var4] = this.lastChunk[var4 - 1];
        }
        this.lastChunkPos[0] = var0;
        this.lastChunkStatus[0] = var3;
        this.lastChunk[0] = var2;
    }

    @Override
    @Nullable
    public IChunkAccess getChunk(int var02, int var12, ChunkStatus var2, boolean var3) {
        IChunkAccess var8;
        if (Thread.currentThread() != this.mainThread) {
            return CompletableFuture.supplyAsync(() -> this.getChunk(var02, var12, var2, var3), this.mainThreadProcessor).join();
        }
        GameProfilerFiller var4 = this.level.getProfiler();
        var4.incrementCounter("getChunk");
        long var5 = ChunkCoordIntPair.asLong(var02, var12);
        for (int var7 = 0; var7 < 4; ++var7) {
            if (var5 != this.lastChunkPos[var7] || var2 != this.lastChunkStatus[var7] || (var8 = this.lastChunk[var7]) == null && var3) continue;
            return var8;
        }
        var4.incrementCounter("getChunkCacheMiss");
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> var7 = this.getChunkFutureMainThread(var02, var12, var2, var3);
        this.mainThreadProcessor.managedBlock(var7::isDone);
        var8 = (IChunkAccess)var7.join().map(var0 -> var0, var1 -> {
            if (var3) {
                throw SystemUtils.pauseInIde(new IllegalStateException("Chunk not there when requested: " + var1));
            }
            return null;
        });
        this.storeInCache(var5, var8, var2);
        return var8;
    }

    @Override
    @Nullable
    public Chunk getChunkNow(int var0, int var1) {
        if (Thread.currentThread() != this.mainThread) {
            return null;
        }
        this.level.getProfiler().incrementCounter("getChunkNow");
        long var2 = ChunkCoordIntPair.asLong(var0, var1);
        for (int var4 = 0; var4 < 4; ++var4) {
            if (var2 != this.lastChunkPos[var4] || this.lastChunkStatus[var4] != ChunkStatus.FULL) continue;
            IChunkAccess var5 = this.lastChunk[var4];
            return var5 instanceof Chunk ? (Chunk)var5 : null;
        }
        PlayerChunk var4 = this.getVisibleChunkIfPresent(var2);
        if (var4 == null) {
            return null;
        }
        Either var5 = var4.getFutureIfPresent(ChunkStatus.FULL).getNow(null);
        if (var5 == null) {
            return null;
        }
        IChunkAccess var6 = var5.left().orElse(null);
        if (var6 != null) {
            this.storeInCache(var2, var6, ChunkStatus.FULL);
            if (var6 instanceof Chunk) {
                return (Chunk)var6;
            }
        }
        return null;
    }

    private void clearCache() {
        Arrays.fill(this.lastChunkPos, ChunkCoordIntPair.INVALID_CHUNK_POS);
        Arrays.fill(this.lastChunkStatus, null);
        Arrays.fill(this.lastChunk, null);
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> getChunkFuture(int var02, int var1, ChunkStatus var2, boolean var3) {
        CompletionStage<Object> var5;
        boolean var4;
        boolean bl = var4 = Thread.currentThread() == this.mainThread;
        if (var4) {
            var5 = this.getChunkFutureMainThread(var02, var1, var2, var3);
            this.mainThreadProcessor.managedBlock(() -> var5.isDone());
        } else {
            var5 = CompletableFuture.supplyAsync(() -> this.getChunkFutureMainThread(var02, var1, var2, var3), this.mainThreadProcessor).thenCompose(var0 -> var0);
        }
        return var5;
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> getChunkFutureMainThread(int var0, int var1, ChunkStatus var2, boolean var3) {
        ChunkCoordIntPair var4 = new ChunkCoordIntPair(var0, var1);
        long var5 = var4.toLong();
        int var7 = ChunkLevel.byStatus(var2);
        PlayerChunk var8 = this.getVisibleChunkIfPresent(var5);
        if (var3) {
            this.distanceManager.addTicket(TicketType.UNKNOWN, var4, var7, var4);
            if (this.chunkAbsent(var8, var7)) {
                GameProfilerFiller var9 = this.level.getProfiler();
                var9.push("chunkLoad");
                this.runDistanceManagerUpdates();
                var8 = this.getVisibleChunkIfPresent(var5);
                var9.pop();
                if (this.chunkAbsent(var8, var7)) {
                    throw SystemUtils.pauseInIde(new IllegalStateException("No chunk holder after ticket has been added"));
                }
            }
        }
        if (this.chunkAbsent(var8, var7)) {
            return PlayerChunk.UNLOADED_CHUNK_FUTURE;
        }
        return var8.getOrScheduleFuture(var2, this.chunkMap);
    }

    private boolean chunkAbsent(@Nullable PlayerChunk var0, int var1) {
        return var0 == null || var0.getTicketLevel() > var1;
    }

    @Override
    public boolean hasChunk(int var0, int var1) {
        int var3;
        PlayerChunk var2 = this.getVisibleChunkIfPresent(new ChunkCoordIntPair(var0, var1).toLong());
        return !this.chunkAbsent(var2, var3 = ChunkLevel.byStatus(ChunkStatus.FULL));
    }

    @Override
    @Nullable
    public LightChunk getChunkForLighting(int var0, int var1) {
        long var2 = ChunkCoordIntPair.asLong(var0, var1);
        PlayerChunk var4 = this.getVisibleChunkIfPresent(var2);
        if (var4 == null) {
            return null;
        }
        int var5 = CHUNK_STATUSES.size() - 1;
        while (true) {
            ChunkStatus var6;
            Optional var7;
            if ((var7 = var4.getFutureIfPresentUnchecked(var6 = CHUNK_STATUSES.get(var5)).getNow(PlayerChunk.UNLOADED_CHUNK).left()).isPresent()) {
                return (LightChunk)var7.get();
            }
            if (var6 == ChunkStatus.INITIALIZE_LIGHT.getParent()) break;
            --var5;
        }
        return null;
    }

    @Override
    public World getLevel() {
        return this.level;
    }

    public boolean pollTask() {
        return this.mainThreadProcessor.pollTask();
    }

    boolean runDistanceManagerUpdates() {
        boolean var0 = this.distanceManager.runAllUpdates(this.chunkMap);
        boolean var1 = this.chunkMap.promoteChunkMap();
        if (var0 || var1) {
            this.clearCache();
            return true;
        }
        return false;
    }

    public boolean isPositionTicking(long var0) {
        PlayerChunk var2 = this.getVisibleChunkIfPresent(var0);
        if (var2 == null) {
            return false;
        }
        if (!this.level.shouldTickBlocksAt(var0)) {
            return false;
        }
        Either var3 = var2.getTickingChunkFuture().getNow(null);
        return var3 != null && var3.left().isPresent();
    }

    public void save(boolean var0) {
        this.runDistanceManagerUpdates();
        this.chunkMap.saveAllChunks(var0);
    }

    @Override
    public void close() throws IOException {
        this.save(true);
        this.lightEngine.close();
        this.chunkMap.close();
    }

    @Override
    public void tick(BooleanSupplier var0, boolean var1) {
        this.level.getProfiler().push("purge");
        this.distanceManager.purgeStaleTickets();
        this.runDistanceManagerUpdates();
        this.level.getProfiler().popPush("chunks");
        if (var1) {
            this.tickChunks();
            this.chunkMap.tick();
        }
        this.level.getProfiler().popPush("unload");
        this.chunkMap.tick(var0);
        this.level.getProfiler().pop();
        this.clearCache();
    }

    private void tickChunks() {
        long var02 = this.level.getGameTime();
        long var2 = var02 - this.lastInhabitedUpdate;
        this.lastInhabitedUpdate = var02;
        if (this.level.isDebug()) {
            return;
        }
        GameProfilerFiller var4 = this.level.getProfiler();
        var4.push("pollingChunks");
        var4.push("filteringLoadedChunks");
        ArrayList var5 = Lists.newArrayListWithCapacity((int)this.chunkMap.size());
        for (PlayerChunk playerChunk : this.chunkMap.getChunks()) {
            Chunk var8 = playerChunk.getTickingChunk();
            if (var8 == null) continue;
            var5.add(new a(var8, playerChunk));
        }
        if (this.level.getServer().tickRateManager().runsNormally()) {
            SpawnerCreature.d d2;
            var4.popPush("naturalSpawnCount");
            int var6 = this.distanceManager.getNaturalSpawnChunkCount();
            this.lastSpawnState = d2 = SpawnerCreature.createState(var6, this.level.getAllEntities(), this::getFullChunk, new LocalMobCapCalculator(this.chunkMap));
            var4.popPush("spawnAndTick");
            boolean var8 = this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING);
            SystemUtils.shuffle(var5, this.level.random);
            int var9 = this.level.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
            boolean var10 = this.level.getLevelData().getGameTime() % 400L == 0L;
            for (a var12 : var5) {
                Chunk var13 = var12.chunk;
                ChunkCoordIntPair var14 = var13.getPos();
                if (!this.level.isNaturalSpawningAllowed(var14) || !this.chunkMap.anyPlayerCloseEnoughForSpawning(var14)) continue;
                var13.incrementInhabitedTime(var2);
                if (var8 && (this.spawnEnemies || this.spawnFriendlies) && this.level.getWorldBorder().isWithinBounds(var14)) {
                    SpawnerCreature.spawnForChunk(this.level, var13, d2, this.spawnFriendlies, this.spawnEnemies, var10);
                }
                if (!this.level.shouldTickBlocksAt(var14.toLong())) continue;
                this.level.tickChunk(var13, var9);
            }
            var4.popPush("customSpawners");
            if (var8) {
                this.level.tickCustomSpawners(this.spawnEnemies, this.spawnFriendlies);
            }
        }
        var4.popPush("broadcast");
        var5.forEach(var0 -> var0.holder.broadcastChanges(var0.chunk));
        var4.pop();
        var4.pop();
    }

    private void getFullChunk(long var0, Consumer<Chunk> var2) {
        PlayerChunk var3 = this.getVisibleChunkIfPresent(var0);
        if (var3 != null) {
            var3.getFullChunkFuture().getNow(PlayerChunk.UNLOADED_LEVEL_CHUNK).left().ifPresent(var2);
        }
    }

    @Override
    public String gatherStats() {
        return Integer.toString(this.getLoadedChunksCount());
    }

    @VisibleForTesting
    public int getPendingTasksCount() {
        return this.mainThreadProcessor.getPendingTasksCount();
    }

    public ChunkGenerator getGenerator() {
        return this.chunkMap.generator();
    }

    public ChunkGeneratorStructureState getGeneratorState() {
        return this.chunkMap.generatorState();
    }

    public RandomState randomState() {
        return this.chunkMap.randomState();
    }

    @Override
    public int getLoadedChunksCount() {
        return this.chunkMap.size();
    }

    public void blockChanged(BlockPosition var0) {
        int var2;
        int var1 = SectionPosition.blockToSectionCoord(var0.getX());
        PlayerChunk var3 = this.getVisibleChunkIfPresent(ChunkCoordIntPair.asLong(var1, var2 = SectionPosition.blockToSectionCoord(var0.getZ())));
        if (var3 != null) {
            var3.blockChanged(var0);
        }
    }

    @Override
    public void onLightUpdate(EnumSkyBlock var0, SectionPosition var1) {
        this.mainThreadProcessor.execute(() -> {
            PlayerChunk var2 = this.getVisibleChunkIfPresent(var1.chunk().toLong());
            if (var2 != null) {
                var2.sectionLightChanged(var0, var1.y());
            }
        });
    }

    public <T> void addRegionTicket(TicketType<T> var0, ChunkCoordIntPair var1, int var2, T var3) {
        this.distanceManager.addRegionTicket(var0, var1, var2, var3);
    }

    public <T> void removeRegionTicket(TicketType<T> var0, ChunkCoordIntPair var1, int var2, T var3) {
        this.distanceManager.removeRegionTicket(var0, var1, var2, var3);
    }

    @Override
    public void updateChunkForced(ChunkCoordIntPair var0, boolean var1) {
        this.distanceManager.updateChunkForced(var0, var1);
    }

    public void move(EntityPlayer var0) {
        if (!var0.isRemoved()) {
            this.chunkMap.move(var0);
        }
    }

    public void removeEntity(Entity var0) {
        this.chunkMap.removeEntity(var0);
    }

    public void addEntity(Entity var0) {
        this.chunkMap.addEntity(var0);
    }

    public void broadcastAndSend(Entity var0, Packet<?> var1) {
        this.chunkMap.broadcastAndSend(var0, var1);
    }

    public void broadcast(Entity var0, Packet<?> var1) {
        this.chunkMap.broadcast(var0, var1);
    }

    public void setViewDistance(int var0) {
        this.chunkMap.setServerViewDistance(var0);
    }

    public void setSimulationDistance(int var0) {
        this.distanceManager.updateSimulationDistance(var0);
    }

    @Override
    public void setSpawnSettings(boolean var0, boolean var1) {
        this.spawnEnemies = var0;
        this.spawnFriendlies = var1;
    }

    public String getChunkDebugData(ChunkCoordIntPair var0) {
        return this.chunkMap.getChunkDebugData(var0);
    }

    public WorldPersistentData getDataStorage() {
        return this.dataStorage;
    }

    public VillagePlace getPoiManager() {
        return this.chunkMap.getPoiManager();
    }

    public ChunkScanAccess chunkScanner() {
        return this.chunkMap.chunkScanner();
    }

    @Nullable
    @VisibleForDebug
    public SpawnerCreature.d getLastSpawnState() {
        return this.lastSpawnState;
    }

    public void removeTicketsOnClosing() {
        this.distanceManager.removeTicketsOnClosing();
    }

    @Override
    public /* synthetic */ LevelLightEngine getLightEngine() {
        return this.getLightEngine();
    }

    @Override
    public /* synthetic */ IBlockAccess getLevel() {
        return this.getLevel();
    }

    final class b
    extends IAsyncTaskHandler<Runnable> {
        b(World var1) {
            super("Chunk source main thread executor for " + var1.dimension().location());
        }

        @Override
        protected Runnable wrapRunnable(Runnable var0) {
            return var0;
        }

        @Override
        protected boolean shouldRun(Runnable var0) {
            return true;
        }

        @Override
        protected boolean scheduleExecutables() {
            return true;
        }

        @Override
        protected Thread getRunningThread() {
            return ChunkProviderServer.this.mainThread;
        }

        @Override
        protected void doRunTask(Runnable var0) {
            ChunkProviderServer.this.level.getProfiler().incrementCounter("runTask");
            super.doRunTask(var0);
        }

        @Override
        protected boolean pollTask() {
            if (ChunkProviderServer.this.runDistanceManagerUpdates()) {
                return true;
            }
            ChunkProviderServer.this.lightEngine.tryScheduleUpdate();
            return super.pollTask();
        }
    }

    static final class a
    extends Record {
        final Chunk chunk;
        final PlayerChunk holder;

        a(Chunk var0, PlayerChunk var1) {
            this.chunk = var0;
            this.holder = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "chunk;holder", "chunk", "holder"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "chunk;holder", "chunk", "holder"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "chunk;holder", "chunk", "holder"}, this, var0);
        }

        public Chunk chunk() {
            return this.chunk;
        }

        public PlayerChunk holder() {
            return this.holder;
        }
    }
}

