/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.world.level.chunk.ChunkStatus;

public class ChunkLevel {
    private static final int FULL_CHUNK_LEVEL = 33;
    private static final int BLOCK_TICKING_LEVEL = 32;
    private static final int ENTITY_TICKING_LEVEL = 31;
    public static final int MAX_LEVEL = 33 + ChunkStatus.maxDistance();

    public static ChunkStatus generationStatus(int var0) {
        if (var0 < 33) {
            return ChunkStatus.FULL;
        }
        return ChunkStatus.getStatusAroundFullChunk(var0 - 33);
    }

    public static int byStatus(ChunkStatus var0) {
        return 33 + ChunkStatus.getDistance(var0);
    }

    public static FullChunkStatus fullStatus(int var0) {
        if (var0 <= 31) {
            return FullChunkStatus.ENTITY_TICKING;
        }
        if (var0 <= 32) {
            return FullChunkStatus.BLOCK_TICKING;
        }
        if (var0 <= 33) {
            return FullChunkStatus.FULL;
        }
        return FullChunkStatus.INACCESSIBLE;
    }

    public static int byStatus(FullChunkStatus var0) {
        return switch (var0) {
            default -> throw new IncompatibleClassChangeError();
            case FullChunkStatus.INACCESSIBLE -> MAX_LEVEL;
            case FullChunkStatus.FULL -> 33;
            case FullChunkStatus.BLOCK_TICKING -> 32;
            case FullChunkStatus.ENTITY_TICKING -> 31;
        };
    }

    public static boolean isEntityTicking(int var0) {
        return var0 <= 31;
    }

    public static boolean isBlockTicking(int var0) {
        return var0 <= 32;
    }

    public static boolean isLoaded(int var0) {
        return var0 <= MAX_LEVEL;
    }
}

