/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutBoss;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;

public class BossBattleServer
extends BossBattle {
    private final Set<EntityPlayer> players = Sets.newHashSet();
    private final Set<EntityPlayer> unmodifiablePlayers = Collections.unmodifiableSet(this.players);
    public boolean visible = true;

    public BossBattleServer(IChatBaseComponent var0, BossBattle.BarColor var1, BossBattle.BarStyle var2) {
        super(MathHelper.createInsecureUUID(), var0, var1, var2);
    }

    @Override
    public void setProgress(float var0) {
        if (var0 != this.progress) {
            super.setProgress(var0);
            this.broadcast(PacketPlayOutBoss::createUpdateProgressPacket);
        }
    }

    @Override
    public void setColor(BossBattle.BarColor var0) {
        if (var0 != this.color) {
            super.setColor(var0);
            this.broadcast(PacketPlayOutBoss::createUpdateStylePacket);
        }
    }

    @Override
    public void setOverlay(BossBattle.BarStyle var0) {
        if (var0 != this.overlay) {
            super.setOverlay(var0);
            this.broadcast(PacketPlayOutBoss::createUpdateStylePacket);
        }
    }

    @Override
    public BossBattle setDarkenScreen(boolean var0) {
        if (var0 != this.darkenScreen) {
            super.setDarkenScreen(var0);
            this.broadcast(PacketPlayOutBoss::createUpdatePropertiesPacket);
        }
        return this;
    }

    @Override
    public BossBattle setPlayBossMusic(boolean var0) {
        if (var0 != this.playBossMusic) {
            super.setPlayBossMusic(var0);
            this.broadcast(PacketPlayOutBoss::createUpdatePropertiesPacket);
        }
        return this;
    }

    @Override
    public BossBattle setCreateWorldFog(boolean var0) {
        if (var0 != this.createWorldFog) {
            super.setCreateWorldFog(var0);
            this.broadcast(PacketPlayOutBoss::createUpdatePropertiesPacket);
        }
        return this;
    }

    @Override
    public void setName(IChatBaseComponent var0) {
        if (!Objects.equal((Object)var0, (Object)this.name)) {
            super.setName(var0);
            this.broadcast(PacketPlayOutBoss::createUpdateNamePacket);
        }
    }

    public void broadcast(Function<BossBattle, PacketPlayOutBoss> var0) {
        if (this.visible) {
            PacketPlayOutBoss var1 = var0.apply(this);
            for (EntityPlayer var3 : this.players) {
                var3.connection.send(var1);
            }
        }
    }

    public void addPlayer(EntityPlayer var0) {
        if (this.players.add(var0) && this.visible) {
            var0.connection.send(PacketPlayOutBoss.createAddPacket(this));
        }
    }

    public void removePlayer(EntityPlayer var0) {
        if (this.players.remove(var0) && this.visible) {
            var0.connection.send(PacketPlayOutBoss.createRemovePacket(this.getId()));
        }
    }

    public void removeAllPlayers() {
        if (!this.players.isEmpty()) {
            for (EntityPlayer var1 : Lists.newArrayList(this.players)) {
                this.removePlayer(var1);
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean var0) {
        if (var0 != this.visible) {
            this.visible = var0;
            for (EntityPlayer var2 : this.players) {
                var2.connection.send(var0 ? PacketPlayOutBoss.createAddPacket(this) : PacketPlayOutBoss.createRemovePacket(this.getId()));
            }
        }
    }

    public Collection<EntityPlayer> getPlayers() {
        return this.unmodifiablePlayers;
    }
}

