/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomCommandExecutor;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.execution.tasks.FallthroughTask;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.commands.data.CommandDataAccessor;

public class CommandFunction {
    private static final DynamicCommandExceptionType ERROR_ARGUMENT_NOT_COMPOUND = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.function.error.argument_not_compound", var0));
    static final DynamicCommandExceptionType ERROR_NO_FUNCTIONS = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.function.scheduled.no_functions", var0));
    @VisibleForTesting
    public static final Dynamic2CommandExceptionType ERROR_FUNCTION_INSTANTATION_FAILURE = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("commands.function.instantiationFailure", var0, var1));
    public static final SuggestionProvider<CommandListenerWrapper> SUGGEST_FUNCTION = (var0, var1) -> {
        CustomFunctionData var2 = ((CommandListenerWrapper)var0.getSource()).getServer().getFunctions();
        ICompletionProvider.suggestResource(var2.getTagNames(), var1, "#");
        return ICompletionProvider.suggestResource(var2.getFunctionNames(), var1);
    };
    static final b<CommandListenerWrapper> FULL_CONTEXT_CALLBACKS = new b<CommandListenerWrapper>(){

        @Override
        public void signalResult(CommandListenerWrapper var0, MinecraftKey var1, int var2) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.function.result", IChatBaseComponent.translationArg(var1), var2), true);
        }
    };

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        LiteralArgumentBuilder<CommandListenerWrapper> var12 = net.minecraft.commands.CommandDispatcher.literal("with");
        for (final CommandData.c var3 : CommandData.SOURCE_PROVIDERS) {
            var3.wrap((ArgumentBuilder<CommandListenerWrapper, ?>)var12, var1 -> var1.executes((Command)new c(){

                @Override
                protected NBTTagCompound arguments(CommandContext<CommandListenerWrapper> var0) throws CommandSyntaxException {
                    return var3.access(var0).getData();
                }
            }).then(net.minecraft.commands.CommandDispatcher.argument("path", ArgumentNBTKey.nbtPath()).executes((Command)new c(){

                @Override
                protected NBTTagCompound arguments(CommandContext<CommandListenerWrapper> var0) throws CommandSyntaxException {
                    return CommandFunction.getArgumentTag(ArgumentNBTKey.getPath(var0, "path"), var3.access(var0));
                }
            })));
        }
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("function").requires(var0 -> var0.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("name", ArgumentTag.functions()).suggests(SUGGEST_FUNCTION).executes((Command)new c(){

            @Override
            @Nullable
            protected NBTTagCompound arguments(CommandContext<CommandListenerWrapper> var0) {
                return null;
            }
        })).then(net.minecraft.commands.CommandDispatcher.argument("arguments", ArgumentNBTTag.compoundTag()).executes((Command)new c(){

            @Override
            protected NBTTagCompound arguments(CommandContext<CommandListenerWrapper> var0) {
                return ArgumentNBTTag.getCompoundTag(var0, "arguments");
            }
        }))).then(var12)));
    }

    static NBTTagCompound getArgumentTag(ArgumentNBTKey.g var0, CommandDataAccessor var1) throws CommandSyntaxException {
        NBTBase var2 = CommandData.getSingleTag(var0, var1);
        if (var2 instanceof NBTTagCompound) {
            NBTTagCompound var3 = (NBTTagCompound)var2;
            return var3;
        }
        throw ERROR_ARGUMENT_NOT_COMPOUND.create((Object)var2.getType().getName());
    }

    public static CommandListenerWrapper modifySenderForExecution(CommandListenerWrapper var0) {
        return var0.withSuppressedOutput().withMaximumPermission(2);
    }

    public static <T extends ExecutionCommandSource<T>> void queueFunctions(Collection<net.minecraft.commands.functions.CommandFunction<T>> var0, @Nullable NBTTagCompound var1, T var2, T var3, ExecutionControl<T> var4, b<T> var5, ChainModifiers var6) throws CommandSyntaxException {
        if (var6.isReturn()) {
            CommandFunction.queueFunctionsAsReturn(var0, var1, var2, var3, var4, var5);
        } else {
            CommandFunction.queueFunctionsNoReturn(var0, var1, var2, var3, var4, var5);
        }
    }

    private static <T extends ExecutionCommandSource<T>> void instantiateAndQueueFunctions(@Nullable NBTTagCompound var0, ExecutionControl<T> var1, CommandDispatcher<T> var2, T var3, net.minecraft.commands.functions.CommandFunction<T> var4, MinecraftKey var5, CommandResultCallback var6, boolean var7) throws CommandSyntaxException {
        try {
            InstantiatedFunction<T> var8 = var4.instantiate(var0, var2, var3);
            var1.queueNext(new CallFunction<T>(var8, var6, var7).bind(var3));
        }
        catch (FunctionInstantiationException var8) {
            throw ERROR_FUNCTION_INSTANTATION_FAILURE.create((Object)var5, (Object)var8.messageComponent());
        }
    }

    private static <T extends ExecutionCommandSource<T>> CommandResultCallback decorateOutputIfNeeded(T var0, b<T> var1, MinecraftKey var2, CommandResultCallback var3) {
        if (var0.isSilent()) {
            return var3;
        }
        return (var4, var5) -> {
            var1.signalResult(var0, var2, var5);
            var3.onSuccess(var5);
        };
    }

    private static <T extends ExecutionCommandSource<T>> void queueFunctionsAsReturn(Collection<net.minecraft.commands.functions.CommandFunction<T>> var0, @Nullable NBTTagCompound var1, T var2, T var3, ExecutionControl<T> var4, b<T> var5) throws CommandSyntaxException {
        CommandDispatcher<T> var6 = var2.dispatcher();
        T var7 = var3.clearCallbacks();
        CommandResultCallback var8 = CommandResultCallback.chain(var2.callback(), var4.currentFrame().returnValueConsumer());
        for (net.minecraft.commands.functions.CommandFunction<T> var10 : var0) {
            MinecraftKey var11 = var10.id();
            CommandResultCallback var12 = CommandFunction.decorateOutputIfNeeded(var2, var5, var11, var8);
            CommandFunction.instantiateAndQueueFunctions(var1, var4, var6, var7, var10, var11, var12, true);
        }
        if (var8 == CommandResultCallback.EMPTY) {
            return;
        }
        var4.queueNext(FallthroughTask.instance());
    }

    private static <T extends ExecutionCommandSource<T>> void queueFunctionsNoReturn(Collection<net.minecraft.commands.functions.CommandFunction<T>> var0, @Nullable NBTTagCompound var12, T var22, T var32, ExecutionControl<T> var4, b<T> var5) throws CommandSyntaxException {
        CommandDispatcher<T> var6 = var22.dispatcher();
        T var7 = var32.clearCallbacks();
        CommandResultCallback var8 = var22.callback();
        if (var0.isEmpty()) {
            return;
        }
        if (var0.size() == 1) {
            net.minecraft.commands.functions.CommandFunction<T> var9 = var0.iterator().next();
            MinecraftKey var10 = var9.id();
            CommandResultCallback var11 = CommandFunction.decorateOutputIfNeeded(var22, var5, var10, var8);
            CommandFunction.instantiateAndQueueFunctions(var12, var4, var6, var7, var9, var10, var11, false);
        } else if (var8 == CommandResultCallback.EMPTY) {
            for (net.minecraft.commands.functions.CommandFunction<T> var10 : var0) {
                MinecraftKey var11 = var10.id();
                CommandResultCallback var122 = CommandFunction.decorateOutputIfNeeded(var22, var5, var11, var8);
                CommandFunction.instantiateAndQueueFunctions(var12, var4, var6, var7, var10, var11, var122, false);
            }
        } else {
            class A {
                boolean anyResult;
                int sum;

                A() {
                }

                public void add(int var0) {
                    this.anyResult = true;
                    this.sum += var0;
                }
            }
            A var9 = new A();
            CommandResultCallback var10 = (var1, var2) -> var9.add(var2);
            for (net.minecraft.commands.functions.CommandFunction<T> var123 : var0) {
                MinecraftKey var13 = var123.id();
                CommandResultCallback var14 = CommandFunction.decorateOutputIfNeeded(var22, var5, var13, var10);
                CommandFunction.instantiateAndQueueFunctions(var12, var4, var6, var7, var123, var13, var14, false);
            }
            var4.queueNext((var2, var3) -> {
                if (var0.anyResult) {
                    var8.onSuccess(var0.sum);
                }
            });
        }
    }

    public static interface b<T> {
        public void signalResult(T var1, MinecraftKey var2, int var3);
    }

    static abstract class c
    extends CustomCommandExecutor.b<CommandListenerWrapper>
    implements CustomCommandExecutor.a<CommandListenerWrapper> {
        c() {
        }

        @Nullable
        protected abstract NBTTagCompound arguments(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;

        @Override
        public void runGuarded(CommandListenerWrapper var0, ContextChain<CommandListenerWrapper> var1, ChainModifiers var2, ExecutionControl<CommandListenerWrapper> var3) throws CommandSyntaxException {
            CommandContext var4 = var1.getTopContext().copyFor((Object)var0);
            Pair<MinecraftKey, Collection<net.minecraft.commands.functions.CommandFunction<CommandListenerWrapper>>> var5 = ArgumentTag.getFunctionCollection((CommandContext<CommandListenerWrapper>)var4, "name");
            Collection var6 = (Collection)var5.getSecond();
            if (var6.isEmpty()) {
                throw ERROR_NO_FUNCTIONS.create((Object)IChatBaseComponent.translationArg((MinecraftKey)var5.getFirst()));
            }
            NBTTagCompound var7 = this.arguments((CommandContext<CommandListenerWrapper>)var4);
            CommandListenerWrapper var8 = CommandFunction.modifySenderForExecution(var0);
            if (var6.size() == 1) {
                var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.function.scheduled.single", IChatBaseComponent.translationArg(((net.minecraft.commands.functions.CommandFunction)var6.iterator().next()).id())), true);
            } else {
                var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.function.scheduled.multiple", ChatComponentUtils.formatList(var6.stream().map(net.minecraft.commands.functions.CommandFunction::id).toList(), IChatBaseComponent::translationArg)), true);
            }
            CommandFunction.queueFunctions(var6, var7, var0, var8, var3, FULL_CONTEXT_CALLBACKS, var2);
        }

        @Override
        public /* synthetic */ void runGuarded(ExecutionCommandSource executionCommandSource, ContextChain contextChain, ChainModifiers chainModifiers, ExecutionControl executionControl) throws CommandSyntaxException {
            this.runGuarded((CommandListenerWrapper)executionCommandSource, (ContextChain<CommandListenerWrapper>)contextChain, chainModifiers, (ExecutionControl<CommandListenerWrapper>)executionControl);
        }
    }
}

