/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.base.Joiner;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.BlockPosition2D;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;

public class CommandForceload {
    private static final int MAX_CHUNK_LIMIT = 256;
    private static final Dynamic2CommandExceptionType ERROR_TOO_MANY_CHUNKS = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("commands.forceload.toobig", var0, var1));
    private static final Dynamic2CommandExceptionType ERROR_NOT_TICKING = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("commands.forceload.query.failure", var0, var1));
    private static final SimpleCommandExceptionType ERROR_ALL_ADDED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.forceload.added.failure"));
    private static final SimpleCommandExceptionType ERROR_NONE_REMOVED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.forceload.removed.failure"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("forceload").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.literal("add").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("from", ArgumentVec2I.columnPos()).executes(var0 -> CommandForceload.changeForceLoad((CommandListenerWrapper)var0.getSource(), ArgumentVec2I.getColumnPos((CommandContext<CommandListenerWrapper>)var0, "from"), ArgumentVec2I.getColumnPos((CommandContext<CommandListenerWrapper>)var0, "from"), true))).then(net.minecraft.commands.CommandDispatcher.argument("to", ArgumentVec2I.columnPos()).executes(var0 -> CommandForceload.changeForceLoad((CommandListenerWrapper)var0.getSource(), ArgumentVec2I.getColumnPos((CommandContext<CommandListenerWrapper>)var0, "from"), ArgumentVec2I.getColumnPos((CommandContext<CommandListenerWrapper>)var0, "to"), true)))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("remove").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("from", ArgumentVec2I.columnPos()).executes(var0 -> CommandForceload.changeForceLoad((CommandListenerWrapper)var0.getSource(), ArgumentVec2I.getColumnPos((CommandContext<CommandListenerWrapper>)var0, "from"), ArgumentVec2I.getColumnPos((CommandContext<CommandListenerWrapper>)var0, "from"), false))).then(net.minecraft.commands.CommandDispatcher.argument("to", ArgumentVec2I.columnPos()).executes(var0 -> CommandForceload.changeForceLoad((CommandListenerWrapper)var0.getSource(), ArgumentVec2I.getColumnPos((CommandContext<CommandListenerWrapper>)var0, "from"), ArgumentVec2I.getColumnPos((CommandContext<CommandListenerWrapper>)var0, "to"), false))))).then(net.minecraft.commands.CommandDispatcher.literal("all").executes(var0 -> CommandForceload.removeAll((CommandListenerWrapper)var0.getSource()))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("query").executes(var0 -> CommandForceload.listForceLoad((CommandListenerWrapper)var0.getSource()))).then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentVec2I.columnPos()).executes(var0 -> CommandForceload.queryForceLoad((CommandListenerWrapper)var0.getSource(), ArgumentVec2I.getColumnPos((CommandContext<CommandListenerWrapper>)var0, "pos"))))));
    }

    private static int queryForceLoad(CommandListenerWrapper var0, BlockPosition2D var1) throws CommandSyntaxException {
        ChunkCoordIntPair var2 = var1.toChunkPos();
        WorldServer var3 = var0.getLevel();
        ResourceKey<World> var4 = var3.dimension();
        boolean var5 = var3.getForcedChunks().contains(var2.toLong());
        if (var5) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.forceload.query.success", IChatBaseComponent.translationArg(var2), IChatBaseComponent.translationArg(var4.location())), false);
            return 1;
        }
        throw ERROR_NOT_TICKING.create((Object)var2, (Object)var4.location());
    }

    private static int listForceLoad(CommandListenerWrapper var0) {
        WorldServer var1 = var0.getLevel();
        ResourceKey<World> var2 = var1.dimension();
        LongSet var3 = var1.getForcedChunks();
        int var4 = var3.size();
        if (var4 > 0) {
            String var5 = Joiner.on((String)", ").join(var3.stream().sorted().map(ChunkCoordIntPair::new).map(ChunkCoordIntPair::toString).iterator());
            if (var4 == 1) {
                var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.forceload.list.single", IChatBaseComponent.translationArg(var2.location()), var5), false);
            } else {
                var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.forceload.list.multiple", var4, IChatBaseComponent.translationArg(var2.location()), var5), false);
            }
        } else {
            var0.sendFailure(IChatBaseComponent.translatable("commands.forceload.added.none", IChatBaseComponent.translationArg(var2.location())));
        }
        return var4;
    }

    private static int removeAll(CommandListenerWrapper var0) {
        WorldServer var12 = var0.getLevel();
        ResourceKey<World> var2 = var12.dimension();
        LongSet var3 = var12.getForcedChunks();
        var3.forEach(var1 -> var12.setChunkForced(ChunkCoordIntPair.getX(var1), ChunkCoordIntPair.getZ(var1), false));
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.forceload.removed.all", IChatBaseComponent.translationArg(var2.location())), true);
        return 0;
    }

    private static int changeForceLoad(CommandListenerWrapper var0, BlockPosition2D var1, BlockPosition2D var2, boolean var3) throws CommandSyntaxException {
        int var11;
        int var4 = Math.min(var1.x(), var2.x());
        int var5 = Math.min(var1.z(), var2.z());
        int var6 = Math.max(var1.x(), var2.x());
        int var7 = Math.max(var1.z(), var2.z());
        if (var4 < -30000000 || var5 < -30000000 || var6 >= 30000000 || var7 >= 30000000) {
            throw ArgumentPosition.ERROR_OUT_OF_WORLD.create();
        }
        int var8 = SectionPosition.blockToSectionCoord(var4);
        int var9 = SectionPosition.blockToSectionCoord(var5);
        int var10 = SectionPosition.blockToSectionCoord(var6);
        long var12 = ((long)(var10 - var8) + 1L) * ((long)((var11 = SectionPosition.blockToSectionCoord(var7)) - var9) + 1L);
        if (var12 > 256L) {
            throw ERROR_TOO_MANY_CHUNKS.create((Object)256, (Object)var12);
        }
        WorldServer var14 = var0.getLevel();
        ResourceKey<World> var15 = var14.dimension();
        ChunkCoordIntPair var16 = null;
        int var17 = 0;
        for (int var18 = var8; var18 <= var10; ++var18) {
            for (int var19 = var9; var19 <= var11; ++var19) {
                boolean var20 = var14.setChunkForced(var18, var19, var3);
                if (!var20) continue;
                ++var17;
                if (var16 != null) continue;
                var16 = new ChunkCoordIntPair(var18, var19);
            }
        }
        ChunkCoordIntPair var18 = var16;
        if (var17 == 0) {
            throw (var3 ? ERROR_ALL_ADDED : ERROR_NONE_REMOVED).create();
        }
        if (var17 == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.forceload." + (var3 ? "added" : "removed") + ".single", IChatBaseComponent.translationArg(var18), IChatBaseComponent.translationArg(var15.location())), true);
        } else {
            ChunkCoordIntPair var19 = new ChunkCoordIntPair(var8, var9);
            ChunkCoordIntPair var20 = new ChunkCoordIntPair(var10, var11);
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.forceload." + (var3 ? "added" : "removed") + ".multiple", IChatBaseComponent.translationArg(var18), IChatBaseComponent.translationArg(var15.location()), IChatBaseComponent.translationArg(var19), IChatBaseComponent.translationArg(var20)), true);
        }
        return var17;
    }
}

