/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.bossevents.BossBattleCustom;
import net.minecraft.server.bossevents.BossBattleCustomData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.BossBattle;
import net.minecraft.world.entity.player.EntityHuman;

public class CommandBossBar {
    private static final DynamicCommandExceptionType ERROR_ALREADY_EXISTS = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.bossbar.create.failed", var0));
    private static final DynamicCommandExceptionType ERROR_DOESNT_EXIST = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.bossbar.unknown", var0));
    private static final SimpleCommandExceptionType ERROR_NO_PLAYER_CHANGE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.bossbar.set.players.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_NAME_CHANGE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.bossbar.set.name.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_COLOR_CHANGE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.bossbar.set.color.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_STYLE_CHANGE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.bossbar.set.style.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_VALUE_CHANGE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.bossbar.set.value.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_MAX_CHANGE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.bossbar.set.max.unchanged"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_HIDDEN = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.bossbar.set.visibility.unchanged.hidden"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_VISIBLE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.bossbar.set.visibility.unchanged.visible"));
    public static final SuggestionProvider<CommandListenerWrapper> SUGGEST_BOSS_BAR = (var0, var1) -> ICompletionProvider.suggestResource(((CommandListenerWrapper)var0.getSource()).getServer().getCustomBossEvents().getIds(), var1);

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("bossbar").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.literal("add").then(net.minecraft.commands.CommandDispatcher.argument("id", ArgumentMinecraftKeyRegistered.id()).then(net.minecraft.commands.CommandDispatcher.argument("name", ArgumentChatComponent.textComponent()).executes(var0 -> CommandBossBar.createBar((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "id"), ArgumentChatComponent.getComponent((CommandContext<CommandListenerWrapper>)var0, "name"))))))).then(net.minecraft.commands.CommandDispatcher.literal("remove").then(net.minecraft.commands.CommandDispatcher.argument("id", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_BOSS_BAR).executes(var0 -> CommandBossBar.removeBar((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0)))))).then(net.minecraft.commands.CommandDispatcher.literal("list").executes(var0 -> CommandBossBar.listBars((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("id", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_BOSS_BAR).then(net.minecraft.commands.CommandDispatcher.literal("name").then(net.minecraft.commands.CommandDispatcher.argument("name", ArgumentChatComponent.textComponent()).executes(var0 -> CommandBossBar.setName((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), ArgumentChatComponent.getComponent((CommandContext<CommandListenerWrapper>)var0, "name")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("color").then(net.minecraft.commands.CommandDispatcher.literal("pink").executes(var0 -> CommandBossBar.setColor((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), BossBattle.BarColor.PINK)))).then(net.minecraft.commands.CommandDispatcher.literal("blue").executes(var0 -> CommandBossBar.setColor((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), BossBattle.BarColor.BLUE)))).then(net.minecraft.commands.CommandDispatcher.literal("red").executes(var0 -> CommandBossBar.setColor((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), BossBattle.BarColor.RED)))).then(net.minecraft.commands.CommandDispatcher.literal("green").executes(var0 -> CommandBossBar.setColor((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), BossBattle.BarColor.GREEN)))).then(net.minecraft.commands.CommandDispatcher.literal("yellow").executes(var0 -> CommandBossBar.setColor((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), BossBattle.BarColor.YELLOW)))).then(net.minecraft.commands.CommandDispatcher.literal("purple").executes(var0 -> CommandBossBar.setColor((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), BossBattle.BarColor.PURPLE)))).then(net.minecraft.commands.CommandDispatcher.literal("white").executes(var0 -> CommandBossBar.setColor((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), BossBattle.BarColor.WHITE))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("style").then(net.minecraft.commands.CommandDispatcher.literal("progress").executes(var0 -> CommandBossBar.setStyle((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), BossBattle.BarStyle.PROGRESS)))).then(net.minecraft.commands.CommandDispatcher.literal("notched_6").executes(var0 -> CommandBossBar.setStyle((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), BossBattle.BarStyle.NOTCHED_6)))).then(net.minecraft.commands.CommandDispatcher.literal("notched_10").executes(var0 -> CommandBossBar.setStyle((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), BossBattle.BarStyle.NOTCHED_10)))).then(net.minecraft.commands.CommandDispatcher.literal("notched_12").executes(var0 -> CommandBossBar.setStyle((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), BossBattle.BarStyle.NOTCHED_12)))).then(net.minecraft.commands.CommandDispatcher.literal("notched_20").executes(var0 -> CommandBossBar.setStyle((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), BossBattle.BarStyle.NOTCHED_20))))).then(net.minecraft.commands.CommandDispatcher.literal("value").then(net.minecraft.commands.CommandDispatcher.argument("value", IntegerArgumentType.integer((int)0)).executes(var0 -> CommandBossBar.setValue((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), IntegerArgumentType.getInteger((CommandContext)var0, (String)"value")))))).then(net.minecraft.commands.CommandDispatcher.literal("max").then(net.minecraft.commands.CommandDispatcher.argument("max", IntegerArgumentType.integer((int)1)).executes(var0 -> CommandBossBar.setMax((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), IntegerArgumentType.getInteger((CommandContext)var0, (String)"max")))))).then(net.minecraft.commands.CommandDispatcher.literal("visible").then(net.minecraft.commands.CommandDispatcher.argument("visible", BoolArgumentType.bool()).executes(var0 -> CommandBossBar.setVisible((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), BoolArgumentType.getBool((CommandContext)var0, (String)"visible")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("players").executes(var0 -> CommandBossBar.setPlayers((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), Collections.emptyList()))).then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).executes(var0 -> CommandBossBar.setPlayers((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0), ArgumentEntity.getOptionalPlayers((CommandContext<CommandListenerWrapper>)var0, "targets")))))))).then(net.minecraft.commands.CommandDispatcher.literal("get").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("id", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_BOSS_BAR).then(net.minecraft.commands.CommandDispatcher.literal("value").executes(var0 -> CommandBossBar.getValue((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0))))).then(net.minecraft.commands.CommandDispatcher.literal("max").executes(var0 -> CommandBossBar.getMax((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0))))).then(net.minecraft.commands.CommandDispatcher.literal("visible").executes(var0 -> CommandBossBar.getVisible((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0))))).then(net.minecraft.commands.CommandDispatcher.literal("players").executes(var0 -> CommandBossBar.getPlayers((CommandListenerWrapper)var0.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var0)))))));
    }

    private static int getValue(CommandListenerWrapper var0, BossBattleCustom var1) {
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.get.value", var1.getDisplayName(), var1.getValue()), true);
        return var1.getValue();
    }

    private static int getMax(CommandListenerWrapper var0, BossBattleCustom var1) {
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.get.max", var1.getDisplayName(), var1.getMax()), true);
        return var1.getMax();
    }

    private static int getVisible(CommandListenerWrapper var0, BossBattleCustom var1) {
        if (var1.isVisible()) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.get.visible.visible", var1.getDisplayName()), true);
            return 1;
        }
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.get.visible.hidden", var1.getDisplayName()), true);
        return 0;
    }

    private static int getPlayers(CommandListenerWrapper var0, BossBattleCustom var1) {
        if (var1.getPlayers().isEmpty()) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.get.players.none", var1.getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.get.players.some", var1.getDisplayName(), var1.getPlayers().size(), ChatComponentUtils.formatList(var1.getPlayers(), EntityHuman::getDisplayName)), true);
        }
        return var1.getPlayers().size();
    }

    private static int setVisible(CommandListenerWrapper var0, BossBattleCustom var1, boolean var2) throws CommandSyntaxException {
        if (var1.isVisible() == var2) {
            if (var2) {
                throw ERROR_ALREADY_VISIBLE.create();
            }
            throw ERROR_ALREADY_HIDDEN.create();
        }
        var1.setVisible(var2);
        if (var2) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.set.visible.success.visible", var1.getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.set.visible.success.hidden", var1.getDisplayName()), true);
        }
        return 0;
    }

    private static int setValue(CommandListenerWrapper var0, BossBattleCustom var1, int var2) throws CommandSyntaxException {
        if (var1.getValue() == var2) {
            throw ERROR_NO_VALUE_CHANGE.create();
        }
        var1.setValue(var2);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.set.value.success", var1.getDisplayName(), var2), true);
        return var2;
    }

    private static int setMax(CommandListenerWrapper var0, BossBattleCustom var1, int var2) throws CommandSyntaxException {
        if (var1.getMax() == var2) {
            throw ERROR_NO_MAX_CHANGE.create();
        }
        var1.setMax(var2);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.set.max.success", var1.getDisplayName(), var2), true);
        return var2;
    }

    private static int setColor(CommandListenerWrapper var0, BossBattleCustom var1, BossBattle.BarColor var2) throws CommandSyntaxException {
        if (var1.getColor().equals((Object)var2)) {
            throw ERROR_NO_COLOR_CHANGE.create();
        }
        var1.setColor(var2);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.set.color.success", var1.getDisplayName()), true);
        return 0;
    }

    private static int setStyle(CommandListenerWrapper var0, BossBattleCustom var1, BossBattle.BarStyle var2) throws CommandSyntaxException {
        if (var1.getOverlay().equals((Object)var2)) {
            throw ERROR_NO_STYLE_CHANGE.create();
        }
        var1.setOverlay(var2);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.set.style.success", var1.getDisplayName()), true);
        return 0;
    }

    private static int setName(CommandListenerWrapper var0, BossBattleCustom var1, IChatBaseComponent var2) throws CommandSyntaxException {
        IChatMutableComponent var3 = ChatComponentUtils.updateForEntity(var0, var2, null, 0);
        if (var1.getName().equals(var3)) {
            throw ERROR_NO_NAME_CHANGE.create();
        }
        var1.setName(var3);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.set.name.success", var1.getDisplayName()), true);
        return 0;
    }

    private static int setPlayers(CommandListenerWrapper var0, BossBattleCustom var1, Collection<EntityPlayer> var2) throws CommandSyntaxException {
        boolean var3 = var1.setPlayers(var2);
        if (!var3) {
            throw ERROR_NO_PLAYER_CHANGE.create();
        }
        if (var1.getPlayers().isEmpty()) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.set.players.success.none", var1.getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.set.players.success.some", var1.getDisplayName(), var2.size(), ChatComponentUtils.formatList(var2, EntityHuman::getDisplayName)), true);
        }
        return var1.getPlayers().size();
    }

    private static int listBars(CommandListenerWrapper var0) {
        Collection<BossBattleCustom> var1 = var0.getServer().getCustomBossEvents().getEvents();
        if (var1.isEmpty()) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.list.bars.none"), false);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.list.bars.some", var1.size(), ChatComponentUtils.formatList(var1, BossBattleCustom::getDisplayName)), false);
        }
        return var1.size();
    }

    private static int createBar(CommandListenerWrapper var0, MinecraftKey var1, IChatBaseComponent var2) throws CommandSyntaxException {
        BossBattleCustomData var3 = var0.getServer().getCustomBossEvents();
        if (var3.get(var1) != null) {
            throw ERROR_ALREADY_EXISTS.create((Object)var1.toString());
        }
        BossBattleCustom var4 = var3.create(var1, ChatComponentUtils.updateForEntity(var0, var2, null, 0));
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.create.success", var4.getDisplayName()), true);
        return var3.getEvents().size();
    }

    private static int removeBar(CommandListenerWrapper var0, BossBattleCustom var1) {
        BossBattleCustomData var2 = var0.getServer().getCustomBossEvents();
        var1.removeAllPlayers();
        var2.remove(var1);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.bossbar.remove.success", var1.getDisplayName()), true);
        return var2.getEvents().size();
    }

    public static BossBattleCustom getBossBar(CommandContext<CommandListenerWrapper> var0) throws CommandSyntaxException {
        MinecraftKey var1 = ArgumentMinecraftKeyRegistered.getId(var0, "id");
        BossBattleCustom var2 = ((CommandListenerWrapper)var0.getSource()).getServer().getCustomBossEvents().get(var1);
        if (var2 == null) {
            throw ERROR_DOESNT_EXIST.create((Object)var1.toString());
        }
        return var2;
    }
}

