/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraft.CrashReport;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.EULA;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.progress.WorldLoadListenerLogger;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.repository.ResourcePackSourceVanilla;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import org.slf4j.Logger;

public class Main {
    private static final Logger LOGGER = LogUtils.getLogger();

    @DontObfuscate
    public static void main(String[] var0) {
        SharedConstants.tryDetectVersion();
        OptionParser var1 = new OptionParser();
        OptionSpecBuilder var2 = var1.accepts("nogui");
        OptionSpecBuilder var3 = var1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder var4 = var1.accepts("demo");
        OptionSpecBuilder var5 = var1.accepts("bonusChest");
        OptionSpecBuilder var6 = var1.accepts("forceUpgrade");
        OptionSpecBuilder var7 = var1.accepts("eraseCache");
        OptionSpecBuilder var8 = var1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec var9 = var1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec var10 = var1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec var11 = var1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec var12 = var1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec var13 = var1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder var14 = var1.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec var15 = var1.accepts("pidFile").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        NonOptionArgumentSpec var16 = var1.nonOptions();
        try {
            WorldStem var32;
            Object var33;
            Object var31;
            Object var29;
            Dynamic<?> var28;
            OptionSet var17 = var1.parse(var0);
            if (var17.has((OptionSpec)var9)) {
                var1.printHelpOn((OutputStream)System.err);
                return;
            }
            Path var18 = (Path)var17.valueOf((OptionSpec)var15);
            if (var18 != null) {
                Main.writePidFile(var18);
            }
            CrashReport.preload();
            if (var17.has((OptionSpec)var14)) {
                JvmProfiler.INSTANCE.start(Environment.SERVER);
            }
            DispenserRegistry.bootStrap();
            DispenserRegistry.validate();
            SystemUtils.startTimerHackThread();
            Path var19 = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings var20 = new DedicatedServerSettings(var19);
            var20.forceSave();
            Path var21 = Paths.get("eula.txt", new String[0]);
            EULA var22 = new EULA(var21);
            if (var17.has((OptionSpec)var3)) {
                LOGGER.info("Initialized '{}' and '{}'", (Object)var19.toAbsolutePath(), (Object)var21.toAbsolutePath());
                return;
            }
            if (!var22.hasAgreedToEULA()) {
                LOGGER.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File var23 = new File((String)var17.valueOf((OptionSpec)var10));
            Services var24 = Services.create(new YggdrasilAuthenticationService(Proxy.NO_PROXY), var23);
            String var25 = Optional.ofNullable((String)var17.valueOf((OptionSpec)var11)).orElse(var20.getProperties().levelName);
            Convertable var26 = Convertable.createDefault(var23.toPath());
            Convertable.ConversionSession var27 = var26.validateAndCreateAccess(var25);
            if (var27.hasWorldData()) {
                try {
                    var28 = var27.getDataTag();
                    var29 = var27.getSummary(var28);
                }
                catch (IOException | NbtException | ReportedNbtException var30) {
                    var31 = var27.getLevelDirectory();
                    LOGGER.warn("Failed to load world data from {}", (Object)((Convertable.b)var31).dataFile(), (Object)var30);
                    LOGGER.info("Attempting to use fallback");
                    try {
                        var28 = var27.getDataTagFallback();
                        var29 = var27.getSummary(var28);
                    }
                    catch (IOException | NbtException | ReportedNbtException var322) {
                        LOGGER.error("Failed to load world data from {}", (Object)((Convertable.b)var31).oldDataFile(), (Object)var322);
                        LOGGER.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)((Convertable.b)var31).dataFile(), (Object)((Convertable.b)var31).oldDataFile());
                        return;
                    }
                    var27.restoreLevelDataFromOld();
                }
                if (((WorldInfo)var29).requiresManualConversion()) {
                    LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!((WorldInfo)var29).isCompatible()) {
                    LOGGER.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                var28 = null;
            }
            var29 = var28;
            boolean var30 = var17.has((OptionSpec)var8);
            if (var30) {
                LOGGER.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            var31 = ResourcePackSourceVanilla.createPackRepository(var27);
            try {
                var33 = Main.loadOrCreateConfig(var20.getProperties(), var29, var30, (ResourcePackRepository)var31);
                var32 = (WorldStem)SystemUtils.blockUntilDone(arg_0 -> Main.a((WorldLoader.c)var33, (Dynamic)var29, var17, (OptionSpec)var4, var20, (OptionSpec)var5, arg_0)).get();
            }
            catch (Exception var332) {
                LOGGER.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)var332);
                return;
            }
            var33 = var32.registries().compositeAccess();
            if (var17.has((OptionSpec)var6)) {
                Main.forceUpgrade(var27, DataConverterRegistry.getDataFixer(), var17.has((OptionSpec)var7), () -> true, var33.registryOrThrow(Registries.LEVEL_STEM));
            }
            SaveData var34 = var32.worldData();
            var27.saveDataTag((IRegistryCustom)var33, var34);
            final DedicatedServer var35 = MinecraftServer.spin(arg_0 -> Main.a(var27, (ResourcePackRepository)var31, var32, var20, var24, var17, (OptionSpec)var12, (OptionSpec)var4, (OptionSpec)var13, (OptionSpec)var2, (OptionSpec)var16, arg_0));
            Thread var36 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    var35.halt(true);
                }
            };
            var36.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
            Runtime.getRuntime().addShutdownHook(var36);
        }
        catch (Exception var17) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)var17);
        }
    }

    private static void writePidFile(Path var0) {
        try {
            long var1 = ProcessHandle.current().pid();
            Files.writeString(var0, (CharSequence)Long.toString(var1), new OpenOption[0]);
        }
        catch (IOException var1) {
            throw new UncheckedIOException(var1);
        }
    }

    private static WorldLoader.c loadOrCreateConfig(DedicatedServerProperties var0, @Nullable Dynamic<?> var1, boolean var2, ResourcePackRepository var3) {
        WorldDataConfiguration var5;
        boolean var4;
        Record var6;
        if (var1 != null) {
            var6 = Convertable.readDataConfig(var1);
            var4 = false;
            var5 = var6;
        } else {
            var4 = true;
            var5 = new WorldDataConfiguration(var0.initialDataPackConfiguration, FeatureFlags.DEFAULT_FLAGS);
        }
        var6 = new WorldLoader.d(var3, var5, var2, var4);
        return new WorldLoader.c((WorldLoader.d)var6, CommandDispatcher.ServerType.DEDICATED, var0.functionPermissionLevel);
    }

    public static void forceUpgrade(Convertable.ConversionSession var0, DataFixer var1, boolean var2, BooleanSupplier var3, IRegistry<WorldDimension> var4) {
        LOGGER.info("Forcing world upgrade!");
        WorldUpgrader var5 = new WorldUpgrader(var0, var1, var4, var2);
        IChatBaseComponent var6 = null;
        while (!var5.isFinished()) {
            int var8;
            IChatBaseComponent var7 = var5.getStatus();
            if (var6 != var7) {
                var6 = var7;
                LOGGER.info(var5.getStatus().getString());
            }
            if ((var8 = var5.getTotalChunks()) > 0) {
                int var9 = var5.getConverted() + var5.getSkipped();
                LOGGER.info("{}% completed ({} / {} chunks)...", new Object[]{MathHelper.floor((float)var9 / (float)var8 * 100.0f), var9, var8});
            }
            if (!var3.getAsBoolean()) {
                var5.cancel();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ DedicatedServer a(Convertable.ConversionSession var0, ResourcePackRepository var1, WorldStem var2, DedicatedServerSettings var3, Services var4, OptionSet var5, OptionSpec var6, OptionSpec var7, OptionSpec var8, OptionSpec var9, OptionSpec var10, Thread var11) {
        boolean var13;
        DedicatedServer var12 = new DedicatedServer(var11, var0, var1, var2, var3, DataConverterRegistry.getDataFixer(), var4, WorldLoadListenerLogger::new);
        var12.setPort((Integer)var5.valueOf(var6));
        var12.setDemo(var5.has(var7));
        var12.setId((String)var5.valueOf(var8));
        boolean bl = var13 = !var5.has(var9) && !var5.valuesOf(var10).contains("nogui");
        if (var13 && !GraphicsEnvironment.isHeadless()) {
            var12.showGui();
        }
        return var12;
    }

    private static /* synthetic */ CompletableFuture a(WorldLoader.c var0, Dynamic var1, OptionSet var2, OptionSpec var3, DedicatedServerSettings var4, OptionSpec var52, Executor var6) {
        return WorldLoader.load(var0, var5 -> {
            Object var10;
            WorldDimensions var9;
            WorldOptions var8;
            WorldSettings var7;
            IRegistry<WorldDimension> var6 = var5.datapackDimensions().registryOrThrow(Registries.LEVEL_STEM);
            if (var1 != null) {
                LevelDataAndDimensions var72 = Convertable.getLevelDataAndDimensions(var1, var5.dataConfiguration(), var6, var5.datapackWorldgen());
                return new WorldLoader.b<SaveData>(var72.worldData(), var72.dimensions().dimensionsRegistryAccess());
            }
            LOGGER.info("No existing world data, creating new world");
            if (var2.has(var3)) {
                var7 = MinecraftServer.DEMO_SETTINGS;
                var8 = WorldOptions.DEMO_OPTIONS;
                var9 = WorldPresets.createNormalWorldDimensions(var5.datapackWorldgen());
            } else {
                var10 = var4.getProperties();
                var7 = new WorldSettings(((DedicatedServerProperties)var10).levelName, ((DedicatedServerProperties)var10).gamemode, ((DedicatedServerProperties)var10).hardcore, ((DedicatedServerProperties)var10).difficulty, false, new GameRules(), var5.dataConfiguration());
                var8 = var2.has(var52) ? ((DedicatedServerProperties)var10).worldOptions.withBonusChest(true) : ((DedicatedServerProperties)var10).worldOptions;
                var9 = ((DedicatedServerProperties)var10).createDimensions(var5.datapackWorldgen());
            }
            var10 = var9.bake(var6);
            Lifecycle var11 = ((WorldDimensions.b)var10).lifecycle().add(var5.datapackWorldgen().allRegistriesLifecycle());
            return new WorldLoader.b<WorldDataServer>(new WorldDataServer(var7, var8, ((WorldDimensions.b)var10).specialWorldProperty(), var11), ((WorldDimensions.b)var10).dimensionsRegistryAccess());
        }, WorldStem::new, SystemUtils.backgroundExecutor(), var6);
    }
}

