/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.level.storage.loot.LootDataManager;
import org.slf4j.Logger;

public class AdvancementDataWorld
extends ResourceDataJson {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Gson GSON = new GsonBuilder().create();
    public Map<MinecraftKey, AdvancementHolder> advancements = Map.of();
    private AdvancementTree tree = new AdvancementTree();
    private final LootDataManager lootData;

    public AdvancementDataWorld(LootDataManager var0) {
        super(GSON, "advancements");
        this.lootData = var0;
    }

    @Override
    protected void apply(Map<MinecraftKey, JsonElement> var0, IResourceManager var12, GameProfilerFiller var22) {
        ImmutableMap.Builder var3 = ImmutableMap.builder();
        var0.forEach((var1, var2) -> {
            try {
                Advancement var3 = (Advancement)SystemUtils.getOrThrow(Advancement.CODEC.parse((DynamicOps)JsonOps.INSTANCE, var2), JsonParseException::new);
                this.validate((MinecraftKey)var1, var3);
                var3.put(var1, (Object)new AdvancementHolder((MinecraftKey)var1, var3));
            }
            catch (Exception var3) {
                LOGGER.error("Parsing error loading custom advancement {}: {}", var1, (Object)var3.getMessage());
            }
        });
        this.advancements = var3.buildOrThrow();
        AdvancementTree var4 = new AdvancementTree();
        var4.addAll(this.advancements.values());
        for (AdvancementNode var6 : var4.roots()) {
            if (!var6.holder().value().display().isPresent()) continue;
            TreeNodePosition.run(var6);
        }
        this.tree = var4;
    }

    private void validate(MinecraftKey var02, Advancement var1) {
        ProblemReporter.a var2 = new ProblemReporter.a();
        var1.validate(var2, this.lootData);
        Multimap<String, String> var3 = var2.get();
        if (!var3.isEmpty()) {
            String var4 = var3.asMap().entrySet().stream().map(var0 -> "  at " + (String)var0.getKey() + ": " + String.join((CharSequence)"; ", (Iterable)var0.getValue())).collect(Collectors.joining("\n"));
            LOGGER.warn("Found validation problems in advancement {}: \n{}", (Object)var02, (Object)var4);
        }
    }

    @Nullable
    public AdvancementHolder get(MinecraftKey var0) {
        return this.advancements.get(var0);
    }

    public AdvancementTree tree() {
        return this.tree;
    }

    public Collection<AdvancementHolder> getAllAdvancements() {
        return this.advancements.values();
    }
}

