/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.syncher.DataWatcherObject;

public interface DataWatcherSerializer<T> {
    public void write(PacketDataSerializer var1, T var2);

    public T read(PacketDataSerializer var1);

    default public DataWatcherObject<T> createAccessor(int var0) {
        return new DataWatcherObject(var0, this);
    }

    public T copy(T var1);

    public static <T> DataWatcherSerializer<T> simple(final PacketDataSerializer.b<T> var0, final PacketDataSerializer.a<T> var1) {
        return new a<T>(){

            @Override
            public void write(PacketDataSerializer var02, T var12) {
                var0.accept(var02, var12);
            }

            @Override
            public T read(PacketDataSerializer var02) {
                return var1.apply(var02);
            }
        };
    }

    public static <T> DataWatcherSerializer<Optional<T>> optional(PacketDataSerializer.b<T> var0, PacketDataSerializer.a<T> var1) {
        return DataWatcherSerializer.simple(var0.asOptional(), var1.asOptional());
    }

    public static <T extends Enum<T>> DataWatcherSerializer<T> simpleEnum(Class<T> var0) {
        return DataWatcherSerializer.simple(PacketDataSerializer::writeEnum, var1 -> var1.readEnum(var0));
    }

    public static <T> DataWatcherSerializer<T> simpleId(Registry<T> var0) {
        return DataWatcherSerializer.simple((var1, var2) -> var1.writeId(var0, var2), var1 -> var1.readById(var0));
    }

    public static interface a<T>
    extends DataWatcherSerializer<T> {
        @Override
        default public T copy(T var0) {
            return var0;
        }
    }
}

