/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import java.security.PublicKey;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MinecraftEncryption;

public class PacketLoginOutEncryptionBegin
implements Packet<PacketLoginOutListener> {
    private final String serverId;
    private final byte[] publicKey;
    private final byte[] challenge;

    public PacketLoginOutEncryptionBegin(String var0, byte[] var1, byte[] var2) {
        this.serverId = var0;
        this.publicKey = var1;
        this.challenge = var2;
    }

    public PacketLoginOutEncryptionBegin(PacketDataSerializer var0) {
        this.serverId = var0.readUtf(20);
        this.publicKey = var0.readByteArray();
        this.challenge = var0.readByteArray();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeUtf(this.serverId);
        var0.writeByteArray(this.publicKey);
        var0.writeByteArray(this.challenge);
    }

    @Override
    public void handle(PacketLoginOutListener var0) {
        var0.handleHello(this);
    }

    public String getServerId() {
        return this.serverId;
    }

    public PublicKey getPublicKey() throws CryptographyException {
        return MinecraftEncryption.byteToPublicKey(this.publicKey);
    }

    public byte[] getChallenge() {
        return this.challenge;
    }
}

