/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3D;

public class PacketPlayOutExplosion
implements Packet<PacketListenerPlayOut> {
    private final double x;
    private final double y;
    private final double z;
    private final float power;
    private final List<BlockPosition> toBlow;
    private final float knockbackX;
    private final float knockbackY;
    private final float knockbackZ;
    private final ParticleParam smallExplosionParticles;
    private final ParticleParam largeExplosionParticles;
    private final Explosion.Effect blockInteraction;
    private final SoundEffect explosionSound;

    public PacketPlayOutExplosion(double var0, double var2, double var4, float var6, List<BlockPosition> var7, @Nullable Vec3D var8, Explosion.Effect var9, ParticleParam var10, ParticleParam var11, SoundEffect var12) {
        this.x = var0;
        this.y = var2;
        this.z = var4;
        this.power = var6;
        this.toBlow = Lists.newArrayList(var7);
        this.explosionSound = var12;
        if (var8 != null) {
            this.knockbackX = (float)var8.x;
            this.knockbackY = (float)var8.y;
            this.knockbackZ = (float)var8.z;
        } else {
            this.knockbackX = 0.0f;
            this.knockbackY = 0.0f;
            this.knockbackZ = 0.0f;
        }
        this.blockInteraction = var9;
        this.smallExplosionParticles = var10;
        this.largeExplosionParticles = var11;
    }

    public PacketPlayOutExplosion(PacketDataSerializer var0) {
        this.x = var0.readDouble();
        this.y = var0.readDouble();
        this.z = var0.readDouble();
        this.power = var0.readFloat();
        int var1 = MathHelper.floor(this.x);
        int var2 = MathHelper.floor(this.y);
        int var32 = MathHelper.floor(this.z);
        this.toBlow = var0.readList(var3 -> {
            int var4 = var3.readByte() + var1;
            int var5 = var3.readByte() + var2;
            int var6 = var3.readByte() + var32;
            return new BlockPosition(var4, var5, var6);
        });
        this.knockbackX = var0.readFloat();
        this.knockbackY = var0.readFloat();
        this.knockbackZ = var0.readFloat();
        this.blockInteraction = var0.readEnum(Explosion.Effect.class);
        this.smallExplosionParticles = this.readParticle(var0, var0.readById(BuiltInRegistries.PARTICLE_TYPE));
        this.largeExplosionParticles = this.readParticle(var0, var0.readById(BuiltInRegistries.PARTICLE_TYPE));
        this.explosionSound = SoundEffect.readFromNetwork(var0);
    }

    public void writeParticle(PacketDataSerializer var0, ParticleParam var1) {
        var0.writeId(BuiltInRegistries.PARTICLE_TYPE, var1.getType());
        var1.writeToNetwork(var0);
    }

    private <T extends ParticleParam> T readParticle(PacketDataSerializer var0, Particle<T> var1) {
        return var1.getDeserializer().fromNetwork(var1, var0);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeDouble(this.x);
        var0.writeDouble(this.y);
        var0.writeDouble(this.z);
        var0.writeFloat(this.power);
        int var1 = MathHelper.floor(this.x);
        int var2 = MathHelper.floor(this.y);
        int var32 = MathHelper.floor(this.z);
        var0.writeCollection(this.toBlow, (var3, var4) -> {
            int var5 = var4.getX() - var1;
            int var6 = var4.getY() - var2;
            int var7 = var4.getZ() - var32;
            var3.writeByte(var5);
            var3.writeByte(var6);
            var3.writeByte(var7);
        });
        var0.writeFloat(this.knockbackX);
        var0.writeFloat(this.knockbackY);
        var0.writeFloat(this.knockbackZ);
        var0.writeEnum(this.blockInteraction);
        this.writeParticle(var0, this.smallExplosionParticles);
        this.writeParticle(var0, this.largeExplosionParticles);
        this.explosionSound.writeToNetwork(var0);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleExplosion(this);
    }

    public float getKnockbackX() {
        return this.knockbackX;
    }

    public float getKnockbackY() {
        return this.knockbackY;
    }

    public float getKnockbackZ() {
        return this.knockbackZ;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getPower() {
        return this.power;
    }

    public List<BlockPosition> getToBlow() {
        return this.toBlow;
    }

    public Explosion.Effect getBlockInteraction() {
        return this.blockInteraction;
    }

    public ParticleParam getSmallExplosionParticles() {
        return this.smallExplosionParticles;
    }

    public ParticleParam getLargeExplosionParticles() {
        return this.largeExplosionParticles;
    }

    public SoundEffect getExplosionSound() {
        return this.explosionSound;
    }
}

