/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.Entity;

public class PacketPlayOutEntitySound
implements Packet<PacketListenerPlayOut> {
    private final Holder<SoundEffect> sound;
    private final SoundCategory source;
    private final int id;
    private final float volume;
    private final float pitch;
    private final long seed;

    public PacketPlayOutEntitySound(Holder<SoundEffect> var0, SoundCategory var1, Entity var2, float var3, float var4, long var5) {
        this.sound = var0;
        this.source = var1;
        this.id = var2.getId();
        this.volume = var3;
        this.pitch = var4;
        this.seed = var5;
    }

    public PacketPlayOutEntitySound(PacketDataSerializer var0) {
        this.sound = var0.readById(BuiltInRegistries.SOUND_EVENT.asHolderIdMap(), SoundEffect::readFromNetwork);
        this.source = var0.readEnum(SoundCategory.class);
        this.id = var0.readVarInt();
        this.volume = var0.readFloat();
        this.pitch = var0.readFloat();
        this.seed = var0.readLong();
    }

    @Override
    public void write(PacketDataSerializer var02) {
        var02.writeId(BuiltInRegistries.SOUND_EVENT.asHolderIdMap(), this.sound, (var0, var1) -> var1.writeToNetwork((PacketDataSerializer)((Object)var0)));
        var02.writeEnum(this.source);
        var02.writeVarInt(this.id);
        var02.writeFloat(this.volume);
        var02.writeFloat(this.pitch);
        var02.writeLong(this.seed);
    }

    public Holder<SoundEffect> getSound() {
        return this.sound;
    }

    public SoundCategory getSource() {
        return this.source;
    }

    public int getId() {
        return this.id;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public long getSeed() {
        return this.seed;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleSoundEntityEvent(this);
    }
}

