/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;

public record CommonPlayerSpawnInfo(ResourceKey<DimensionManager> dimensionType, ResourceKey<World> dimension, long seed, EnumGamemode gameType, @Nullable EnumGamemode previousGameType, boolean isDebug, boolean isFlat, Optional<GlobalPos> lastDeathLocation, int portalCooldown) {
    public CommonPlayerSpawnInfo(PacketDataSerializer var0) {
        this(var0.readResourceKey(Registries.DIMENSION_TYPE), var0.readResourceKey(Registries.DIMENSION), var0.readLong(), EnumGamemode.byId(var0.readByte()), EnumGamemode.byNullableId(var0.readByte()), var0.readBoolean(), var0.readBoolean(), var0.readOptional(PacketDataSerializer::readGlobalPos), var0.readVarInt());
    }

    public void write(PacketDataSerializer var0) {
        var0.writeResourceKey(this.dimensionType);
        var0.writeResourceKey(this.dimension);
        var0.writeLong(this.seed);
        var0.writeByte(this.gameType.getId());
        var0.writeByte(EnumGamemode.getNullableId(this.previousGameType));
        var0.writeBoolean(this.isDebug);
        var0.writeBoolean(this.isFlat);
        var0.writeOptional(this.lastDeathLocation, PacketDataSerializer::writeGlobalPos);
        var0.writeVarInt(this.portalCooldown);
    }
}

