/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.numbers;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.numbers.BlankFormat;
import net.minecraft.network.chat.numbers.FixedFormat;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.NumberFormatType;
import net.minecraft.network.chat.numbers.StyledFormat;

public class NumberFormatTypes {
    public static final MapCodec<NumberFormat> MAP_CODEC = BuiltInRegistries.NUMBER_FORMAT_TYPE.byNameCodec().dispatchMap(NumberFormat::type, var0 -> var0.mapCodec().codec());
    public static final Codec<NumberFormat> CODEC = MAP_CODEC.codec();

    public static NumberFormatType<?> bootstrap(IRegistry<NumberFormatType<?>> var0) {
        NumberFormatType<BlankFormat> var1 = IRegistry.register(var0, "blank", BlankFormat.TYPE);
        IRegistry.register(var0, "styled", StyledFormat.TYPE);
        IRegistry.register(var0, "fixed", FixedFormat.TYPE);
        return var1;
    }

    public static <T extends NumberFormat> void writeToStream(PacketDataSerializer var0, T var1) {
        NumberFormatType<? extends NumberFormat> var2 = var1.type();
        var0.writeId(BuiltInRegistries.NUMBER_FORMAT_TYPE, var2);
        var2.writeToStream(var0, var1);
    }

    public static NumberFormat readFromStream(PacketDataSerializer var0) {
        NumberFormatType<?> var1 = var0.readById(BuiltInRegistries.NUMBER_FORMAT_TYPE);
        return var1.readFromStream(var0);
    }
}

