/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;

public class SelectorContents
implements ComponentContents {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<SelectorContents> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.STRING.fieldOf("selector").forGetter(SelectorContents::getPattern), (App)ExtraCodecs.strictOptionalField(ComponentSerialization.CODEC, "separator").forGetter(SelectorContents::getSeparator)).apply((Applicative)var0, SelectorContents::new));
    public static final ComponentContents.a<SelectorContents> TYPE = new ComponentContents.a<SelectorContents>(CODEC, "selector");
    private final String pattern;
    @Nullable
    private final EntitySelector selector;
    protected final Optional<IChatBaseComponent> separator;

    public SelectorContents(String var0, Optional<IChatBaseComponent> var1) {
        this.pattern = var0;
        this.separator = var1;
        this.selector = SelectorContents.parseSelector(var0);
    }

    @Nullable
    private static EntitySelector parseSelector(String var0) {
        EntitySelector var1 = null;
        try {
            ArgumentParserSelector var2 = new ArgumentParserSelector(new StringReader(var0));
            var1 = var2.parse();
        }
        catch (CommandSyntaxException var2) {
            LOGGER.warn("Invalid selector component: {}: {}", (Object)var0, (Object)var2.getMessage());
        }
        return var1;
    }

    @Override
    public ComponentContents.a<?> type() {
        return TYPE;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Nullable
    public EntitySelector getSelector() {
        return this.selector;
    }

    public Optional<IChatBaseComponent> getSeparator() {
        return this.separator;
    }

    @Override
    public IChatMutableComponent resolve(@Nullable CommandListenerWrapper var0, @Nullable Entity var1, int var2) throws CommandSyntaxException {
        if (var0 == null || this.selector == null) {
            return IChatBaseComponent.empty();
        }
        Optional<IChatMutableComponent> var3 = ChatComponentUtils.updateForEntity(var0, this.separator, var1, var2);
        return ChatComponentUtils.formatList(this.selector.findEntities(var0), var3, Entity::getDisplayName);
    }

    @Override
    public <T> Optional<T> visit(IChatFormatted.b<T> var0, ChatModifier var1) {
        return var0.accept(var1, this.pattern);
    }

    @Override
    public <T> Optional<T> visit(IChatFormatted.a<T> var0) {
        return var0.accept(this.pattern);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof SelectorContents)) return false;
        SelectorContents var1 = (SelectorContents)var0;
        if (!this.pattern.equals(var1.pattern)) return false;
        if (!this.separator.equals(var1.separator)) return false;
        return true;
    }

    public int hashCode() {
        int var0 = this.pattern.hashCode();
        var0 = 31 * var0 + this.separator.hashCode();
        return var0;
    }

    public String toString() {
        return "pattern{" + this.pattern + "}";
    }
}

