/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHexColor;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;

public class ChatModifier {
    public static final ChatModifier EMPTY = new ChatModifier(null, null, null, null, null, null, null, null, null, null);
    public static final MinecraftKey DEFAULT_FONT = new MinecraftKey("minecraft", "default");
    @Nullable
    final ChatHexColor color;
    @Nullable
    final Boolean bold;
    @Nullable
    final Boolean italic;
    @Nullable
    final Boolean underlined;
    @Nullable
    final Boolean strikethrough;
    @Nullable
    final Boolean obfuscated;
    @Nullable
    final ChatClickable clickEvent;
    @Nullable
    final ChatHoverable hoverEvent;
    @Nullable
    final String insertion;
    @Nullable
    final MinecraftKey font;

    private static ChatModifier create(Optional<ChatHexColor> var0, Optional<Boolean> var1, Optional<Boolean> var2, Optional<Boolean> var3, Optional<Boolean> var4, Optional<Boolean> var5, Optional<ChatClickable> var6, Optional<ChatHoverable> var7, Optional<String> var8, Optional<MinecraftKey> var9) {
        ChatModifier var10 = new ChatModifier(var0.orElse(null), var1.orElse(null), var2.orElse(null), var3.orElse(null), var4.orElse(null), var5.orElse(null), var6.orElse(null), var7.orElse(null), var8.orElse(null), var9.orElse(null));
        if (var10.equals(EMPTY)) {
            return EMPTY;
        }
        return var10;
    }

    private ChatModifier(@Nullable ChatHexColor var0, @Nullable Boolean var1, @Nullable Boolean var2, @Nullable Boolean var3, @Nullable Boolean var4, @Nullable Boolean var5, @Nullable ChatClickable var6, @Nullable ChatHoverable var7, @Nullable String var8, @Nullable MinecraftKey var9) {
        this.color = var0;
        this.bold = var1;
        this.italic = var2;
        this.underlined = var3;
        this.strikethrough = var4;
        this.obfuscated = var5;
        this.clickEvent = var6;
        this.hoverEvent = var7;
        this.insertion = var8;
        this.font = var9;
    }

    @Nullable
    public ChatHexColor getColor() {
        return this.color;
    }

    public boolean isBold() {
        return this.bold == Boolean.TRUE;
    }

    public boolean isItalic() {
        return this.italic == Boolean.TRUE;
    }

    public boolean isStrikethrough() {
        return this.strikethrough == Boolean.TRUE;
    }

    public boolean isUnderlined() {
        return this.underlined == Boolean.TRUE;
    }

    public boolean isObfuscated() {
        return this.obfuscated == Boolean.TRUE;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Nullable
    public ChatClickable getClickEvent() {
        return this.clickEvent;
    }

    @Nullable
    public ChatHoverable getHoverEvent() {
        return this.hoverEvent;
    }

    @Nullable
    public String getInsertion() {
        return this.insertion;
    }

    public MinecraftKey getFont() {
        return this.font != null ? this.font : DEFAULT_FONT;
    }

    private static <T> ChatModifier checkEmptyAfterChange(ChatModifier var0, @Nullable T var1, @Nullable T var2) {
        if (var1 != null && var2 == null && var0.equals(EMPTY)) {
            return EMPTY;
        }
        return var0;
    }

    public ChatModifier withColor(@Nullable ChatHexColor var0) {
        if (Objects.equals(this.color, var0)) {
            return this;
        }
        return ChatModifier.checkEmptyAfterChange(new ChatModifier(var0, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.color, var0);
    }

    public ChatModifier withColor(@Nullable EnumChatFormat var0) {
        return this.withColor(var0 != null ? ChatHexColor.fromLegacyFormat(var0) : null);
    }

    public ChatModifier withColor(int var0) {
        return this.withColor(ChatHexColor.fromRgb(var0));
    }

    public ChatModifier withBold(@Nullable Boolean var0) {
        if (Objects.equals(this.bold, var0)) {
            return this;
        }
        return ChatModifier.checkEmptyAfterChange(new ChatModifier(this.color, var0, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.bold, var0);
    }

    public ChatModifier withItalic(@Nullable Boolean var0) {
        if (Objects.equals(this.italic, var0)) {
            return this;
        }
        return ChatModifier.checkEmptyAfterChange(new ChatModifier(this.color, this.bold, var0, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.italic, var0);
    }

    public ChatModifier withUnderlined(@Nullable Boolean var0) {
        if (Objects.equals(this.underlined, var0)) {
            return this;
        }
        return ChatModifier.checkEmptyAfterChange(new ChatModifier(this.color, this.bold, this.italic, var0, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.underlined, var0);
    }

    public ChatModifier withStrikethrough(@Nullable Boolean var0) {
        if (Objects.equals(this.strikethrough, var0)) {
            return this;
        }
        return ChatModifier.checkEmptyAfterChange(new ChatModifier(this.color, this.bold, this.italic, this.underlined, var0, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.strikethrough, var0);
    }

    public ChatModifier withObfuscated(@Nullable Boolean var0) {
        if (Objects.equals(this.obfuscated, var0)) {
            return this;
        }
        return ChatModifier.checkEmptyAfterChange(new ChatModifier(this.color, this.bold, this.italic, this.underlined, this.strikethrough, var0, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.obfuscated, var0);
    }

    public ChatModifier withClickEvent(@Nullable ChatClickable var0) {
        if (Objects.equals(this.clickEvent, var0)) {
            return this;
        }
        return ChatModifier.checkEmptyAfterChange(new ChatModifier(this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, var0, this.hoverEvent, this.insertion, this.font), this.clickEvent, var0);
    }

    public ChatModifier withHoverEvent(@Nullable ChatHoverable var0) {
        if (Objects.equals(this.hoverEvent, var0)) {
            return this;
        }
        return ChatModifier.checkEmptyAfterChange(new ChatModifier(this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, var0, this.insertion, this.font), this.hoverEvent, var0);
    }

    public ChatModifier withInsertion(@Nullable String var0) {
        if (Objects.equals(this.insertion, var0)) {
            return this;
        }
        return ChatModifier.checkEmptyAfterChange(new ChatModifier(this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, var0, this.font), this.insertion, var0);
    }

    public ChatModifier withFont(@Nullable MinecraftKey var0) {
        if (Objects.equals(this.font, var0)) {
            return this;
        }
        return ChatModifier.checkEmptyAfterChange(new ChatModifier(this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, var0), this.font, var0);
    }

    public ChatModifier applyFormat(EnumChatFormat var0) {
        ChatHexColor var1 = this.color;
        Boolean var2 = this.bold;
        Boolean var3 = this.italic;
        Boolean var4 = this.strikethrough;
        Boolean var5 = this.underlined;
        Boolean var6 = this.obfuscated;
        switch (var0) {
            case OBFUSCATED: {
                var6 = true;
                break;
            }
            case BOLD: {
                var2 = true;
                break;
            }
            case STRIKETHROUGH: {
                var4 = true;
                break;
            }
            case UNDERLINE: {
                var5 = true;
                break;
            }
            case ITALIC: {
                var3 = true;
                break;
            }
            case RESET: {
                return EMPTY;
            }
            default: {
                var1 = ChatHexColor.fromLegacyFormat(var0);
            }
        }
        return new ChatModifier(var1, var2, var3, var5, var4, var6, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public ChatModifier applyLegacyFormat(EnumChatFormat var0) {
        ChatHexColor var1 = this.color;
        Boolean var2 = this.bold;
        Boolean var3 = this.italic;
        Boolean var4 = this.strikethrough;
        Boolean var5 = this.underlined;
        Boolean var6 = this.obfuscated;
        switch (var0) {
            case OBFUSCATED: {
                var6 = true;
                break;
            }
            case BOLD: {
                var2 = true;
                break;
            }
            case STRIKETHROUGH: {
                var4 = true;
                break;
            }
            case UNDERLINE: {
                var5 = true;
                break;
            }
            case ITALIC: {
                var3 = true;
                break;
            }
            case RESET: {
                return EMPTY;
            }
            default: {
                var6 = false;
                var2 = false;
                var4 = false;
                var5 = false;
                var3 = false;
                var1 = ChatHexColor.fromLegacyFormat(var0);
            }
        }
        return new ChatModifier(var1, var2, var3, var5, var4, var6, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public ChatModifier applyFormats(EnumChatFormat ... var0) {
        ChatHexColor var1 = this.color;
        Boolean var2 = this.bold;
        Boolean var3 = this.italic;
        Boolean var4 = this.strikethrough;
        Boolean var5 = this.underlined;
        Boolean var6 = this.obfuscated;
        block8: for (EnumChatFormat var10 : var0) {
            switch (var10) {
                case OBFUSCATED: {
                    var6 = true;
                    continue block8;
                }
                case BOLD: {
                    var2 = true;
                    continue block8;
                }
                case STRIKETHROUGH: {
                    var4 = true;
                    continue block8;
                }
                case UNDERLINE: {
                    var5 = true;
                    continue block8;
                }
                case ITALIC: {
                    var3 = true;
                    continue block8;
                }
                case RESET: {
                    return EMPTY;
                }
                default: {
                    var1 = ChatHexColor.fromLegacyFormat(var10);
                }
            }
        }
        return new ChatModifier(var1, var2, var3, var5, var4, var6, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public ChatModifier applyTo(ChatModifier var0) {
        if (this == EMPTY) {
            return var0;
        }
        if (var0 == EMPTY) {
            return this;
        }
        return new ChatModifier(this.color != null ? this.color : var0.color, this.bold != null ? this.bold : var0.bold, this.italic != null ? this.italic : var0.italic, this.underlined != null ? this.underlined : var0.underlined, this.strikethrough != null ? this.strikethrough : var0.strikethrough, this.obfuscated != null ? this.obfuscated : var0.obfuscated, this.clickEvent != null ? this.clickEvent : var0.clickEvent, this.hoverEvent != null ? this.hoverEvent : var0.hoverEvent, this.insertion != null ? this.insertion : var0.insertion, this.font != null ? this.font : var0.font);
    }

    public String toString() {
        StringBuilder var0 = new StringBuilder("{");
        class A {
            private boolean isNotFirst;
            final /* synthetic */ StringBuilder a;

            A(StringBuilder stringBuilder) {
                this.a = stringBuilder;
            }

            private void prependSeparator() {
                if (this.isNotFirst) {
                    this.a.append(',');
                }
                this.isNotFirst = true;
            }

            void addFlagString(String var0, @Nullable Boolean var1) {
                if (var1 != null) {
                    this.prependSeparator();
                    if (!var1.booleanValue()) {
                        this.a.append('!');
                    }
                    this.a.append(var0);
                }
            }

            void addValueString(String var0, @Nullable Object var1) {
                if (var1 != null) {
                    this.prependSeparator();
                    this.a.append(var0);
                    this.a.append('=');
                    this.a.append(var1);
                }
            }
        }
        A var1 = new A(var0);
        var1.addValueString("color", this.color);
        var1.addFlagString("bold", this.bold);
        var1.addFlagString("italic", this.italic);
        var1.addFlagString("underlined", this.underlined);
        var1.addFlagString("strikethrough", this.strikethrough);
        var1.addFlagString("obfuscated", this.obfuscated);
        var1.addValueString("clickEvent", this.clickEvent);
        var1.addValueString("hoverEvent", this.hoverEvent);
        var1.addValueString("insertion", this.insertion);
        var1.addValueString("font", this.font);
        var0.append("}");
        return var0.toString();
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof ChatModifier) {
            ChatModifier var1 = (ChatModifier)var0;
            return this.bold == var1.bold && Objects.equals(this.getColor(), var1.getColor()) && this.italic == var1.italic && this.obfuscated == var1.obfuscated && this.strikethrough == var1.strikethrough && this.underlined == var1.underlined && Objects.equals(this.clickEvent, var1.clickEvent) && Objects.equals(this.hoverEvent, var1.hoverEvent) && Objects.equals(this.insertion, var1.insertion) && Objects.equals(this.font, var1.font);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion);
    }

    public static class ChatModifierSerializer {
        public static final MapCodec<ChatModifier> MAP_CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)ExtraCodecs.strictOptionalField(ChatHexColor.CODEC, "color").forGetter(var0 -> Optional.ofNullable(var0.color)), (App)ExtraCodecs.strictOptionalField(Codec.BOOL, "bold").forGetter(var0 -> Optional.ofNullable(var0.bold)), (App)ExtraCodecs.strictOptionalField(Codec.BOOL, "italic").forGetter(var0 -> Optional.ofNullable(var0.italic)), (App)ExtraCodecs.strictOptionalField(Codec.BOOL, "underlined").forGetter(var0 -> Optional.ofNullable(var0.underlined)), (App)ExtraCodecs.strictOptionalField(Codec.BOOL, "strikethrough").forGetter(var0 -> Optional.ofNullable(var0.strikethrough)), (App)ExtraCodecs.strictOptionalField(Codec.BOOL, "obfuscated").forGetter(var0 -> Optional.ofNullable(var0.obfuscated)), (App)ExtraCodecs.strictOptionalField(ChatClickable.CODEC, "clickEvent").forGetter(var0 -> Optional.ofNullable(var0.clickEvent)), (App)ExtraCodecs.strictOptionalField(ChatHoverable.CODEC, "hoverEvent").forGetter(var0 -> Optional.ofNullable(var0.hoverEvent)), (App)ExtraCodecs.strictOptionalField(Codec.STRING, "insertion").forGetter(var0 -> Optional.ofNullable(var0.insertion)), (App)ExtraCodecs.strictOptionalField(MinecraftKey.CODEC, "font").forGetter(var0 -> Optional.ofNullable(var0.font))).apply((Applicative)var02, ChatModifier::create));
        public static final Codec<ChatModifier> CODEC = MAP_CODEC.codec();
    }
}

