/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ChatHoverable {
    public static final Codec<ChatHoverable> CODEC = Codec.either((Codec)d.CODEC.codec(), (Codec)d.LEGACY_CODEC.codec()).xmap(var02 -> new ChatHoverable((d)var02.map(var0 -> var0, var0 -> var0)), var0 -> Either.left(var0.event));
    private final d<?> event;

    public <T> ChatHoverable(EnumHoverAction<T> var0, T var1) {
        this(new d<T>(var0, var1));
    }

    private ChatHoverable(d<?> var0) {
        this.event = var0;
    }

    public EnumHoverAction<?> getAction() {
        return this.event.action;
    }

    @Nullable
    public <T> T getValue(EnumHoverAction<T> var0) {
        if (this.event.action == var0) {
            return var0.cast(this.event.value);
        }
        return null;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        return ((ChatHoverable)var0).event.equals(this.event);
    }

    public String toString() {
        return this.event.toString();
    }

    public int hashCode() {
        return this.event.hashCode();
    }

    static final class d<T>
    extends Record {
        final EnumHoverAction<T> action;
        final T value;
        public static final MapCodec<d<?>> CODEC = EnumHoverAction.CODEC.dispatchMap("action", d::action, var0 -> var0.codec);
        public static final MapCodec<d<?>> LEGACY_CODEC = EnumHoverAction.CODEC.dispatchMap("action", d::action, var0 -> var0.legacyCodec);

        d(EnumHoverAction<T> var0, T var1) {
            this.action = var0;
            this.value = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "action;value", "action", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "action;value", "action", "value"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "action;value", "action", "value"}, this, var0);
        }

        public EnumHoverAction<T> action() {
            return this.action;
        }

        public T value() {
            return this.value;
        }
    }

    public static class EnumHoverAction<T>
    implements INamable {
        public static final EnumHoverAction<IChatBaseComponent> SHOW_TEXT = new EnumHoverAction<IChatBaseComponent>("show_text", true, ComponentSerialization.CODEC, DataResult::success);
        public static final EnumHoverAction<c> SHOW_ITEM = new EnumHoverAction<c>("show_item", true, c.CODEC, c::legacyCreate);
        public static final EnumHoverAction<b> SHOW_ENTITY = new EnumHoverAction<b>("show_entity", true, b.CODEC, b::legacyCreate);
        public static final Codec<EnumHoverAction<?>> UNSAFE_CODEC = INamable.fromValues(() -> new EnumHoverAction[]{SHOW_TEXT, SHOW_ITEM, SHOW_ENTITY});
        public static final Codec<EnumHoverAction<?>> CODEC = ExtraCodecs.validate(UNSAFE_CODEC, EnumHoverAction::filterForSerialization);
        private final String name;
        private final boolean allowFromServer;
        final Codec<d<T>> codec;
        final Codec<d<T>> legacyCodec;

        public EnumHoverAction(String var02, boolean var1, Codec<T> var2, Function<IChatBaseComponent, DataResult<T>> var3) {
            this.name = var02;
            this.allowFromServer = var1;
            this.codec = var2.xmap(var0 -> new d<Object>(this, var0), var0 -> var0.value).fieldOf("contents").codec();
            this.legacyCodec = Codec.of((Encoder)Encoder.error((String)"Can't encode in legacy format"), (Decoder)ComponentSerialization.CODEC.flatMap(var3).map(var0 -> new d<Object>(this, var0)));
        }

        public boolean isAllowedFromServer() {
            return this.allowFromServer;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        T cast(Object var0) {
            return (T)var0;
        }

        public String toString() {
            return "<action " + this.name + ">";
        }

        private static DataResult<EnumHoverAction<?>> filterForSerialization(@Nullable EnumHoverAction<?> var0) {
            if (var0 == null) {
                return DataResult.error(() -> "Unknown action");
            }
            if (!var0.isAllowedFromServer()) {
                return DataResult.error(() -> "Action not allowed: " + var0);
            }
            return DataResult.success(var0, (Lifecycle)Lifecycle.stable());
        }
    }

    public static class c {
        public static final Codec<c> FULL_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("id").forGetter(var0 -> var0.item), (App)ExtraCodecs.strictOptionalField(Codec.INT, "count", 1).forGetter(var0 -> var0.count), (App)ExtraCodecs.strictOptionalField(MojangsonParser.AS_CODEC, "tag").forGetter(var0 -> var0.tag)).apply((Applicative)var02, c::new));
        public static final Codec<c> CODEC = Codec.either(BuiltInRegistries.ITEM.byNameCodec(), FULL_CODEC).xmap(var02 -> (c)var02.map(var0 -> new c((Item)var0, 1, Optional.empty()), var0 -> var0), Either::right);
        private final Item item;
        private final int count;
        private final Optional<NBTTagCompound> tag;
        @Nullable
        private ItemStack itemStack;

        c(Item var0, int var1, @Nullable NBTTagCompound var2) {
            this(var0, var1, Optional.ofNullable(var2));
        }

        c(Item var0, int var1, Optional<NBTTagCompound> var2) {
            this.item = var0;
            this.count = var1;
            this.tag = var2;
        }

        public c(ItemStack var0) {
            this(var0.getItem(), var0.getCount(), var0.getTag() != null ? Optional.of(var0.getTag().copy()) : Optional.empty());
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 == null || this.getClass() != var0.getClass()) {
                return false;
            }
            c var1 = (c)var0;
            return this.count == var1.count && this.item.equals(var1.item) && this.tag.equals(var1.tag);
        }

        public int hashCode() {
            int var0 = this.item.hashCode();
            var0 = 31 * var0 + this.count;
            var0 = 31 * var0 + this.tag.hashCode();
            return var0;
        }

        public ItemStack getItemStack() {
            if (this.itemStack == null) {
                this.itemStack = new ItemStack(this.item, this.count);
                this.tag.ifPresent(this.itemStack::setTag);
            }
            return this.itemStack;
        }

        private static DataResult<c> legacyCreate(IChatBaseComponent var0) {
            try {
                NBTTagCompound var1 = MojangsonParser.parseTag(var0.getString());
                return DataResult.success((Object)new c(ItemStack.of(var1)));
            }
            catch (CommandSyntaxException var1) {
                return DataResult.error(() -> "Failed to parse item tag: " + var1.getMessage());
            }
        }
    }

    public static class b {
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("type").forGetter(var0 -> var0.type), (App)UUIDUtil.LENIENT_CODEC.fieldOf("id").forGetter(var0 -> var0.id), (App)ExtraCodecs.strictOptionalField(ComponentSerialization.CODEC, "name").forGetter(var0 -> var0.name)).apply((Applicative)var02, b::new));
        public final EntityTypes<?> type;
        public final UUID id;
        public final Optional<IChatBaseComponent> name;
        @Nullable
        private List<IChatBaseComponent> linesCache;

        public b(EntityTypes<?> var0, UUID var1, @Nullable IChatBaseComponent var2) {
            this(var0, var1, Optional.ofNullable(var2));
        }

        public b(EntityTypes<?> var0, UUID var1, Optional<IChatBaseComponent> var2) {
            this.type = var0;
            this.id = var1;
            this.name = var2;
        }

        public static DataResult<b> legacyCreate(IChatBaseComponent var0) {
            try {
                NBTTagCompound var1 = MojangsonParser.parseTag(var0.getString());
                IChatMutableComponent var2 = IChatBaseComponent.ChatSerializer.fromJson(var1.getString("name"));
                EntityTypes<?> var3 = BuiltInRegistries.ENTITY_TYPE.get(new MinecraftKey(var1.getString("type")));
                UUID var4 = UUID.fromString(var1.getString("id"));
                return DataResult.success((Object)new b(var3, var4, var2));
            }
            catch (Exception var1) {
                return DataResult.error(() -> "Failed to parse tooltip: " + var1.getMessage());
            }
        }

        public List<IChatBaseComponent> getTooltipLines() {
            if (this.linesCache == null) {
                this.linesCache = new ArrayList<IChatBaseComponent>();
                this.name.ifPresent(this.linesCache::add);
                this.linesCache.add(IChatBaseComponent.translatable("gui.entity_tooltip.type", this.type.getDescription()));
                this.linesCache.add(IChatBaseComponent.literal(this.id.toString()));
            }
            return this.linesCache;
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 == null || this.getClass() != var0.getClass()) {
                return false;
            }
            b var1 = (b)var0;
            return this.type.equals(var1.type) && this.id.equals(var1.id) && this.name.equals(var1.name);
        }

        public int hashCode() {
            int var0 = this.type.hashCode();
            var0 = 31 * var0 + this.id.hashCode();
            var0 = 31 * var0 + this.name.hashCode();
            return var0;
        }
    }
}

