/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;

public interface PacketListener {
    public EnumProtocolDirection flow();

    public EnumProtocol protocol();

    public void onDisconnect(IChatBaseComponent var1);

    public boolean isAcceptingMessages();

    default public boolean shouldHandleMessage(Packet<?> var0) {
        return this.isAcceptingMessages();
    }

    default public boolean shouldPropagateHandlingExceptions() {
        return true;
    }

    default public void fillCrashReport(CrashReport var0) {
        CrashReportSystemDetails var1 = var0.addCategory("Connection");
        var1.setDetail("Protocol", () -> this.protocol().id());
        var1.setDetail("Flow", () -> this.flow().toString());
        this.fillListenerSpecificCrashDetails(var1);
    }

    default public void fillListenerSpecificCrashDetails(CrashReportSystemDetails var0) {
    }
}

