/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.ExhaustedAttemptsException;
import net.minecraft.gametest.framework.GameTestHarnessAssertionPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLectern;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import org.apache.commons.lang3.exception.ExceptionUtils;

class ReportGameListener
implements GameTestHarnessListener {
    private final GameTestHarnessInfo originalTestInfo;
    private final GameTestHarnessTicker testTicker;
    private final BlockPosition structurePos;
    int attempts;
    int successes;

    public ReportGameListener(GameTestHarnessInfo var0, GameTestHarnessTicker var1, BlockPosition var2) {
        this.originalTestInfo = var0;
        this.testTicker = var1;
        this.structurePos = var2;
        this.attempts = 0;
        this.successes = 0;
    }

    @Override
    public void testStructureLoaded(GameTestHarnessInfo var0) {
        ReportGameListener.spawnBeacon(this.originalTestInfo, Blocks.LIGHT_GRAY_STAINED_GLASS);
        ++this.attempts;
    }

    @Override
    public void testPassed(GameTestHarnessInfo var0) {
        ++this.successes;
        if (var0.rerunUntilFailed()) {
            ReportGameListener.reportPassed(var0, var0.getTestName() + " passed! (" + var0.getRunTime() + "ms). Rerunning until failed.");
            this.rerunTest();
            return;
        }
        if (!var0.isFlaky()) {
            ReportGameListener.reportPassed(var0, var0.getTestName() + " passed! (" + var0.getRunTime() + "ms)");
            return;
        }
        if (this.successes >= var0.requiredSuccesses()) {
            ReportGameListener.reportPassed(var0, var0 + " passed " + this.successes + " times of " + this.attempts + " attempts.");
        } else {
            ReportGameListener.say(this.originalTestInfo.getLevel(), EnumChatFormat.GREEN, "Flaky test " + this.originalTestInfo + " succeeded, attempt: " + this.attempts + " successes: " + this.successes);
            this.rerunTest();
        }
    }

    @Override
    public void testFailed(GameTestHarnessInfo var0) {
        if (!var0.isFlaky()) {
            ReportGameListener.reportFailure(var0, var0.getError());
            return;
        }
        GameTestHarnessTestFunction var1 = this.originalTestInfo.getTestFunction();
        String var2 = "Flaky test " + this.originalTestInfo + " failed, attempt: " + this.attempts + "/" + var1.getMaxAttempts();
        if (var1.getRequiredSuccesses() > 1) {
            var2 = var2 + ", successes: " + this.successes + " (" + var1.getRequiredSuccesses() + " required)";
        }
        ReportGameListener.say(this.originalTestInfo.getLevel(), EnumChatFormat.YELLOW, var2);
        if (var0.maxAttempts() - this.attempts + this.successes >= var0.requiredSuccesses()) {
            this.rerunTest();
        } else {
            ReportGameListener.reportFailure(var0, new ExhaustedAttemptsException(this.attempts, this.successes, var0));
        }
    }

    public static void reportPassed(GameTestHarnessInfo var0, String var1) {
        ReportGameListener.spawnBeacon(var0, Blocks.LIME_STAINED_GLASS);
        ReportGameListener.visualizePassedTest(var0, var1);
    }

    private static void visualizePassedTest(GameTestHarnessInfo var0, String var1) {
        ReportGameListener.say(var0.getLevel(), EnumChatFormat.GREEN, var1);
        GlobalTestReporter.onTestSuccess(var0);
    }

    protected static void reportFailure(GameTestHarnessInfo var0, Throwable var1) {
        ReportGameListener.spawnBeacon(var0, var0.isRequired() ? Blocks.RED_STAINED_GLASS : Blocks.ORANGE_STAINED_GLASS);
        ReportGameListener.spawnLectern(var0, SystemUtils.describeError(var1));
        ReportGameListener.visualizeFailedTest(var0, var1);
    }

    protected static void visualizeFailedTest(GameTestHarnessInfo var0, Throwable var1) {
        String var2 = var1.getMessage() + (String)(var1.getCause() == null ? "" : " cause: " + SystemUtils.describeError(var1.getCause()));
        String var3 = (var0.isRequired() ? "" : "(optional) ") + var0.getTestName() + " failed! " + var2;
        ReportGameListener.say(var0.getLevel(), var0.isRequired() ? EnumChatFormat.RED : EnumChatFormat.YELLOW, var3);
        Throwable var4 = (Throwable)MoreObjects.firstNonNull((Object)ExceptionUtils.getRootCause((Throwable)var1), (Object)var1);
        if (var4 instanceof GameTestHarnessAssertionPosition) {
            GameTestHarnessAssertionPosition var5 = (GameTestHarnessAssertionPosition)var4;
            ReportGameListener.showRedBox(var0.getLevel(), var5.getAbsolutePos(), var5.getMessageToShowAtBlock());
        }
        GlobalTestReporter.onTestFailed(var0);
    }

    private void rerunTest() {
        this.originalTestInfo.clearStructure();
        GameTestHarnessInfo var0 = new GameTestHarnessInfo(this.originalTestInfo.getTestFunction(), this.originalTestInfo.getRotation(), this.originalTestInfo.getLevel());
        var0.setRerunUntilFailed(this.originalTestInfo.rerunUntilFailed());
        this.testTicker.add(var0);
        var0.addListener(this);
        var0.prepareTestStructure(this.structurePos);
    }

    protected static void spawnBeacon(GameTestHarnessInfo var0, Block var1) {
        WorldServer var2 = var0.getLevel();
        BlockPosition var3 = var0.getStructureBlockPos();
        BlockPosition var4 = new BlockPosition(-1, -1, -1);
        BlockPosition var5 = DefinedStructure.transform(var3.offset(var4), EnumBlockMirror.NONE, var0.getRotation(), var3);
        var2.setBlockAndUpdate(var5, Blocks.BEACON.defaultBlockState().rotate(var0.getRotation()));
        BlockPosition var6 = var5.offset(0, 1, 0);
        var2.setBlockAndUpdate(var6, var1.defaultBlockState());
        for (int var7 = -1; var7 <= 1; ++var7) {
            for (int var8 = -1; var8 <= 1; ++var8) {
                BlockPosition var9 = var5.offset(var7, -1, var8);
                var2.setBlockAndUpdate(var9, Blocks.IRON_BLOCK.defaultBlockState());
            }
        }
    }

    private static void spawnLectern(GameTestHarnessInfo var0, String var1) {
        WorldServer var2 = var0.getLevel();
        BlockPosition var3 = var0.getStructureBlockPos();
        BlockPosition var4 = new BlockPosition(-1, 1, -1);
        BlockPosition var5 = DefinedStructure.transform(var3.offset(var4), EnumBlockMirror.NONE, var0.getRotation(), var3);
        var2.setBlockAndUpdate(var5, Blocks.LECTERN.defaultBlockState().rotate(var0.getRotation()));
        IBlockData var6 = var2.getBlockState(var5);
        ItemStack var7 = ReportGameListener.createBook(var0.getTestName(), var0.isRequired(), var1);
        BlockLectern.tryPlaceBook(null, var2, var5, var6, var7);
    }

    private static ItemStack createBook(String var0, boolean var12, String var2) {
        ItemStack var3 = new ItemStack(Items.WRITABLE_BOOK);
        NBTTagList var4 = new NBTTagList();
        StringBuffer var5 = new StringBuffer();
        Arrays.stream(var0.split("\\.")).forEach(var1 -> var5.append((String)var1).append('\n'));
        if (!var12) {
            var5.append("(optional)\n");
        }
        var5.append("-------------------\n");
        var4.add(NBTTagString.valueOf(var5 + var2));
        var3.addTagElement("pages", var4);
        return var3;
    }

    protected static void say(WorldServer var02, EnumChatFormat var1, String var22) {
        var02.getPlayers(var0 -> true).forEach(var2 -> var2.sendSystemMessage(IChatBaseComponent.literal(var22).withStyle(var1)));
    }

    private static void showRedBox(WorldServer var0, BlockPosition var1, String var2) {
        PacketDebug.sendGameTestAddMarker(var0, var1, var2, -2130771968, Integer.MAX_VALUE);
    }
}

