/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.GameTestHarnessBatch;
import net.minecraft.gametest.framework.GameTestHarnessBatchRunner;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessRegistry;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.gametest.framework.ReportGameListener;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import org.apache.commons.lang3.mutable.MutableInt;

public class GameTestHarnessRunner {
    private static final int MAX_TESTS_PER_BATCH = 50;
    public static final int SPACE_BETWEEN_COLUMNS = 5;
    public static final int SPACE_BETWEEN_ROWS = 6;
    public static final int DEFAULT_TESTS_PER_ROW = 8;

    public static void runTest(GameTestHarnessInfo var0, BlockPosition var1, GameTestHarnessTicker var2) {
        var2.add(var0);
        var0.addListener(new ReportGameListener(var0, var2, var1));
        var0.prepareTestStructure(var1);
    }

    public static Collection<GameTestHarnessInfo> runTestBatches(Collection<GameTestHarnessBatch> var0, BlockPosition var1, EnumBlockRotation var2, WorldServer var3, GameTestHarnessTicker var4, int var5) {
        GameTestHarnessBatchRunner var6 = new GameTestHarnessBatchRunner(var0, var1, var2, var3, var4, var5);
        var6.start();
        return var6.getTestInfos();
    }

    public static Collection<GameTestHarnessInfo> runTests(Collection<GameTestHarnessTestFunction> var0, BlockPosition var1, EnumBlockRotation var2, WorldServer var3, GameTestHarnessTicker var4, int var5) {
        return GameTestHarnessRunner.runTestBatches(GameTestHarnessRunner.groupTestsIntoBatches(var0), var1, var2, var3, var4, var5);
    }

    public static Collection<GameTestHarnessBatch> groupTestsIntoBatches(Collection<GameTestHarnessTestFunction> var02) {
        Map var1 = var02.stream().collect(Collectors.groupingBy(GameTestHarnessTestFunction::getBatchName, LinkedHashMap::new, Collectors.toList()));
        return (Collection)var1.entrySet().stream().flatMap(var0 -> {
            String var1 = (String)var0.getKey();
            Consumer<WorldServer> var2 = GameTestHarnessRegistry.getBeforeBatchFunction(var1);
            Consumer<WorldServer> var3 = GameTestHarnessRegistry.getAfterBatchFunction(var1);
            MutableInt var42 = new MutableInt();
            Collection var5 = (Collection)var0.getValue();
            return Streams.stream((Iterable)Iterables.partition((Iterable)var5, (int)50)).map(var4 -> new GameTestHarnessBatch(var1 + ":" + var42.incrementAndGet(), (Collection<GameTestHarnessTestFunction>)ImmutableList.copyOf((Collection)var4), var2, var3));
        }).collect(ImmutableList.toImmutableList());
    }

    public static void clearAllTests(WorldServer var0, BlockPosition var12, GameTestHarnessTicker var2, int var3) {
        var2.clear();
        BlockPosition var4 = var12.offset(-var3, 0, -var3);
        BlockPosition var5 = var12.offset(var3, 0, var3);
        BlockPosition.betweenClosedStream(var4, var5).filter(var1 -> var0.getBlockState((BlockPosition)var1).is(Blocks.STRUCTURE_BLOCK)).forEach(var1 -> {
            TileEntityStructure var2 = (TileEntityStructure)var0.getBlockEntity((BlockPosition)var1);
            StructureBoundingBox var3 = GameTestHarnessStructures.getStructureBoundingBox(var2);
            GameTestHarnessStructures.clearSpaceForStructure(var3, var0);
        });
    }

    public static void clearMarkers(WorldServer var0) {
        PacketDebug.sendGameTestClearPacket(var0);
    }
}

