/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.GameTestHarnessHelper;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessSequence;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GameTestHarnessTimeout;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.ticks.TickListServer;

public class GameTestHarnessInfo {
    private final GameTestHarnessTestFunction testFunction;
    @Nullable
    private BlockPosition structureBlockPos;
    private final WorldServer level;
    private final Collection<GameTestHarnessListener> listeners = Lists.newArrayList();
    private final int timeoutTicks;
    private final Collection<GameTestHarnessSequence> sequences = Lists.newCopyOnWriteArrayList();
    private final Object2LongMap<Runnable> runAtTickTimeMap = new Object2LongOpenHashMap();
    private long startTick;
    private int ticksToWaitForChunkLoading = 20;
    private boolean placedStructure;
    private boolean chunksLoaded;
    private long tickCount;
    private boolean started;
    private boolean rerunUntilFailed;
    private final Stopwatch timer = Stopwatch.createUnstarted();
    private boolean done;
    private final EnumBlockRotation rotation;
    @Nullable
    private Throwable error;
    @Nullable
    private TileEntityStructure structureBlockEntity;

    public GameTestHarnessInfo(GameTestHarnessTestFunction var0, EnumBlockRotation var1, WorldServer var2) {
        this.testFunction = var0;
        this.level = var2;
        this.timeoutTicks = var0.getMaxTicks();
        this.rotation = var0.getRotation().getRotated(var1);
    }

    void setStructureBlockPos(BlockPosition var0) {
        this.structureBlockPos = var0;
    }

    void startExecution() {
        this.startTick = this.level.getGameTime() + this.testFunction.getSetupTicks();
        this.timer.start();
    }

    public void tick() {
        if (this.isDone()) {
            return;
        }
        if (this.structureBlockEntity == null) {
            this.fail(new IllegalStateException("Running test without structure block entity"));
        }
        if (!this.chunksLoaded && !GameTestHarnessStructures.getStructureBoundingBox(this.structureBlockEntity).intersectingChunks().allMatch(var0 -> this.level.isPositionEntityTicking(var0.getWorldPosition()))) {
            return;
        }
        this.chunksLoaded = true;
        if (this.ticksToWaitForChunkLoading > 0) {
            --this.ticksToWaitForChunkLoading;
            return;
        }
        if (!this.placedStructure) {
            this.placedStructure = true;
            this.structureBlockEntity.placeStructure(this.level);
            StructureBoundingBox var02 = GameTestHarnessStructures.getStructureBoundingBox(this.structureBlockEntity);
            ((TickListServer)this.level.getBlockTicks()).clearArea(var02);
            this.level.clearBlockEvents(var02);
            this.startExecution();
        }
        this.tickInternal();
        if (this.isDone()) {
            if (this.error != null) {
                this.listeners.forEach(var0 -> var0.testFailed(this));
            } else {
                this.listeners.forEach(var0 -> var0.testPassed(this));
            }
        }
    }

    private void tickInternal() {
        this.tickCount = this.level.getGameTime() - this.startTick;
        if (this.tickCount < 0L) {
            return;
        }
        if (this.tickCount == 0L) {
            this.startTest();
        }
        ObjectIterator var02 = this.runAtTickTimeMap.object2LongEntrySet().iterator();
        while (var02.hasNext()) {
            Object2LongMap.Entry var1 = (Object2LongMap.Entry)var02.next();
            if (var1.getLongValue() > this.tickCount) continue;
            try {
                ((Runnable)var1.getKey()).run();
            }
            catch (Exception var2) {
                this.fail(var2);
            }
            var02.remove();
        }
        if (this.tickCount > (long)this.timeoutTicks) {
            if (this.sequences.isEmpty()) {
                this.fail(new GameTestHarnessTimeout("Didn't succeed or fail within " + this.testFunction.getMaxTicks() + " ticks"));
            } else {
                this.sequences.forEach(var0 -> var0.tickAndFailIfNotComplete(this.tickCount));
                if (this.error == null) {
                    this.fail(new GameTestHarnessTimeout("No sequences finished"));
                }
            }
        } else {
            this.sequences.forEach(var0 -> var0.tickAndContinue(this.tickCount));
        }
    }

    private void startTest() {
        if (this.started) {
            throw new IllegalStateException("Test already started");
        }
        this.started = true;
        try {
            this.testFunction.run(new GameTestHarnessHelper(this));
        }
        catch (Exception var0) {
            this.fail(var0);
        }
    }

    public void setRunAtTickTime(long var0, Runnable var2) {
        this.runAtTickTimeMap.put((Object)var2, var0);
    }

    public String getTestName() {
        return this.testFunction.getTestName();
    }

    public BlockPosition getStructureBlockPos() {
        return this.structureBlockPos;
    }

    @Nullable
    public BlockPosition getStructureOrigin() {
        TileEntityStructure var0 = this.getStructureBlockEntity();
        if (var0 == null) {
            return null;
        }
        return GameTestHarnessStructures.getStructureOrigin(var0);
    }

    @Nullable
    public BaseBlockPosition getStructureSize() {
        TileEntityStructure var0 = this.getStructureBlockEntity();
        if (var0 == null) {
            return null;
        }
        return var0.getStructureSize();
    }

    @Nullable
    public AxisAlignedBB getStructureBounds() {
        TileEntityStructure var0 = this.getStructureBlockEntity();
        if (var0 == null) {
            return null;
        }
        return GameTestHarnessStructures.getStructureBounds(var0);
    }

    @Nullable
    private TileEntityStructure getStructureBlockEntity() {
        return (TileEntityStructure)this.level.getBlockEntity(this.structureBlockPos);
    }

    public WorldServer getLevel() {
        return this.level;
    }

    public boolean hasSucceeded() {
        return this.done && this.error == null;
    }

    public boolean hasFailed() {
        return this.error != null;
    }

    public boolean hasStarted() {
        return this.started;
    }

    public boolean isDone() {
        return this.done;
    }

    public long getRunTime() {
        return this.timer.elapsed(TimeUnit.MILLISECONDS);
    }

    private void finish() {
        if (!this.done) {
            this.done = true;
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }

    public void succeed() {
        if (this.error == null) {
            this.finish();
            AxisAlignedBB var02 = this.getStructureBounds();
            List<Entity> var1 = this.getLevel().getEntitiesOfClass(Entity.class, var02.inflate(1.0), var0 -> !(var0 instanceof EntityHuman));
            var1.forEach(var0 -> var0.remove(Entity.RemovalReason.DISCARDED));
        }
    }

    public void fail(Throwable var0) {
        this.error = var0;
        this.finish();
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    public String toString() {
        return this.getTestName();
    }

    public void addListener(GameTestHarnessListener var0) {
        this.listeners.add(var0);
    }

    public void prepareTestStructure(BlockPosition var02) {
        this.structureBlockEntity = GameTestHarnessStructures.prepareTestStructure(this, var02, this.getRotation(), this.level);
        this.structureBlockPos = this.structureBlockEntity.getBlockPos();
        GameTestHarnessStructures.addCommandBlockAndButtonToStartTest(this.structureBlockPos, new BlockPosition(1, 0, -1), this.getRotation(), this.level);
        this.listeners.forEach(var0 -> var0.testStructureLoaded(this));
    }

    public void clearStructure() {
        if (this.structureBlockEntity == null) {
            throw new IllegalStateException("Expected structure to be initialized, but it was null");
        }
        StructureBoundingBox var0 = GameTestHarnessStructures.getStructureBoundingBox(this.structureBlockEntity);
        GameTestHarnessStructures.clearSpaceForStructure(var0, this.level);
    }

    long getTick() {
        return this.tickCount;
    }

    GameTestHarnessSequence createSequence() {
        GameTestHarnessSequence var0 = new GameTestHarnessSequence(this);
        this.sequences.add(var0);
        return var0;
    }

    public boolean isRequired() {
        return this.testFunction.isRequired();
    }

    public boolean isOptional() {
        return !this.testFunction.isRequired();
    }

    public String getStructureName() {
        return this.testFunction.getStructureName();
    }

    public EnumBlockRotation getRotation() {
        return this.rotation;
    }

    public GameTestHarnessTestFunction getTestFunction() {
        return this.testFunction;
    }

    public int getTimeoutTicks() {
        return this.timeoutTicks;
    }

    public boolean isFlaky() {
        return this.testFunction.isFlaky();
    }

    public int maxAttempts() {
        return this.testFunction.getMaxAttempts();
    }

    public int requiredSuccesses() {
        return this.testFunction.getRequiredSuccesses();
    }

    public void setRerunUntilFailed(boolean var0) {
        this.rerunUntilFailed = var0;
    }

    public boolean rerunUntilFailed() {
        return this.rerunUntilFailed;
    }
}

