/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestHarnessAssertion;
import net.minecraft.gametest.framework.GameTestHarnessAssertionPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessSequence;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockButtonAbstract;
import net.minecraft.world.level.block.BlockLever;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class GameTestHarnessHelper {
    private final GameTestHarnessInfo testInfo;
    private boolean finalCheckAdded;

    public GameTestHarnessHelper(GameTestHarnessInfo var0) {
        this.testInfo = var0;
    }

    public WorldServer getLevel() {
        return this.testInfo.getLevel();
    }

    public IBlockData getBlockState(BlockPosition var0) {
        return this.getLevel().getBlockState(this.absolutePos(var0));
    }

    @Nullable
    public TileEntity getBlockEntity(BlockPosition var0) {
        return this.getLevel().getBlockEntity(this.absolutePos(var0));
    }

    public void killAllEntities() {
        this.killAllEntitiesOfClass(Entity.class);
    }

    public void killAllEntitiesOfClass(Class var02) {
        AxisAlignedBB var1 = this.getBounds();
        List<Entity> var2 = this.getLevel().getEntitiesOfClass(var02, var1.inflate(1.0), var0 -> !(var0 instanceof EntityHuman));
        var2.forEach(Entity::kill);
    }

    public EntityItem spawnItem(Item var0, float var1, float var2, float var3) {
        WorldServer var4 = this.getLevel();
        Vec3D var5 = this.absoluteVec(new Vec3D(var1, var2, var3));
        EntityItem var6 = new EntityItem(var4, var5.x, var5.y, var5.z, new ItemStack(var0, 1));
        var6.setDeltaMovement(0.0, 0.0, 0.0);
        var4.addFreshEntity(var6);
        return var6;
    }

    public EntityItem spawnItem(Item var0, BlockPosition var1) {
        return this.spawnItem(var0, var1.getX(), var1.getY(), var1.getZ());
    }

    public <E extends Entity> E spawn(EntityTypes<E> var0, BlockPosition var1) {
        return this.spawn(var0, Vec3D.atBottomCenterOf(var1));
    }

    public <E extends Entity> E spawn(EntityTypes<E> var0, Vec3D var1) {
        Object var4;
        WorldServer var2 = this.getLevel();
        E var3 = var0.create(var2);
        if (var3 == null) {
            throw new NullPointerException("Failed to create entity " + var0.builtInRegistryHolder().key().location());
        }
        if (var3 instanceof EntityInsentient) {
            var4 = (EntityInsentient)var3;
            ((EntityInsentient)var4).setPersistenceRequired();
        }
        var4 = this.absoluteVec(var1);
        ((Entity)var3).moveTo(((Vec3D)var4).x, ((Vec3D)var4).y, ((Vec3D)var4).z, ((Entity)var3).getYRot(), ((Entity)var3).getXRot());
        var2.addFreshEntity((Entity)var3);
        return var3;
    }

    public <E extends Entity> E spawn(EntityTypes<E> var0, int var1, int var2, int var3) {
        return this.spawn(var0, new BlockPosition(var1, var2, var3));
    }

    public <E extends Entity> E spawn(EntityTypes<E> var0, float var1, float var2, float var3) {
        return this.spawn(var0, new Vec3D(var1, var2, var3));
    }

    public <E extends EntityInsentient> E spawnWithNoFreeWill(EntityTypes<E> var0, BlockPosition var1) {
        EntityInsentient var2 = (EntityInsentient)this.spawn(var0, var1);
        var2.removeFreeWill();
        return (E)var2;
    }

    public <E extends EntityInsentient> E spawnWithNoFreeWill(EntityTypes<E> var0, int var1, int var2, int var3) {
        return this.spawnWithNoFreeWill(var0, new BlockPosition(var1, var2, var3));
    }

    public <E extends EntityInsentient> E spawnWithNoFreeWill(EntityTypes<E> var0, Vec3D var1) {
        EntityInsentient var2 = (EntityInsentient)this.spawn(var0, var1);
        var2.removeFreeWill();
        return (E)var2;
    }

    public <E extends EntityInsentient> E spawnWithNoFreeWill(EntityTypes<E> var0, float var1, float var2, float var3) {
        return this.spawnWithNoFreeWill(var0, new Vec3D(var1, var2, var3));
    }

    public GameTestHarnessSequence walkTo(EntityInsentient var0, BlockPosition var1, float var2) {
        return this.startSequence().thenExecuteAfter(2, () -> {
            PathEntity var3 = var0.getNavigation().createPath(this.absolutePos(var1), 0);
            var0.getNavigation().moveTo(var3, (double)var2);
        });
    }

    public void pressButton(int var0, int var1, int var2) {
        this.pressButton(new BlockPosition(var0, var1, var2));
    }

    public void pressButton(BlockPosition var02) {
        this.assertBlockState(var02, var0 -> var0.is(TagsBlock.BUTTONS), () -> "Expected button");
        BlockPosition var1 = this.absolutePos(var02);
        IBlockData var2 = this.getLevel().getBlockState(var1);
        BlockButtonAbstract var3 = (BlockButtonAbstract)var2.getBlock();
        var3.press(var2, this.getLevel(), var1);
    }

    public void useBlock(BlockPosition var0) {
        this.useBlock(var0, this.makeMockPlayer());
    }

    public void useBlock(BlockPosition var0, EntityHuman var1) {
        BlockPosition var2 = this.absolutePos(var0);
        this.useBlock(var0, var1, new MovingObjectPositionBlock(Vec3D.atCenterOf(var2), EnumDirection.NORTH, var2, true));
    }

    public void useBlock(BlockPosition var0, EntityHuman var1, MovingObjectPositionBlock var2) {
        BlockPosition var3 = this.absolutePos(var0);
        IBlockData var4 = this.getLevel().getBlockState(var3);
        EnumInteractionResult var5 = var4.use(this.getLevel(), var1, EnumHand.MAIN_HAND, var2);
        if (!var5.consumesAction()) {
            ItemActionContext var6 = new ItemActionContext(var1, EnumHand.MAIN_HAND, var2);
            var1.getItemInHand(EnumHand.MAIN_HAND).useOn(var6);
        }
    }

    public EntityLiving makeAboutToDrown(EntityLiving var0) {
        var0.setAirSupply(0);
        var0.setHealth(0.25f);
        return var0;
    }

    public EntityHuman makeMockSurvivalPlayer() {
        return new EntityHuman(this.getLevel(), BlockPosition.ZERO, 0.0f, new GameProfile(UUID.randomUUID(), "test-mock-player")){

            @Override
            public boolean isSpectator() {
                return false;
            }

            @Override
            public boolean isCreative() {
                return false;
            }
        };
    }

    public EntityLiving withLowHealth(EntityLiving var0) {
        var0.setHealth(0.25f);
        return var0;
    }

    public EntityHuman makeMockPlayer() {
        return new EntityHuman(this.getLevel(), BlockPosition.ZERO, 0.0f, new GameProfile(UUID.randomUUID(), "test-mock-player")){

            @Override
            public boolean isSpectator() {
                return false;
            }

            @Override
            public boolean isCreative() {
                return true;
            }

            @Override
            public boolean isLocalPlayer() {
                return true;
            }
        };
    }

    @Deprecated(forRemoval=true)
    public EntityPlayer makeMockServerPlayerInLevel() {
        CommonListenerCookie var0 = CommonListenerCookie.createInitial(new GameProfile(UUID.randomUUID(), "test-mock-player"));
        EntityPlayer var1 = new EntityPlayer(this.getLevel().getServer(), this.getLevel(), var0.gameProfile(), var0.clientInformation()){

            @Override
            public boolean isSpectator() {
                return false;
            }

            @Override
            public boolean isCreative() {
                return true;
            }
        };
        NetworkManager var2 = new NetworkManager(EnumProtocolDirection.SERVERBOUND);
        EmbeddedChannel var3 = new EmbeddedChannel(new ChannelHandler[]{var2});
        var3.attr(NetworkManager.ATTRIBUTE_SERVERBOUND_PROTOCOL).set(EnumProtocol.PLAY.codec(EnumProtocolDirection.SERVERBOUND));
        this.getLevel().getServer().getPlayerList().placeNewPlayer(var2, var1, var0);
        return var1;
    }

    public void pullLever(int var0, int var1, int var2) {
        this.pullLever(new BlockPosition(var0, var1, var2));
    }

    public void pullLever(BlockPosition var0) {
        this.assertBlockPresent(Blocks.LEVER, var0);
        BlockPosition var1 = this.absolutePos(var0);
        IBlockData var2 = this.getLevel().getBlockState(var1);
        BlockLever var3 = (BlockLever)var2.getBlock();
        var3.pull(var2, this.getLevel(), var1);
    }

    public void pulseRedstone(BlockPosition var0, long var1) {
        this.setBlock(var0, Blocks.REDSTONE_BLOCK);
        this.runAfterDelay(var1, () -> this.setBlock(var0, Blocks.AIR));
    }

    public void destroyBlock(BlockPosition var0) {
        this.getLevel().destroyBlock(this.absolutePos(var0), false, null);
    }

    public void setBlock(int var0, int var1, int var2, Block var3) {
        this.setBlock(new BlockPosition(var0, var1, var2), var3);
    }

    public void setBlock(int var0, int var1, int var2, IBlockData var3) {
        this.setBlock(new BlockPosition(var0, var1, var2), var3);
    }

    public void setBlock(BlockPosition var0, Block var1) {
        this.setBlock(var0, var1.defaultBlockState());
    }

    public void setBlock(BlockPosition var0, IBlockData var1) {
        this.getLevel().setBlock(this.absolutePos(var0), var1, 3);
    }

    public void setNight() {
        this.setDayTime(13000);
    }

    public void setDayTime(int var0) {
        this.getLevel().setDayTime(var0);
    }

    public void assertBlockPresent(Block var0, int var1, int var2, int var3) {
        this.assertBlockPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void assertBlockPresent(Block var0, BlockPosition var1) {
        IBlockData var22 = this.getBlockState(var1);
        this.assertBlock(var1, (Block var2) -> var22.is(var0), "Expected " + var0.getName().getString() + ", got " + var22.getBlock().getName().getString());
    }

    public void assertBlockNotPresent(Block var0, int var1, int var2, int var3) {
        this.assertBlockNotPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void assertBlockNotPresent(Block var0, BlockPosition var1) {
        this.assertBlock(var1, (Block var2) -> !this.getBlockState(var1).is(var0), "Did not expect " + var0.getName().getString());
    }

    public void succeedWhenBlockPresent(Block var0, int var1, int var2, int var3) {
        this.succeedWhenBlockPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void succeedWhenBlockPresent(Block var0, BlockPosition var1) {
        this.succeedWhen(() -> this.assertBlockPresent(var0, var1));
    }

    public void assertBlock(BlockPosition var0, Predicate<Block> var1, String var2) {
        this.assertBlock(var0, var1, () -> var2);
    }

    public void assertBlock(BlockPosition var0, Predicate<Block> var12, Supplier<String> var2) {
        this.assertBlockState(var0, var1 -> var12.test(var1.getBlock()), var2);
    }

    public <T extends Comparable<T>> void assertBlockProperty(BlockPosition var0, IBlockState<T> var1, T var2) {
        IBlockData var3 = this.getBlockState(var0);
        boolean var4 = var3.hasProperty(var1);
        if (!var4 || !var3.getValue(var1).equals(var2)) {
            String var5 = var4 ? "was " + var3.getValue(var1) : "property " + var1.getName() + " is missing";
            String var6 = String.format(Locale.ROOT, "Expected property %s to be %s, %s", var1.getName(), var2, var5);
            throw new GameTestHarnessAssertionPosition(var6, this.absolutePos(var0), var0, this.testInfo.getTick());
        }
    }

    public <T extends Comparable<T>> void assertBlockProperty(BlockPosition var0, IBlockState<T> var1, Predicate<T> var22, String var3) {
        this.assertBlockState(var0, var2 -> {
            if (!var2.hasProperty(var1)) {
                return false;
            }
            Object var3 = var2.getValue(var1);
            return var22.test(var3);
        }, () -> var3);
    }

    public void assertBlockState(BlockPosition var0, Predicate<IBlockData> var1, Supplier<String> var2) {
        IBlockData var3 = this.getBlockState(var0);
        if (!var1.test(var3)) {
            throw new GameTestHarnessAssertionPosition(var2.get(), this.absolutePos(var0), var0, this.testInfo.getTick());
        }
    }

    public void assertRedstoneSignal(BlockPosition var0, EnumDirection var1, IntPredicate var2, Supplier<String> var3) {
        BlockPosition var4 = this.absolutePos(var0);
        WorldServer var5 = this.getLevel();
        IBlockData var6 = var5.getBlockState(var4);
        int var7 = var6.getSignal(var5, var4, var1);
        if (!var2.test(var7)) {
            throw new GameTestHarnessAssertionPosition(var3.get(), var4, var0, this.testInfo.getTick());
        }
    }

    public void assertEntityPresent(EntityTypes<?> var0) {
        List<Entity> var1 = this.getLevel().getEntities(var0, this.getBounds(), Entity::isAlive);
        if (var1.isEmpty()) {
            throw new GameTestHarnessAssertion("Expected " + var0.toShortString() + " to exist");
        }
    }

    public void assertEntityPresent(EntityTypes<?> var0, int var1, int var2, int var3) {
        this.assertEntityPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void assertEntityPresent(EntityTypes<?> var0, BlockPosition var1) {
        BlockPosition var2 = this.absolutePos(var1);
        List<Entity> var3 = this.getLevel().getEntities(var0, new AxisAlignedBB(var2), Entity::isAlive);
        if (var3.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + var0.toShortString(), var2, var1, this.testInfo.getTick());
        }
    }

    public void assertEntityPresent(EntityTypes<?> var0, Vec3D var1, Vec3D var2) {
        List<Entity> var3 = this.getLevel().getEntities(var0, new AxisAlignedBB(var1, var2), Entity::isAlive);
        if (var3.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + var0.toShortString() + " between ", BlockPosition.containing(var1), BlockPosition.containing(var2), this.testInfo.getTick());
        }
    }

    public void assertEntitiesPresent(EntityTypes<?> var0, int var1) {
        List<Entity> var2 = this.getLevel().getEntities(var0, this.getBounds(), Entity::isAlive);
        if (var2.size() != var1) {
            throw new GameTestHarnessAssertion("Expected " + var1 + " of type " + var0.toShortString() + " to exist, found " + var2.size());
        }
    }

    public void assertEntitiesPresent(EntityTypes<?> var0, BlockPosition var1, int var2, double var3) {
        BlockPosition var5 = this.absolutePos(var1);
        List<?> var6 = this.getEntities(var0, var1, var3);
        if (var6.size() != var2) {
            throw new GameTestHarnessAssertionPosition("Expected " + var2 + " entities of type " + var0.toShortString() + ", actual number of entities found=" + var6.size(), var5, var1, this.testInfo.getTick());
        }
    }

    public void assertEntityPresent(EntityTypes<?> var0, BlockPosition var1, double var2) {
        List<?> var4 = this.getEntities(var0, var1, var2);
        if (var4.isEmpty()) {
            BlockPosition var5 = this.absolutePos(var1);
            throw new GameTestHarnessAssertionPosition("Expected " + var0.toShortString(), var5, var1, this.testInfo.getTick());
        }
    }

    public <T extends Entity> List<T> getEntities(EntityTypes<T> var0, BlockPosition var1, double var2) {
        BlockPosition var4 = this.absolutePos(var1);
        return this.getLevel().getEntities(var0, new AxisAlignedBB(var4).inflate(var2), Entity::isAlive);
    }

    public void assertEntityInstancePresent(Entity var0, int var1, int var2, int var3) {
        this.assertEntityInstancePresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void assertEntityInstancePresent(Entity var0, BlockPosition var12) {
        BlockPosition var2 = this.absolutePos(var12);
        List<Entity> var3 = this.getLevel().getEntities(var0.getType(), new AxisAlignedBB(var2), Entity::isAlive);
        var3.stream().filter(var1 -> var1 == var0).findFirst().orElseThrow(() -> new GameTestHarnessAssertionPosition("Expected " + var0.getType().toShortString(), var2, var12, this.testInfo.getTick()));
    }

    public void assertItemEntityCountIs(Item var0, BlockPosition var1, double var2, int var4) {
        BlockPosition var5 = this.absolutePos(var1);
        List<EntityItem> var6 = this.getLevel().getEntities(EntityTypes.ITEM, new AxisAlignedBB(var5).inflate(var2), Entity::isAlive);
        int var7 = 0;
        for (EntityItem var9 : var6) {
            ItemStack var10 = var9.getItem();
            if (!var10.is(var0)) continue;
            var7 += var10.getCount();
        }
        if (var7 != var4) {
            throw new GameTestHarnessAssertionPosition("Expected " + var4 + " " + var0.getDescription().getString() + " items to exist (found " + var7 + ")", var5, var1, this.testInfo.getTick());
        }
    }

    public void assertItemEntityPresent(Item var0, BlockPosition var1, double var2) {
        BlockPosition var4 = this.absolutePos(var1);
        List<EntityItem> var5 = this.getLevel().getEntities(EntityTypes.ITEM, new AxisAlignedBB(var4).inflate(var2), Entity::isAlive);
        for (Entity entity : var5) {
            EntityItem var8 = (EntityItem)entity;
            if (!var8.getItem().getItem().equals(var0)) continue;
            return;
        }
        throw new GameTestHarnessAssertionPosition("Expected " + var0.getDescription().getString() + " item", var4, var1, this.testInfo.getTick());
    }

    public void assertItemEntityNotPresent(Item var0, BlockPosition var1, double var2) {
        BlockPosition var4 = this.absolutePos(var1);
        List<EntityItem> var5 = this.getLevel().getEntities(EntityTypes.ITEM, new AxisAlignedBB(var4).inflate(var2), Entity::isAlive);
        for (Entity entity : var5) {
            EntityItem var8 = (EntityItem)entity;
            if (!var8.getItem().getItem().equals(var0)) continue;
            throw new GameTestHarnessAssertionPosition("Did not expect " + var0.getDescription().getString() + " item", var4, var1, this.testInfo.getTick());
        }
    }

    public void assertItemEntityPresent(Item var0) {
        List<EntityItem> var1 = this.getLevel().getEntities(EntityTypes.ITEM, this.getBounds(), Entity::isAlive);
        for (Entity entity : var1) {
            EntityItem var4 = (EntityItem)entity;
            if (!var4.getItem().getItem().equals(var0)) continue;
            return;
        }
        throw new GameTestHarnessAssertion("Expected " + var0.getDescription().getString() + " item");
    }

    public void assertItemEntityNotPresent(Item var0) {
        List<EntityItem> var1 = this.getLevel().getEntities(EntityTypes.ITEM, this.getBounds(), Entity::isAlive);
        for (Entity entity : var1) {
            EntityItem var4 = (EntityItem)entity;
            if (!var4.getItem().getItem().equals(var0)) continue;
            throw new GameTestHarnessAssertion("Did not expect " + var0.getDescription().getString() + " item");
        }
    }

    public void assertEntityNotPresent(EntityTypes<?> var0) {
        List<Entity> var1 = this.getLevel().getEntities(var0, this.getBounds(), Entity::isAlive);
        if (!var1.isEmpty()) {
            throw new GameTestHarnessAssertion("Did not expect " + var0.toShortString() + " to exist");
        }
    }

    public void assertEntityNotPresent(EntityTypes<?> var0, int var1, int var2, int var3) {
        this.assertEntityNotPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void assertEntityNotPresent(EntityTypes<?> var0, BlockPosition var1) {
        BlockPosition var2 = this.absolutePos(var1);
        List<Entity> var3 = this.getLevel().getEntities(var0, new AxisAlignedBB(var2), Entity::isAlive);
        if (!var3.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Did not expect " + var0.toShortString(), var2, var1, this.testInfo.getTick());
        }
    }

    public void assertEntityTouching(EntityTypes<?> var0, double var12, double var3, double var5) {
        Vec3D var7 = new Vec3D(var12, var3, var5);
        Vec3D var8 = this.absoluteVec(var7);
        Predicate<Entity> var9 = var1 -> var1.getBoundingBox().intersects(var8, var8);
        List<Entity> var10 = this.getLevel().getEntities(var0, this.getBounds(), var9);
        if (var10.isEmpty()) {
            throw new GameTestHarnessAssertion("Expected " + var0.toShortString() + " to touch " + var8 + " (relative " + var7 + ")");
        }
    }

    public void assertEntityNotTouching(EntityTypes<?> var0, double var12, double var3, double var5) {
        Vec3D var7 = new Vec3D(var12, var3, var5);
        Vec3D var8 = this.absoluteVec(var7);
        Predicate<Entity> var9 = var1 -> !var1.getBoundingBox().intersects(var8, var8);
        List<Entity> var10 = this.getLevel().getEntities(var0, this.getBounds(), var9);
        if (var10.isEmpty()) {
            throw new GameTestHarnessAssertion("Did not expect " + var0.toShortString() + " to touch " + var8 + " (relative " + var7 + ")");
        }
    }

    public <E extends Entity, T> void assertEntityData(BlockPosition var0, EntityTypes<E> var1, Function<? super E, T> var2, @Nullable T var3) {
        BlockPosition var4 = this.absolutePos(var0);
        List<Entity> var5 = this.getLevel().getEntities(var1, new AxisAlignedBB(var4), Entity::isAlive);
        if (var5.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + var1.toShortString(), var4, var0, this.testInfo.getTick());
        }
        for (Entity var7 : var5) {
            T var8 = var2.apply(var7);
            if (!(var8 == null ? var3 != null : !var8.equals(var3))) continue;
            throw new GameTestHarnessAssertion("Expected entity data to be: " + var3 + ", but was: " + var8);
        }
    }

    public <E extends EntityLiving> void assertEntityIsHolding(BlockPosition var0, EntityTypes<E> var1, Item var2) {
        BlockPosition var3 = this.absolutePos(var0);
        List<EntityLiving> var4 = this.getLevel().getEntities(var1, new AxisAlignedBB(var3), Entity::isAlive);
        if (var4.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected entity of type: " + var1, var3, var0, this.getTick());
        }
        for (EntityLiving var6 : var4) {
            if (!var6.isHolding(var2)) continue;
            return;
        }
        throw new GameTestHarnessAssertionPosition("Entity should be holding: " + var2, var3, var0, this.getTick());
    }

    public <E extends Entity> void assertEntityInventoryContains(BlockPosition var02, EntityTypes<E> var12, Item var2) {
        BlockPosition var3 = this.absolutePos(var02);
        List<Entity> var4 = this.getLevel().getEntities(var12, new AxisAlignedBB(var3), var0 -> ((Entity)var0).isAlive());
        if (var4.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + var12.toShortString() + " to exist", var3, var02, this.getTick());
        }
        for (Entity var6 : var4) {
            if (!((InventoryCarrier)((Object)var6)).getInventory().hasAnyMatching(var1 -> var1.is(var2))) continue;
            return;
        }
        throw new GameTestHarnessAssertionPosition("Entity inventory should contain: " + var2, var3, var02, this.getTick());
    }

    public void assertContainerEmpty(BlockPosition var0) {
        BlockPosition var1 = this.absolutePos(var0);
        TileEntity var2 = this.getLevel().getBlockEntity(var1);
        if (var2 instanceof TileEntityContainer && !((TileEntityContainer)var2).isEmpty()) {
            throw new GameTestHarnessAssertion("Container should be empty");
        }
    }

    public void assertContainerContains(BlockPosition var0, Item var1) {
        BlockPosition var2 = this.absolutePos(var0);
        TileEntity var3 = this.getLevel().getBlockEntity(var2);
        if (!(var3 instanceof TileEntityContainer)) {
            throw new GameTestHarnessAssertion("Expected a container at " + var0 + ", found " + BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(var3.getType()));
        }
        if (((TileEntityContainer)var3).countItem(var1) != 1) {
            throw new GameTestHarnessAssertion("Container should contain: " + var1);
        }
    }

    public void assertSameBlockStates(StructureBoundingBox var0, BlockPosition var1) {
        BlockPosition.betweenClosedStream(var0).forEach(var2 -> {
            BlockPosition var3 = var1.offset(var2.getX() - var0.minX(), var2.getY() - var0.minY(), var2.getZ() - var0.minZ());
            this.assertSameBlockState((BlockPosition)var2, var3);
        });
    }

    public void assertSameBlockState(BlockPosition var0, BlockPosition var1) {
        IBlockData var3;
        IBlockData var2 = this.getBlockState(var0);
        if (var2 != (var3 = this.getBlockState(var1))) {
            this.fail("Incorrect state. Expected " + var3 + ", got " + var2, var0);
        }
    }

    public void assertAtTickTimeContainerContains(long var0, BlockPosition var2, Item var3) {
        this.runAtTickTime(var0, () -> this.assertContainerContains(var2, var3));
    }

    public void assertAtTickTimeContainerEmpty(long var0, BlockPosition var2) {
        this.runAtTickTime(var0, () -> this.assertContainerEmpty(var2));
    }

    public <E extends Entity, T> void succeedWhenEntityData(BlockPosition var0, EntityTypes<E> var1, Function<E, T> var2, T var3) {
        this.succeedWhen(() -> this.assertEntityData(var0, var1, var2, var3));
    }

    public <E extends Entity> void assertEntityProperty(E var0, Predicate<E> var1, String var2) {
        if (!var1.test(var0)) {
            throw new GameTestHarnessAssertion("Entity " + var0 + " failed " + var2 + " test");
        }
    }

    public <E extends Entity, T> void assertEntityProperty(E var0, Function<E, T> var1, String var2, T var3) {
        T var4 = var1.apply(var0);
        if (!var4.equals(var3)) {
            throw new GameTestHarnessAssertion("Entity " + var0 + " value " + var2 + "=" + var4 + " is not equal to expected " + var3);
        }
    }

    public void assertLivingEntityHasMobEffect(EntityLiving var0, MobEffectList var1, int var2) {
        MobEffect var3 = var0.getEffect(var1);
        if (var3 == null || var3.getAmplifier() != var2) {
            int var4 = var2 + 1;
            throw new GameTestHarnessAssertion("Entity " + var0 + " failed has " + var1.getDescriptionId() + " x " + var4 + " test");
        }
    }

    public void succeedWhenEntityPresent(EntityTypes<?> var0, int var1, int var2, int var3) {
        this.succeedWhenEntityPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void succeedWhenEntityPresent(EntityTypes<?> var0, BlockPosition var1) {
        this.succeedWhen(() -> this.assertEntityPresent(var0, var1));
    }

    public void succeedWhenEntityNotPresent(EntityTypes<?> var0, int var1, int var2, int var3) {
        this.succeedWhenEntityNotPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void succeedWhenEntityNotPresent(EntityTypes<?> var0, BlockPosition var1) {
        this.succeedWhen(() -> this.assertEntityNotPresent(var0, var1));
    }

    public void succeed() {
        this.testInfo.succeed();
    }

    private void ensureSingleFinalCheck() {
        if (this.finalCheckAdded) {
            throw new IllegalStateException("This test already has final clause");
        }
        this.finalCheckAdded = true;
    }

    public void succeedIf(Runnable var0) {
        this.ensureSingleFinalCheck();
        this.testInfo.createSequence().thenWaitUntil(0L, var0).thenSucceed();
    }

    public void succeedWhen(Runnable var0) {
        this.ensureSingleFinalCheck();
        this.testInfo.createSequence().thenWaitUntil(var0).thenSucceed();
    }

    public void succeedOnTickWhen(int var0, Runnable var1) {
        this.ensureSingleFinalCheck();
        this.testInfo.createSequence().thenWaitUntil(var0, var1).thenSucceed();
    }

    public void runAtTickTime(long var0, Runnable var2) {
        this.testInfo.setRunAtTickTime(var0, var2);
    }

    public void runAfterDelay(long var0, Runnable var2) {
        this.runAtTickTime(this.testInfo.getTick() + var0, var2);
    }

    public void randomTick(BlockPosition var0) {
        BlockPosition var1 = this.absolutePos(var0);
        WorldServer var2 = this.getLevel();
        var2.getBlockState(var1).randomTick(var2, var1, var2.random);
    }

    public void tickPrecipitation(BlockPosition var0) {
        BlockPosition var1 = this.absolutePos(var0);
        WorldServer var2 = this.getLevel();
        var2.tickPrecipitation(var1);
    }

    public void tickPrecipitation() {
        AxisAlignedBB var0 = this.getRelativeBounds();
        int var1 = (int)Math.floor(var0.maxX);
        int var2 = (int)Math.floor(var0.maxZ);
        int var3 = (int)Math.floor(var0.maxY);
        for (int var4 = (int)Math.floor(var0.minX); var4 < var1; ++var4) {
            for (int var5 = (int)Math.floor(var0.minZ); var5 < var2; ++var5) {
                this.tickPrecipitation(new BlockPosition(var4, var3, var5));
            }
        }
    }

    public int getHeight(HeightMap.Type var0, int var1, int var2) {
        BlockPosition var3 = this.absolutePos(new BlockPosition(var1, 0, var2));
        return this.relativePos(this.getLevel().getHeightmapPos(var0, var3)).getY();
    }

    public void fail(String var0, BlockPosition var1) {
        throw new GameTestHarnessAssertionPosition(var0, this.absolutePos(var1), var1, this.getTick());
    }

    public void fail(String var0, Entity var1) {
        throw new GameTestHarnessAssertionPosition(var0, var1.blockPosition(), this.relativePos(var1.blockPosition()), this.getTick());
    }

    public void fail(String var0) {
        throw new GameTestHarnessAssertion(var0);
    }

    public void failIf(Runnable var0) {
        this.testInfo.createSequence().thenWaitUntil(var0).thenFail(() -> new GameTestHarnessAssertion("Fail conditions met"));
    }

    public void failIfEver(Runnable var0) {
        LongStream.range(this.testInfo.getTick(), this.testInfo.getTimeoutTicks()).forEach(var1 -> this.testInfo.setRunAtTickTime(var1, var0::run));
    }

    public GameTestHarnessSequence startSequence() {
        return this.testInfo.createSequence();
    }

    public BlockPosition absolutePos(BlockPosition var0) {
        BlockPosition var1 = this.testInfo.getStructureBlockPos();
        BlockPosition var2 = var1.offset(var0);
        return DefinedStructure.transform(var2, EnumBlockMirror.NONE, this.testInfo.getRotation(), var1);
    }

    public BlockPosition relativePos(BlockPosition var0) {
        BlockPosition var1 = this.testInfo.getStructureBlockPos();
        EnumBlockRotation var2 = this.testInfo.getRotation().getRotated(EnumBlockRotation.CLOCKWISE_180);
        BlockPosition var3 = DefinedStructure.transform(var0, EnumBlockMirror.NONE, var2, var1);
        return var3.subtract(var1);
    }

    public Vec3D absoluteVec(Vec3D var0) {
        Vec3D var1 = Vec3D.atLowerCornerOf(this.testInfo.getStructureBlockPos());
        return DefinedStructure.transform(var1.add(var0), EnumBlockMirror.NONE, this.testInfo.getRotation(), this.testInfo.getStructureBlockPos());
    }

    public Vec3D relativeVec(Vec3D var0) {
        Vec3D var1 = Vec3D.atLowerCornerOf(this.testInfo.getStructureBlockPos());
        return DefinedStructure.transform(var0.subtract(var1), EnumBlockMirror.NONE, this.testInfo.getRotation(), this.testInfo.getStructureBlockPos());
    }

    public void assertTrue(boolean var0, String var1) {
        if (!var0) {
            throw new GameTestHarnessAssertion(var1);
        }
    }

    public void assertFalse(boolean var0, String var1) {
        if (var0) {
            throw new GameTestHarnessAssertion(var1);
        }
    }

    public long getTick() {
        return this.testInfo.getTick();
    }

    public AxisAlignedBB getBounds() {
        return this.testInfo.getStructureBounds();
    }

    private AxisAlignedBB getRelativeBounds() {
        AxisAlignedBB var0 = this.testInfo.getStructureBounds();
        return var0.move(BlockPosition.ZERO.subtract(this.absolutePos(BlockPosition.ZERO)));
    }

    public void forEveryBlockInStructure(Consumer<BlockPosition> var0) {
        AxisAlignedBB var1 = this.getRelativeBounds();
        BlockPosition.MutableBlockPosition.betweenClosedStream(var1.move(0.0, 1.0, 0.0)).forEach(var0);
    }

    public void onEachTick(Runnable var0) {
        LongStream.range(this.testInfo.getTick(), this.testInfo.getTimeoutTicks()).forEach(var1 -> this.testInfo.setRunAtTickTime(var1, var0::run));
    }

    public void placeAt(EntityHuman var0, ItemStack var1, BlockPosition var2, EnumDirection var3) {
        BlockPosition var4 = this.absolutePos(var2.relative(var3));
        MovingObjectPositionBlock var5 = new MovingObjectPositionBlock(Vec3D.atCenterOf(var4), var3, var4, false);
        ItemActionContext var6 = new ItemActionContext(var0, EnumHand.MAIN_HAND, var5);
        var1.useOn(var6);
    }

    public void setBiome(ResourceKey<BiomeBase> var0) {
        AxisAlignedBB var1 = this.getBounds();
        BlockPosition var2 = BlockPosition.containing(var1.minX, var1.minY, var1.minZ);
        BlockPosition var3 = BlockPosition.containing(var1.maxX, var1.maxY, var1.maxZ);
        Either<Integer, CommandSyntaxException> var4 = FillBiomeCommand.fill(this.getLevel(), var2, var3, this.getLevel().registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(var0));
        if (var4.right().isPresent()) {
            this.fail("Failed to set biome for test");
        }
    }
}

