/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.biome;

import javax.annotation.Nullable;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BiomeSettings;
import net.minecraft.data.worldgen.WorldGenCarvers;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.CaveSoundSettings;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class OverworldBiomes {
    protected static final int NORMAL_WATER_COLOR = 4159204;
    protected static final int NORMAL_WATER_FOG_COLOR = 329011;
    private static final int OVERWORLD_FOG_COLOR = 12638463;
    @Nullable
    private static final Music NORMAL_MUSIC = null;

    protected static int calculateSkyColor(float var0) {
        float var1 = var0;
        var1 /= 3.0f;
        var1 = MathHelper.clamp(var1, -1.0f, 1.0f);
        return MathHelper.hsvToRgb(0.62222224f - var1 * 0.05f, 0.5f + var1 * 0.1f, 1.0f);
    }

    private static BiomeBase biome(boolean var0, float var1, float var2, BiomeSettingsMobs.a var3, BiomeSettingsGeneration.a var4, @Nullable Music var5) {
        return OverworldBiomes.biome(var0, var1, var2, 4159204, 329011, null, null, var3, var4, var5);
    }

    private static BiomeBase biome(boolean var0, float var1, float var2, int var3, int var4, @Nullable Integer var5, @Nullable Integer var6, BiomeSettingsMobs.a var7, BiomeSettingsGeneration.a var8, @Nullable Music var9) {
        BiomeFog.a var10 = new BiomeFog.a().waterColor(var3).waterFogColor(var4).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(var1)).ambientMoodSound(CaveSoundSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(var9);
        if (var5 != null) {
            var10.grassColorOverride(var5);
        }
        if (var6 != null) {
            var10.foliageColorOverride(var6);
        }
        return new BiomeBase.a().hasPrecipitation(var0).temperature(var1).downfall(var2).specialEffects(var10.build()).mobSpawnSettings(var7.build()).generationSettings(var8.build()).build();
    }

    private static void globalOverworldGeneration(BiomeSettingsGeneration.a var0) {
        BiomeSettings.addDefaultCarversAndLakes(var0);
        BiomeSettings.addDefaultCrystalFormations(var0);
        BiomeSettings.addDefaultMonsterRoom(var0);
        BiomeSettings.addDefaultUndergroundVariety(var0);
        BiomeSettings.addDefaultSprings(var0);
        BiomeSettings.addSurfaceFreezing(var0);
    }

    public static BiomeBase oldGrowthTaiga(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var3);
        var3.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.WOLF, 8, 4, 4));
        var3.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 4, 2, 3));
        var3.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.FOX, 8, 2, 4));
        if (var2) {
            BiomeSettings.commonSpawns(var3);
        } else {
            BiomeSettings.caveSpawns(var3);
            BiomeSettings.monsters(var3, 100, 25, 100, false);
        }
        BiomeSettingsGeneration.a var4 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        BiomeSettings.addMossyStoneBlock(var4);
        BiomeSettings.addFerns(var4);
        BiomeSettings.addDefaultOres(var4);
        BiomeSettings.addDefaultSoftDisks(var4);
        var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, var2 ? VegetationPlacements.TREES_OLD_GROWTH_SPRUCE_TAIGA : VegetationPlacements.TREES_OLD_GROWTH_PINE_TAIGA);
        BiomeSettings.addDefaultFlowers(var4);
        BiomeSettings.addGiantTaigaVegetation(var4);
        BiomeSettings.addDefaultMushrooms(var4);
        BiomeSettings.addDefaultExtraVegetation(var4);
        BiomeSettings.addCommonBerryBushes(var4);
        Music var5 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_OLD_GROWTH_TAIGA);
        return OverworldBiomes.biome(true, var2 ? 0.25f : 0.3f, 0.8f, var3, var4, var5);
    }

    public static BiomeBase sparseJungle(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.baseJungleSpawns(var2);
        return OverworldBiomes.baseJungle(var0, var1, 0.8f, false, true, false, var2, Musics.createGameMusic(SoundEffects.MUSIC_BIOME_SPARSE_JUNGLE));
    }

    public static BiomeBase jungle(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.baseJungleSpawns(var2);
        var2.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.PARROT, 40, 1, 2)).addSpawn(EnumCreatureType.MONSTER, new BiomeSettingsMobs.c(EntityTypes.OCELOT, 2, 1, 3)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.PANDA, 1, 1, 2));
        return OverworldBiomes.baseJungle(var0, var1, 0.9f, false, false, true, var2, Musics.createGameMusic(SoundEffects.MUSIC_BIOME_JUNGLE));
    }

    public static BiomeBase bambooJungle(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.baseJungleSpawns(var2);
        var2.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.PARROT, 40, 1, 2)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.PANDA, 80, 1, 2)).addSpawn(EnumCreatureType.MONSTER, new BiomeSettingsMobs.c(EntityTypes.OCELOT, 2, 1, 1));
        return OverworldBiomes.baseJungle(var0, var1, 0.9f, true, false, true, var2, Musics.createGameMusic(SoundEffects.MUSIC_BIOME_BAMBOO_JUNGLE));
    }

    private static BiomeBase baseJungle(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, float var2, boolean var3, boolean var4, boolean var5, BiomeSettingsMobs.a var6, Music var7) {
        BiomeSettingsGeneration.a var8 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var8);
        BiomeSettings.addDefaultOres(var8);
        BiomeSettings.addDefaultSoftDisks(var8);
        if (var3) {
            BiomeSettings.addBambooVegetation(var8);
        } else {
            if (var5) {
                BiomeSettings.addLightBambooVegetation(var8);
            }
            if (var4) {
                BiomeSettings.addSparseJungleTrees(var8);
            } else {
                BiomeSettings.addJungleTrees(var8);
            }
        }
        BiomeSettings.addWarmFlowers(var8);
        BiomeSettings.addJungleGrass(var8);
        BiomeSettings.addDefaultMushrooms(var8);
        BiomeSettings.addDefaultExtraVegetation(var8);
        BiomeSettings.addJungleVines(var8);
        if (var4) {
            BiomeSettings.addSparseJungleMelons(var8);
        } else {
            BiomeSettings.addJungleMelons(var8);
        }
        return OverworldBiomes.biome(true, 0.95f, var2, var6, var8, var7);
    }

    public static BiomeBase windsweptHills(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var3);
        var3.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.LLAMA, 5, 4, 6));
        BiomeSettings.commonSpawns(var3);
        BiomeSettingsGeneration.a var4 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        BiomeSettings.addDefaultOres(var4);
        BiomeSettings.addDefaultSoftDisks(var4);
        if (var2) {
            BiomeSettings.addMountainForestTrees(var4);
        } else {
            BiomeSettings.addMountainTrees(var4);
        }
        BiomeSettings.addDefaultFlowers(var4);
        BiomeSettings.addDefaultGrass(var4);
        BiomeSettings.addDefaultMushrooms(var4);
        BiomeSettings.addDefaultExtraVegetation(var4);
        BiomeSettings.addExtraEmeralds(var4);
        BiomeSettings.addInfestedStone(var4);
        return OverworldBiomes.biome(true, 0.2f, 0.3f, var3, var4, NORMAL_MUSIC);
    }

    public static BiomeBase desert(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.desertSpawns(var2);
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettings.addFossilDecoration(var3);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addDefaultSoftDisks(var3);
        BiomeSettings.addDefaultFlowers(var3);
        BiomeSettings.addDefaultGrass(var3);
        BiomeSettings.addDesertVegetation(var3);
        BiomeSettings.addDefaultMushrooms(var3);
        BiomeSettings.addDesertExtraVegetation(var3);
        BiomeSettings.addDesertExtraDecoration(var3);
        return OverworldBiomes.biome(false, 2.0f, 0.0f, var2, var3, Musics.createGameMusic(SoundEffects.MUSIC_BIOME_DESERT));
    }

    public static BiomeBase plains(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2, boolean var3, boolean var4) {
        BiomeSettingsMobs.a var5 = new BiomeSettingsMobs.a();
        BiomeSettingsGeneration.a var6 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var6);
        if (var3) {
            var5.creatureGenerationProbability(0.07f);
            BiomeSettings.snowySpawns(var5);
            if (var4) {
                var6.addFeature(WorldGenStage.Decoration.SURFACE_STRUCTURES, MiscOverworldPlacements.ICE_SPIKE);
                var6.addFeature(WorldGenStage.Decoration.SURFACE_STRUCTURES, MiscOverworldPlacements.ICE_PATCH);
            }
        } else {
            BiomeSettings.plainsSpawns(var5);
            BiomeSettings.addPlainGrass(var6);
            if (var2) {
                var6.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_SUNFLOWER);
            }
        }
        BiomeSettings.addDefaultOres(var6);
        BiomeSettings.addDefaultSoftDisks(var6);
        if (var3) {
            BiomeSettings.addSnowyTrees(var6);
            BiomeSettings.addDefaultFlowers(var6);
            BiomeSettings.addDefaultGrass(var6);
        } else {
            BiomeSettings.addPlainVegetation(var6);
        }
        BiomeSettings.addDefaultMushrooms(var6);
        if (var2) {
            var6.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_SUGAR_CANE);
            var6.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_PUMPKIN);
        } else {
            BiomeSettings.addDefaultExtraVegetation(var6);
        }
        float var7 = var3 ? 0.0f : 0.8f;
        return OverworldBiomes.biome(true, var7, var3 ? 0.5f : 0.4f, var5, var6, NORMAL_MUSIC);
    }

    public static BiomeBase mushroomFields(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.mooshroomSpawns(var2);
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addDefaultSoftDisks(var3);
        BiomeSettings.addMushroomFieldVegetation(var3);
        BiomeSettings.addDefaultExtraVegetation(var3);
        return OverworldBiomes.biome(true, 0.9f, 1.0f, var2, var3, NORMAL_MUSIC);
    }

    public static BiomeBase savanna(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2, boolean var3) {
        BiomeSettingsGeneration.a var4 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        if (!var2) {
            BiomeSettings.addSavannaGrass(var4);
        }
        BiomeSettings.addDefaultOres(var4);
        BiomeSettings.addDefaultSoftDisks(var4);
        if (var2) {
            BiomeSettings.addShatteredSavannaTrees(var4);
            BiomeSettings.addDefaultFlowers(var4);
            BiomeSettings.addShatteredSavannaGrass(var4);
        } else {
            BiomeSettings.addSavannaTrees(var4);
            BiomeSettings.addWarmFlowers(var4);
            BiomeSettings.addSavannaExtraGrass(var4);
        }
        BiomeSettings.addDefaultMushrooms(var4);
        BiomeSettings.addDefaultExtraVegetation(var4);
        BiomeSettingsMobs.a var5 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var5);
        var5.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.HORSE, 1, 2, 6)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.DONKEY, 1, 1, 1));
        BiomeSettings.commonSpawns(var5);
        if (var3) {
            var5.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.LLAMA, 8, 4, 4));
        }
        return OverworldBiomes.biome(false, 2.0f, 0.0f, var5, var4, NORMAL_MUSIC);
    }

    public static BiomeBase badlands(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettings.commonSpawns(var3);
        BiomeSettingsGeneration.a var4 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        BiomeSettings.addDefaultOres(var4);
        BiomeSettings.addExtraGold(var4);
        BiomeSettings.addDefaultSoftDisks(var4);
        if (var2) {
            BiomeSettings.addBadlandsTrees(var4);
        }
        BiomeSettings.addBadlandGrass(var4);
        BiomeSettings.addDefaultMushrooms(var4);
        BiomeSettings.addBadlandExtraVegetation(var4);
        return new BiomeBase.a().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeFog.a().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(2.0f)).foliageColorOverride(10387789).grassColorOverride(9470285).ambientMoodSound(CaveSoundSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic(SoundEffects.MUSIC_BIOME_BADLANDS)).build()).mobSpawnSettings(var3.build()).generationSettings(var4.build()).build();
    }

    private static BiomeBase baseOcean(BiomeSettingsMobs.a var0, int var1, int var2, BiomeSettingsGeneration.a var3) {
        return OverworldBiomes.biome(true, 0.5f, 0.5f, var1, var2, null, null, var0, var3, NORMAL_MUSIC);
    }

    private static BiomeSettingsGeneration.a baseOceanGeneration(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeSettings.addDefaultOres(var2);
        BiomeSettings.addDefaultSoftDisks(var2);
        BiomeSettings.addWaterTrees(var2);
        BiomeSettings.addDefaultFlowers(var2);
        BiomeSettings.addDefaultGrass(var2);
        BiomeSettings.addDefaultMushrooms(var2);
        BiomeSettings.addDefaultExtraVegetation(var2);
        return var2;
    }

    public static BiomeBase coldOcean(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettings.oceanSpawns(var3, 3, 4, 15);
        var3.addSpawn(EnumCreatureType.WATER_AMBIENT, new BiomeSettingsMobs.c(EntityTypes.SALMON, 15, 1, 5));
        BiomeSettingsGeneration.a var4 = OverworldBiomes.baseOceanGeneration(var0, var1);
        var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, var2 ? AquaticPlacements.SEAGRASS_DEEP_COLD : AquaticPlacements.SEAGRASS_COLD);
        BiomeSettings.addDefaultSeagrass(var4);
        BiomeSettings.addColdOceanExtraVegetation(var4);
        return OverworldBiomes.baseOcean(var3, 4020182, 329011, var4);
    }

    public static BiomeBase ocean(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettings.oceanSpawns(var3, 1, 4, 10);
        var3.addSpawn(EnumCreatureType.WATER_CREATURE, new BiomeSettingsMobs.c(EntityTypes.DOLPHIN, 1, 1, 2));
        BiomeSettingsGeneration.a var4 = OverworldBiomes.baseOceanGeneration(var0, var1);
        var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, var2 ? AquaticPlacements.SEAGRASS_DEEP : AquaticPlacements.SEAGRASS_NORMAL);
        BiomeSettings.addDefaultSeagrass(var4);
        BiomeSettings.addColdOceanExtraVegetation(var4);
        return OverworldBiomes.baseOcean(var3, 4159204, 329011, var4);
    }

    public static BiomeBase lukeWarmOcean(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        if (var2) {
            BiomeSettings.oceanSpawns(var3, 8, 4, 8);
        } else {
            BiomeSettings.oceanSpawns(var3, 10, 2, 15);
        }
        var3.addSpawn(EnumCreatureType.WATER_AMBIENT, new BiomeSettingsMobs.c(EntityTypes.PUFFERFISH, 5, 1, 3)).addSpawn(EnumCreatureType.WATER_AMBIENT, new BiomeSettingsMobs.c(EntityTypes.TROPICAL_FISH, 25, 8, 8)).addSpawn(EnumCreatureType.WATER_CREATURE, new BiomeSettingsMobs.c(EntityTypes.DOLPHIN, 2, 1, 2));
        BiomeSettingsGeneration.a var4 = OverworldBiomes.baseOceanGeneration(var0, var1);
        var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, var2 ? AquaticPlacements.SEAGRASS_DEEP_WARM : AquaticPlacements.SEAGRASS_WARM);
        if (var2) {
            BiomeSettings.addDefaultSeagrass(var4);
        }
        BiomeSettings.addLukeWarmKelp(var4);
        return OverworldBiomes.baseOcean(var3, 4566514, 267827, var4);
    }

    public static BiomeBase warmOcean(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a().addSpawn(EnumCreatureType.WATER_AMBIENT, new BiomeSettingsMobs.c(EntityTypes.PUFFERFISH, 15, 1, 3));
        BiomeSettings.warmOceanSpawns(var2, 10, 4);
        BiomeSettingsGeneration.a var3 = OverworldBiomes.baseOceanGeneration(var0, var1).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, AquaticPlacements.WARM_OCEAN_VEGETATION).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_WARM).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEA_PICKLE);
        return OverworldBiomes.baseOcean(var2, 4445678, 270131, var3);
    }

    public static BiomeBase frozenOcean(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a().addSpawn(EnumCreatureType.WATER_CREATURE, new BiomeSettingsMobs.c(EntityTypes.SQUID, 1, 1, 4)).addSpawn(EnumCreatureType.WATER_AMBIENT, new BiomeSettingsMobs.c(EntityTypes.SALMON, 15, 1, 5)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.POLAR_BEAR, 1, 1, 2));
        BiomeSettings.commonSpawns(var3);
        var3.addSpawn(EnumCreatureType.MONSTER, new BiomeSettingsMobs.c(EntityTypes.DROWNED, 5, 1, 1));
        float var4 = var2 ? 0.5f : 0.0f;
        BiomeSettingsGeneration.a var5 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettings.addIcebergs(var5);
        OverworldBiomes.globalOverworldGeneration(var5);
        BiomeSettings.addBlueIce(var5);
        BiomeSettings.addDefaultOres(var5);
        BiomeSettings.addDefaultSoftDisks(var5);
        BiomeSettings.addWaterTrees(var5);
        BiomeSettings.addDefaultFlowers(var5);
        BiomeSettings.addDefaultGrass(var5);
        BiomeSettings.addDefaultMushrooms(var5);
        BiomeSettings.addDefaultExtraVegetation(var5);
        return new BiomeBase.a().hasPrecipitation(true).temperature(var4).temperatureAdjustment(BiomeBase.TemperatureModifier.FROZEN).downfall(0.5f).specialEffects(new BiomeFog.a().waterColor(3750089).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(var4)).ambientMoodSound(CaveSoundSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(var3.build()).generationSettings(var5.build()).build();
    }

    public static BiomeBase forest(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2, boolean var3, boolean var4) {
        Music var6;
        BiomeSettingsGeneration.a var5 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var5);
        if (var4) {
            var6 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_FLOWER_FOREST);
            var5.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_FOREST_FLOWERS);
        } else {
            var6 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_FOREST);
            BiomeSettings.addForestFlowers(var5);
        }
        BiomeSettings.addDefaultOres(var5);
        BiomeSettings.addDefaultSoftDisks(var5);
        if (var4) {
            var5.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.TREES_FLOWER_FOREST);
            var5.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_FLOWER_FOREST);
            BiomeSettings.addDefaultGrass(var5);
        } else {
            if (var2) {
                if (var3) {
                    BiomeSettings.addTallBirchTrees(var5);
                } else {
                    BiomeSettings.addBirchTrees(var5);
                }
            } else {
                BiomeSettings.addOtherBirchTrees(var5);
            }
            BiomeSettings.addDefaultFlowers(var5);
            BiomeSettings.addForestGrass(var5);
        }
        BiomeSettings.addDefaultMushrooms(var5);
        BiomeSettings.addDefaultExtraVegetation(var5);
        BiomeSettingsMobs.a var7 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var7);
        BiomeSettings.commonSpawns(var7);
        if (var4) {
            var7.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 4, 2, 3));
        } else if (!var2) {
            var7.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.WOLF, 5, 4, 4));
        }
        float var8 = var2 ? 0.6f : 0.7f;
        return OverworldBiomes.biome(true, var8, var2 ? 0.6f : 0.8f, var7, var5, var6);
    }

    public static BiomeBase taiga(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var3);
        var3.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.WOLF, 8, 4, 4)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 4, 2, 3)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.FOX, 8, 2, 4));
        BiomeSettings.commonSpawns(var3);
        float var4 = var2 ? -0.5f : 0.25f;
        BiomeSettingsGeneration.a var5 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var5);
        BiomeSettings.addFerns(var5);
        BiomeSettings.addDefaultOres(var5);
        BiomeSettings.addDefaultSoftDisks(var5);
        BiomeSettings.addTaigaTrees(var5);
        BiomeSettings.addDefaultFlowers(var5);
        BiomeSettings.addTaigaGrass(var5);
        BiomeSettings.addDefaultExtraVegetation(var5);
        if (var2) {
            BiomeSettings.addRareBerryBushes(var5);
        } else {
            BiomeSettings.addCommonBerryBushes(var5);
        }
        return OverworldBiomes.biome(true, var4, var2 ? 0.4f : 0.8f, var2 ? 4020182 : 4159204, 329011, null, null, var3, var5, NORMAL_MUSIC);
    }

    public static BiomeBase darkForest(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var2);
        BiomeSettings.commonSpawns(var2);
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var3);
        var3.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.DARK_FOREST_VEGETATION);
        BiomeSettings.addForestFlowers(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addDefaultSoftDisks(var3);
        BiomeSettings.addDefaultFlowers(var3);
        BiomeSettings.addForestGrass(var3);
        BiomeSettings.addDefaultMushrooms(var3);
        BiomeSettings.addDefaultExtraVegetation(var3);
        Music var4 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_FOREST);
        return new BiomeBase.a().hasPrecipitation(true).temperature(0.7f).downfall(0.8f).specialEffects(new BiomeFog.a().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(0.7f)).grassColorModifier(BiomeFog.GrassColor.DARK_FOREST).ambientMoodSound(CaveSoundSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(var4).build()).mobSpawnSettings(var2.build()).generationSettings(var3.build()).build();
    }

    public static BiomeBase swamp(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var2);
        BiomeSettings.commonSpawns(var2);
        var2.addSpawn(EnumCreatureType.MONSTER, new BiomeSettingsMobs.c(EntityTypes.SLIME, 1, 1, 1));
        var2.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.FROG, 10, 2, 5));
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettings.addFossilDecoration(var3);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addSwampClayDisk(var3);
        BiomeSettings.addSwampVegetation(var3);
        BiomeSettings.addDefaultMushrooms(var3);
        BiomeSettings.addSwampExtraVegetation(var3);
        var3.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SWAMP);
        Music var4 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_SWAMP);
        return new BiomeBase.a().hasPrecipitation(true).temperature(0.8f).downfall(0.9f).specialEffects(new BiomeFog.a().waterColor(6388580).waterFogColor(2302743).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(0.8f)).foliageColorOverride(6975545).grassColorModifier(BiomeFog.GrassColor.SWAMP).ambientMoodSound(CaveSoundSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(var4).build()).mobSpawnSettings(var2.build()).generationSettings(var3.build()).build();
    }

    public static BiomeBase mangroveSwamp(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.commonSpawns(var2);
        var2.addSpawn(EnumCreatureType.MONSTER, new BiomeSettingsMobs.c(EntityTypes.SLIME, 1, 1, 1));
        var2.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.FROG, 10, 2, 5));
        var2.addSpawn(EnumCreatureType.WATER_AMBIENT, new BiomeSettingsMobs.c(EntityTypes.TROPICAL_FISH, 25, 8, 8));
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettings.addFossilDecoration(var3);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addMangroveSwampDisks(var3);
        BiomeSettings.addMangroveSwampVegetation(var3);
        var3.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SWAMP);
        Music var4 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_SWAMP);
        return new BiomeBase.a().hasPrecipitation(true).temperature(0.8f).downfall(0.9f).specialEffects(new BiomeFog.a().waterColor(3832426).waterFogColor(5077600).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(0.8f)).foliageColorOverride(9285927).grassColorModifier(BiomeFog.GrassColor.SWAMP).ambientMoodSound(CaveSoundSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(var4).build()).mobSpawnSettings(var2.build()).generationSettings(var3.build()).build();
    }

    public static BiomeBase river(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a().addSpawn(EnumCreatureType.WATER_CREATURE, new BiomeSettingsMobs.c(EntityTypes.SQUID, 2, 1, 4)).addSpawn(EnumCreatureType.WATER_AMBIENT, new BiomeSettingsMobs.c(EntityTypes.SALMON, 5, 1, 5));
        BiomeSettings.commonSpawns(var3);
        var3.addSpawn(EnumCreatureType.MONSTER, new BiomeSettingsMobs.c(EntityTypes.DROWNED, var2 ? 1 : 100, 1, 1));
        BiomeSettingsGeneration.a var4 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        BiomeSettings.addDefaultOres(var4);
        BiomeSettings.addDefaultSoftDisks(var4);
        BiomeSettings.addWaterTrees(var4);
        BiomeSettings.addDefaultFlowers(var4);
        BiomeSettings.addDefaultGrass(var4);
        BiomeSettings.addDefaultMushrooms(var4);
        BiomeSettings.addDefaultExtraVegetation(var4);
        if (!var2) {
            var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_RIVER);
        }
        float var5 = var2 ? 0.0f : 0.5f;
        return OverworldBiomes.biome(true, var5, 0.5f, var2 ? 3750089 : 4159204, 329011, null, null, var3, var4, NORMAL_MUSIC);
    }

    public static BiomeBase beach(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2, boolean var3) {
        boolean var5;
        BiomeSettingsMobs.a var4 = new BiomeSettingsMobs.a();
        boolean bl = var5 = !var3 && !var2;
        if (var5) {
            var4.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.TURTLE, 5, 2, 5));
        }
        BiomeSettings.commonSpawns(var4);
        BiomeSettingsGeneration.a var6 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var6);
        BiomeSettings.addDefaultOres(var6);
        BiomeSettings.addDefaultSoftDisks(var6);
        BiomeSettings.addDefaultFlowers(var6);
        BiomeSettings.addDefaultGrass(var6);
        BiomeSettings.addDefaultMushrooms(var6);
        BiomeSettings.addDefaultExtraVegetation(var6);
        float var7 = var2 ? 0.05f : (var3 ? 0.2f : 0.8f);
        return OverworldBiomes.biome(true, var7, var5 ? 0.4f : 0.3f, var2 ? 4020182 : 4159204, 329011, null, null, var4, var6, NORMAL_MUSIC);
    }

    public static BiomeBase theVoid(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a(var0, var1);
        var2.addFeature(WorldGenStage.Decoration.TOP_LAYER_MODIFICATION, MiscOverworldPlacements.VOID_START_PLATFORM);
        return OverworldBiomes.biome(false, 0.5f, 0.5f, new BiomeSettingsMobs.a(), var2, NORMAL_MUSIC);
    }

    public static BiomeBase meadowOrCherryGrove(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1, boolean var2) {
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettingsMobs.a var4 = new BiomeSettingsMobs.a();
        var4.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(var2 ? EntityTypes.PIG : EntityTypes.DONKEY, 1, 1, 2)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 2, 2, 6)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.SHEEP, 2, 2, 4));
        BiomeSettings.commonSpawns(var4);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeSettings.addPlainGrass(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addDefaultSoftDisks(var3);
        if (var2) {
            BiomeSettings.addCherryGroveVegetation(var3);
        } else {
            BiomeSettings.addMeadowVegetation(var3);
        }
        BiomeSettings.addExtraEmeralds(var3);
        BiomeSettings.addInfestedStone(var3);
        Music var5 = Musics.createGameMusic(var2 ? SoundEffects.MUSIC_BIOME_CHERRY_GROVE : SoundEffects.MUSIC_BIOME_MEADOW);
        if (var2) {
            return OverworldBiomes.biome(true, 0.5f, 0.8f, 6141935, 6141935, 11983713, 11983713, var4, var3, var5);
        }
        return OverworldBiomes.biome(true, 0.5f, 0.8f, 937679, 329011, null, null, var4, var3, var5);
    }

    public static BiomeBase frozenPeaks(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        var3.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.GOAT, 5, 1, 3));
        BiomeSettings.commonSpawns(var3);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeSettings.addFrozenSprings(var2);
        BiomeSettings.addDefaultOres(var2);
        BiomeSettings.addDefaultSoftDisks(var2);
        BiomeSettings.addExtraEmeralds(var2);
        BiomeSettings.addInfestedStone(var2);
        Music var4 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_FROZEN_PEAKS);
        return OverworldBiomes.biome(true, -0.7f, 0.9f, var3, var2, var4);
    }

    public static BiomeBase jaggedPeaks(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        var3.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.GOAT, 5, 1, 3));
        BiomeSettings.commonSpawns(var3);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeSettings.addFrozenSprings(var2);
        BiomeSettings.addDefaultOres(var2);
        BiomeSettings.addDefaultSoftDisks(var2);
        BiomeSettings.addExtraEmeralds(var2);
        BiomeSettings.addInfestedStone(var2);
        Music var4 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_JAGGED_PEAKS);
        return OverworldBiomes.biome(true, -0.7f, 0.9f, var3, var2, var4);
    }

    public static BiomeBase stonyPeaks(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettings.commonSpawns(var3);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeSettings.addDefaultOres(var2);
        BiomeSettings.addDefaultSoftDisks(var2);
        BiomeSettings.addExtraEmeralds(var2);
        BiomeSettings.addInfestedStone(var2);
        Music var4 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_STONY_PEAKS);
        return OverworldBiomes.biome(true, 1.0f, 0.3f, var3, var2, var4);
    }

    public static BiomeBase snowySlopes(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        var3.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 4, 2, 3)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.GOAT, 5, 1, 3));
        BiomeSettings.commonSpawns(var3);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeSettings.addFrozenSprings(var2);
        BiomeSettings.addDefaultOres(var2);
        BiomeSettings.addDefaultSoftDisks(var2);
        BiomeSettings.addDefaultExtraVegetation(var2);
        BiomeSettings.addExtraEmeralds(var2);
        BiomeSettings.addInfestedStone(var2);
        Music var4 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_SNOWY_SLOPES);
        return OverworldBiomes.biome(true, -0.3f, 0.9f, var3, var2, var4);
    }

    public static BiomeBase grove(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a(var0, var1);
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var3);
        var3.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.WOLF, 8, 4, 4)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 4, 2, 3)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.FOX, 8, 2, 4));
        BiomeSettings.commonSpawns(var3);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeSettings.addFrozenSprings(var2);
        BiomeSettings.addDefaultOres(var2);
        BiomeSettings.addDefaultSoftDisks(var2);
        BiomeSettings.addGroveTrees(var2);
        BiomeSettings.addDefaultExtraVegetation(var2);
        BiomeSettings.addExtraEmeralds(var2);
        BiomeSettings.addInfestedStone(var2);
        Music var4 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_GROVE);
        return OverworldBiomes.biome(true, -0.2f, 0.8f, var3, var2, var4);
    }

    public static BiomeBase lushCaves(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        var2.addSpawn(EnumCreatureType.AXOLOTLS, new BiomeSettingsMobs.c(EntityTypes.AXOLOTL, 10, 4, 6));
        var2.addSpawn(EnumCreatureType.WATER_AMBIENT, new BiomeSettingsMobs.c(EntityTypes.TROPICAL_FISH, 25, 8, 8));
        BiomeSettings.commonSpawns(var2);
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeSettings.addPlainGrass(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addLushCavesSpecialOres(var3);
        BiomeSettings.addDefaultSoftDisks(var3);
        BiomeSettings.addLushCavesVegetationFeatures(var3);
        Music var4 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_LUSH_CAVES);
        return OverworldBiomes.biome(true, 0.5f, 0.5f, var2, var3, var4);
    }

    public static BiomeBase dripstoneCaves(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettings.dripstoneCavesSpawns(var2);
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeSettings.addPlainGrass(var3);
        BiomeSettings.addDefaultOres(var3, true);
        BiomeSettings.addDefaultSoftDisks(var3);
        BiomeSettings.addPlainVegetation(var3);
        BiomeSettings.addDefaultMushrooms(var3);
        BiomeSettings.addDefaultExtraVegetation(var3);
        BiomeSettings.addDripstone(var3);
        Music var4 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_DRIPSTONE_CAVES);
        return OverworldBiomes.biome(true, 0.8f, 0.4f, var2, var3, var4);
    }

    public static BiomeBase deepDark(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1);
        var3.addCarver(WorldGenStage.Features.AIR, WorldGenCarvers.CAVE);
        var3.addCarver(WorldGenStage.Features.AIR, WorldGenCarvers.CAVE_EXTRA_UNDERGROUND);
        var3.addCarver(WorldGenStage.Features.AIR, WorldGenCarvers.CANYON);
        BiomeSettings.addDefaultCrystalFormations(var3);
        BiomeSettings.addDefaultMonsterRoom(var3);
        BiomeSettings.addDefaultUndergroundVariety(var3);
        BiomeSettings.addSurfaceFreezing(var3);
        BiomeSettings.addPlainGrass(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addDefaultSoftDisks(var3);
        BiomeSettings.addPlainVegetation(var3);
        BiomeSettings.addDefaultMushrooms(var3);
        BiomeSettings.addDefaultExtraVegetation(var3);
        BiomeSettings.addSculk(var3);
        Music var4 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_DEEP_DARK);
        return OverworldBiomes.biome(true, 0.8f, 0.4f, var2, var3, var4);
    }
}

