/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.dispenser.DispenseBehaviorBoat;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.DispenseBehaviorMaybe;
import net.minecraft.core.dispenser.DispenseBehaviorProjectile;
import net.minecraft.core.dispenser.DispenseBehaviorShears;
import net.minecraft.core.dispenser.DispenseBehaviorShulkerBox;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemBoneMeal;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockPumpkinCarved;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public interface IDispenseBehavior {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final IDispenseBehavior NOOP = (var0, var1) -> var1;

    public ItemStack dispense(SourceBlock var1, ItemStack var2);

    public static void bootStrap() {
        BlockDispenser.registerBehavior(Items.ARROW, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile getProjectile(World var0, IPosition var1, ItemStack var2) {
                EntityTippedArrow var3 = new EntityTippedArrow(var0, var1.x(), var1.y(), var1.z(), var2.copyWithCount(1));
                var3.pickup = EntityArrow.PickupStatus.ALLOWED;
                return var3;
            }
        });
        BlockDispenser.registerBehavior(Items.TIPPED_ARROW, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile getProjectile(World var0, IPosition var1, ItemStack var2) {
                EntityTippedArrow var3 = new EntityTippedArrow(var0, var1.x(), var1.y(), var1.z(), var2.copyWithCount(1));
                var3.setEffectsFromItem(var2);
                var3.pickup = EntityArrow.PickupStatus.ALLOWED;
                return var3;
            }
        });
        BlockDispenser.registerBehavior(Items.SPECTRAL_ARROW, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile getProjectile(World var0, IPosition var1, ItemStack var2) {
                EntitySpectralArrow var3 = new EntitySpectralArrow(var0, var1.x(), var1.y(), var1.z(), var2.copyWithCount(1));
                var3.pickup = EntityArrow.PickupStatus.ALLOWED;
                return var3;
            }
        });
        BlockDispenser.registerBehavior(Items.EGG, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile getProjectile(World var0, IPosition var12, ItemStack var2) {
                return SystemUtils.make(new EntityEgg(var0, var12.x(), var12.y(), var12.z()), var1 -> var1.setItem(var2));
            }
        });
        BlockDispenser.registerBehavior(Items.SNOWBALL, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile getProjectile(World var0, IPosition var12, ItemStack var2) {
                return SystemUtils.make(new EntitySnowball(var0, var12.x(), var12.y(), var12.z()), var1 -> var1.setItem(var2));
            }
        });
        BlockDispenser.registerBehavior(Items.EXPERIENCE_BOTTLE, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile getProjectile(World var0, IPosition var12, ItemStack var2) {
                return SystemUtils.make(new EntityThrownExpBottle(var0, var12.x(), var12.y(), var12.z()), var1 -> var1.setItem(var2));
            }

            @Override
            protected float getUncertainty() {
                return super.getUncertainty() * 0.5f;
            }

            @Override
            protected float getPower() {
                return super.getPower() * 1.25f;
            }
        });
        BlockDispenser.registerBehavior(Items.SPLASH_POTION, new IDispenseBehavior(){

            @Override
            public ItemStack dispense(SourceBlock var0, ItemStack var1) {
                return new DispenseBehaviorProjectile(){

                    @Override
                    protected IProjectile getProjectile(World var0, IPosition var12, ItemStack var2) {
                        return SystemUtils.make(new EntityPotion(var0, var12.x(), var12.y(), var12.z()), var1 -> var1.setItem(var2));
                    }

                    @Override
                    protected float getUncertainty() {
                        return super.getUncertainty() * 0.5f;
                    }

                    @Override
                    protected float getPower() {
                        return super.getPower() * 1.25f;
                    }
                }.dispense(var0, var1);
            }
        });
        BlockDispenser.registerBehavior(Items.LINGERING_POTION, new IDispenseBehavior(){

            @Override
            public ItemStack dispense(SourceBlock var0, ItemStack var1) {
                return new DispenseBehaviorProjectile(){

                    @Override
                    protected IProjectile getProjectile(World var0, IPosition var12, ItemStack var2) {
                        return SystemUtils.make(new EntityPotion(var0, var12.x(), var12.y(), var12.z()), var1 -> var1.setItem(var2));
                    }

                    @Override
                    protected float getUncertainty() {
                        return super.getUncertainty() * 0.5f;
                    }

                    @Override
                    protected float getPower() {
                        return super.getPower() * 1.25f;
                    }
                }.dispense(var0, var1);
            }
        });
        DispenseBehaviorItem var0 = new DispenseBehaviorItem(){

            @Override
            public ItemStack execute(SourceBlock var0, ItemStack var1) {
                EnumDirection var2 = var0.state().getValue(BlockDispenser.FACING);
                EntityTypes<?> var3 = ((ItemMonsterEgg)var1.getItem()).getType(var1.getTag());
                try {
                    var3.spawn(var0.level(), var1, null, var0.pos().relative(var2), EnumMobSpawn.DISPENSER, var2 != EnumDirection.UP, false);
                }
                catch (Exception var4) {
                    LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)var0.pos(), (Object)var4);
                    return ItemStack.EMPTY;
                }
                var1.shrink(1);
                var0.level().gameEvent(null, GameEvent.ENTITY_PLACE, var0.pos());
                return var1;
            }
        };
        for (ItemMonsterEgg itemMonsterEgg : ItemMonsterEgg.eggs()) {
            BlockDispenser.registerBehavior(itemMonsterEgg, var0);
        }
        BlockDispenser.registerBehavior(Items.ARMOR_STAND, new DispenseBehaviorItem(){

            @Override
            public ItemStack execute(SourceBlock var0, ItemStack var12) {
                EnumDirection var2 = var0.state().getValue(BlockDispenser.FACING);
                BlockPosition var3 = var0.pos().relative(var2);
                WorldServer var4 = var0.level();
                Consumer<EntityArmorStand> var5 = EntityTypes.appendDefaultStackConfig(var1 -> var1.setYRot(var2.toYRot()), var4, var12, null);
                EntityArmorStand var6 = EntityTypes.ARMOR_STAND.spawn(var4, var12.getTag(), var5, var3, EnumMobSpawn.DISPENSER, false, false);
                if (var6 != null) {
                    var12.shrink(1);
                }
                return var12;
            }
        });
        BlockDispenser.registerBehavior(Items.SADDLE, new DispenseBehaviorMaybe(){

            @Override
            public ItemStack execute(SourceBlock var02, ItemStack var1) {
                BlockPosition var2 = var02.pos().relative(var02.state().getValue(BlockDispenser.FACING));
                List<EntityLiving> var3 = var02.level().getEntitiesOfClass(EntityLiving.class, new AxisAlignedBB(var2), var0 -> {
                    if (var0 instanceof ISaddleable) {
                        ISaddleable var1 = (ISaddleable)((Object)var0);
                        return !var1.isSaddled() && var1.isSaddleable();
                    }
                    return false;
                });
                if (!var3.isEmpty()) {
                    ((ISaddleable)((Object)var3.get(0))).equipSaddle(SoundCategory.BLOCKS);
                    var1.shrink(1);
                    this.setSuccess(true);
                    return var1;
                }
                return super.execute(var02, var1);
            }
        });
        DispenseBehaviorMaybe var1 = new DispenseBehaviorMaybe(){

            @Override
            protected ItemStack execute(SourceBlock var02, ItemStack var1) {
                BlockPosition var2 = var02.pos().relative(var02.state().getValue(BlockDispenser.FACING));
                List<EntityHorseAbstract> var3 = var02.level().getEntitiesOfClass(EntityHorseAbstract.class, new AxisAlignedBB(var2), var0 -> var0.isAlive() && var0.canWearArmor());
                for (EntityHorseAbstract var5 : var3) {
                    if (!var5.isArmor(var1) || var5.isWearingArmor() || !var5.isTamed()) continue;
                    var5.getSlot(401).set(var1.split(1));
                    this.setSuccess(true);
                    return var1;
                }
                return super.execute(var02, var1);
            }
        };
        BlockDispenser.registerBehavior(Items.LEATHER_HORSE_ARMOR, var1);
        BlockDispenser.registerBehavior(Items.IRON_HORSE_ARMOR, var1);
        BlockDispenser.registerBehavior(Items.GOLDEN_HORSE_ARMOR, var1);
        BlockDispenser.registerBehavior(Items.DIAMOND_HORSE_ARMOR, var1);
        BlockDispenser.registerBehavior(Items.WHITE_CARPET, var1);
        BlockDispenser.registerBehavior(Items.ORANGE_CARPET, var1);
        BlockDispenser.registerBehavior(Items.CYAN_CARPET, var1);
        BlockDispenser.registerBehavior(Items.BLUE_CARPET, var1);
        BlockDispenser.registerBehavior(Items.BROWN_CARPET, var1);
        BlockDispenser.registerBehavior(Items.BLACK_CARPET, var1);
        BlockDispenser.registerBehavior(Items.GRAY_CARPET, var1);
        BlockDispenser.registerBehavior(Items.GREEN_CARPET, var1);
        BlockDispenser.registerBehavior(Items.LIGHT_BLUE_CARPET, var1);
        BlockDispenser.registerBehavior(Items.LIGHT_GRAY_CARPET, var1);
        BlockDispenser.registerBehavior(Items.LIME_CARPET, var1);
        BlockDispenser.registerBehavior(Items.MAGENTA_CARPET, var1);
        BlockDispenser.registerBehavior(Items.PINK_CARPET, var1);
        BlockDispenser.registerBehavior(Items.PURPLE_CARPET, var1);
        BlockDispenser.registerBehavior(Items.RED_CARPET, var1);
        BlockDispenser.registerBehavior(Items.YELLOW_CARPET, var1);
        BlockDispenser.registerBehavior(Items.CHEST, new DispenseBehaviorMaybe(){

            @Override
            public ItemStack execute(SourceBlock var02, ItemStack var1) {
                BlockPosition var2 = var02.pos().relative(var02.state().getValue(BlockDispenser.FACING));
                List<EntityHorseChestedAbstract> var3 = var02.level().getEntitiesOfClass(EntityHorseChestedAbstract.class, new AxisAlignedBB(var2), var0 -> var0.isAlive() && !var0.hasChest());
                for (EntityHorseChestedAbstract var5 : var3) {
                    if (!var5.isTamed() || !var5.getSlot(499).set(var1)) continue;
                    var1.shrink(1);
                    this.setSuccess(true);
                    return var1;
                }
                return super.execute(var02, var1);
            }
        });
        BlockDispenser.registerBehavior(Items.FIREWORK_ROCKET, new DispenseBehaviorItem(){

            @Override
            public ItemStack execute(SourceBlock var0, ItemStack var1) {
                EnumDirection var2 = var0.state().getValue(BlockDispenser.FACING);
                Vec3D var3 = IDispenseBehavior.getEntityPokingOutOfBlockPos(var0, EntityTypes.FIREWORK_ROCKET, var2);
                EntityFireworks var4 = new EntityFireworks((World)var0.level(), var1, var3.x(), var3.y(), var3.z(), true);
                var4.shoot(var2.getStepX(), var2.getStepY(), var2.getStepZ(), 0.5f, 1.0f);
                var0.level().addFreshEntity(var4);
                var1.shrink(1);
                return var1;
            }

            @Override
            protected void playSound(SourceBlock var0) {
                var0.level().levelEvent(1004, var0.pos(), 0);
            }
        });
        BlockDispenser.registerBehavior(Items.FIRE_CHARGE, new DispenseBehaviorItem(){

            @Override
            public ItemStack execute(SourceBlock var0, ItemStack var12) {
                EnumDirection var2 = var0.state().getValue(BlockDispenser.FACING);
                IPosition var3 = BlockDispenser.getDispensePosition(var0);
                double var4 = var3.x() + (double)((float)var2.getStepX() * 0.3f);
                double var6 = var3.y() + (double)((float)var2.getStepY() * 0.3f);
                double var8 = var3.z() + (double)((float)var2.getStepZ() * 0.3f);
                WorldServer var10 = var0.level();
                RandomSource var11 = var10.random;
                double var122 = var11.triangle(var2.getStepX(), 0.11485000000000001);
                double var14 = var11.triangle(var2.getStepY(), 0.11485000000000001);
                double var16 = var11.triangle(var2.getStepZ(), 0.11485000000000001);
                EntitySmallFireball var18 = new EntitySmallFireball(var10, var4, var6, var8, var122, var14, var16);
                var10.addFreshEntity(SystemUtils.make(var18, var1 -> var1.setItem(var12)));
                var12.shrink(1);
                return var12;
            }

            @Override
            protected void playSound(SourceBlock var0) {
                var0.level().levelEvent(1018, var0.pos(), 0);
            }
        });
        BlockDispenser.registerBehavior(Items.OAK_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.OAK));
        BlockDispenser.registerBehavior(Items.SPRUCE_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.SPRUCE));
        BlockDispenser.registerBehavior(Items.BIRCH_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.BIRCH));
        BlockDispenser.registerBehavior(Items.JUNGLE_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.JUNGLE));
        BlockDispenser.registerBehavior(Items.DARK_OAK_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.DARK_OAK));
        BlockDispenser.registerBehavior(Items.ACACIA_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.ACACIA));
        BlockDispenser.registerBehavior(Items.CHERRY_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.CHERRY));
        BlockDispenser.registerBehavior(Items.MANGROVE_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.MANGROVE));
        BlockDispenser.registerBehavior(Items.BAMBOO_RAFT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.BAMBOO));
        BlockDispenser.registerBehavior(Items.OAK_CHEST_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.OAK, true));
        BlockDispenser.registerBehavior(Items.SPRUCE_CHEST_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.SPRUCE, true));
        BlockDispenser.registerBehavior(Items.BIRCH_CHEST_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.BIRCH, true));
        BlockDispenser.registerBehavior(Items.JUNGLE_CHEST_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.JUNGLE, true));
        BlockDispenser.registerBehavior(Items.DARK_OAK_CHEST_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.DARK_OAK, true));
        BlockDispenser.registerBehavior(Items.ACACIA_CHEST_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.ACACIA, true));
        BlockDispenser.registerBehavior(Items.CHERRY_CHEST_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.CHERRY, true));
        BlockDispenser.registerBehavior(Items.MANGROVE_CHEST_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.MANGROVE, true));
        BlockDispenser.registerBehavior(Items.BAMBOO_CHEST_RAFT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.BAMBOO, true));
        DispenseBehaviorItem dispenseBehaviorItem = new DispenseBehaviorItem(){
            private final DispenseBehaviorItem defaultDispenseItemBehavior = new DispenseBehaviorItem();

            @Override
            public ItemStack execute(SourceBlock var0, ItemStack var1) {
                DispensibleContainerItem var2 = (DispensibleContainerItem)((Object)var1.getItem());
                BlockPosition var3 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING));
                WorldServer var4 = var0.level();
                if (var2.emptyContents(null, var4, var3, null)) {
                    var2.checkExtraContent(null, var4, var1, var3);
                    return new ItemStack(Items.BUCKET);
                }
                return this.defaultDispenseItemBehavior.dispense(var0, var1);
            }
        };
        BlockDispenser.registerBehavior(Items.LAVA_BUCKET, dispenseBehaviorItem);
        BlockDispenser.registerBehavior(Items.WATER_BUCKET, dispenseBehaviorItem);
        BlockDispenser.registerBehavior(Items.POWDER_SNOW_BUCKET, dispenseBehaviorItem);
        BlockDispenser.registerBehavior(Items.SALMON_BUCKET, dispenseBehaviorItem);
        BlockDispenser.registerBehavior(Items.COD_BUCKET, dispenseBehaviorItem);
        BlockDispenser.registerBehavior(Items.PUFFERFISH_BUCKET, dispenseBehaviorItem);
        BlockDispenser.registerBehavior(Items.TROPICAL_FISH_BUCKET, dispenseBehaviorItem);
        BlockDispenser.registerBehavior(Items.AXOLOTL_BUCKET, dispenseBehaviorItem);
        BlockDispenser.registerBehavior(Items.TADPOLE_BUCKET, dispenseBehaviorItem);
        BlockDispenser.registerBehavior(Items.BUCKET, new DispenseBehaviorItem(){
            private final DispenseBehaviorItem defaultDispenseItemBehavior = new DispenseBehaviorItem();

            @Override
            public ItemStack execute(SourceBlock var0, ItemStack var1) {
                ItemStack var8;
                BlockPosition var3;
                WorldServer var2 = var0.level();
                IBlockData var4 = var2.getBlockState(var3 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING)));
                Block var5 = var4.getBlock();
                if (var5 instanceof IFluidSource) {
                    IFluidSource var7 = (IFluidSource)((Object)var5);
                    var8 = var7.pickupBlock(null, var2, var3, var4);
                    if (var8.isEmpty()) {
                        return super.execute(var0, var1);
                    }
                } else {
                    return super.execute(var0, var1);
                }
                var2.gameEvent(null, GameEvent.FLUID_PICKUP, var3);
                Item var6 = var8.getItem();
                var1.shrink(1);
                if (var1.isEmpty()) {
                    return new ItemStack(var6);
                }
                if (var0.blockEntity().addItem(new ItemStack(var6)) < 0) {
                    this.defaultDispenseItemBehavior.dispense(var0, new ItemStack(var6));
                }
                return var1;
            }
        });
        BlockDispenser.registerBehavior(Items.FLINT_AND_STEEL, new DispenseBehaviorMaybe(){

            @Override
            protected ItemStack execute(SourceBlock var0, ItemStack var1) {
                WorldServer var2 = var0.level();
                this.setSuccess(true);
                EnumDirection var3 = var0.state().getValue(BlockDispenser.FACING);
                BlockPosition var4 = var0.pos().relative(var3);
                IBlockData var5 = var2.getBlockState(var4);
                if (BlockFireAbstract.canBePlacedAt(var2, var4, var3)) {
                    var2.setBlockAndUpdate(var4, BlockFireAbstract.getState(var2, var4));
                    var2.gameEvent(null, GameEvent.BLOCK_PLACE, var4);
                } else if (BlockCampfire.canLight(var5) || CandleBlock.canLight(var5) || CandleCakeBlock.canLight(var5)) {
                    var2.setBlockAndUpdate(var4, (IBlockData)var5.setValue(BlockProperties.LIT, true));
                    var2.gameEvent(null, GameEvent.BLOCK_CHANGE, var4);
                } else if (var5.getBlock() instanceof BlockTNT) {
                    BlockTNT.explode(var2, var4);
                    var2.removeBlock(var4, false);
                } else {
                    this.setSuccess(false);
                }
                if (this.isSuccess() && var1.hurt(1, var2.random, null)) {
                    var1.setCount(0);
                }
                return var1;
            }
        });
        BlockDispenser.registerBehavior(Items.BONE_MEAL, new DispenseBehaviorMaybe(){

            @Override
            protected ItemStack execute(SourceBlock var0, ItemStack var1) {
                this.setSuccess(true);
                WorldServer var2 = var0.level();
                BlockPosition var3 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING));
                if (ItemBoneMeal.growCrop(var1, var2, var3) || ItemBoneMeal.growWaterPlant(var1, var2, var3, null)) {
                    if (!var2.isClientSide) {
                        var2.levelEvent(1505, var3, 0);
                    }
                } else {
                    this.setSuccess(false);
                }
                return var1;
            }
        });
        BlockDispenser.registerBehavior(Blocks.TNT, new DispenseBehaviorItem(){

            @Override
            protected ItemStack execute(SourceBlock var0, ItemStack var1) {
                WorldServer var2 = var0.level();
                BlockPosition var3 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING));
                EntityTNTPrimed var4 = new EntityTNTPrimed(var2, (double)var3.getX() + 0.5, var3.getY(), (double)var3.getZ() + 0.5, null);
                var2.addFreshEntity(var4);
                var2.playSound(null, var4.getX(), var4.getY(), var4.getZ(), SoundEffects.TNT_PRIMED, SoundCategory.BLOCKS, 1.0f, 1.0f);
                var2.gameEvent(null, GameEvent.ENTITY_PLACE, var3);
                var1.shrink(1);
                return var1;
            }
        });
        DispenseBehaviorMaybe var3 = new DispenseBehaviorMaybe(){

            @Override
            protected ItemStack execute(SourceBlock var0, ItemStack var1) {
                this.setSuccess(ItemArmor.dispenseArmor(var0, var1));
                return var1;
            }
        };
        BlockDispenser.registerBehavior(Items.CREEPER_HEAD, var3);
        BlockDispenser.registerBehavior(Items.ZOMBIE_HEAD, var3);
        BlockDispenser.registerBehavior(Items.DRAGON_HEAD, var3);
        BlockDispenser.registerBehavior(Items.SKELETON_SKULL, var3);
        BlockDispenser.registerBehavior(Items.PIGLIN_HEAD, var3);
        BlockDispenser.registerBehavior(Items.PLAYER_HEAD, var3);
        BlockDispenser.registerBehavior(Items.WITHER_SKELETON_SKULL, new DispenseBehaviorMaybe(){

            @Override
            protected ItemStack execute(SourceBlock var0, ItemStack var1) {
                WorldServer var2 = var0.level();
                EnumDirection var3 = var0.state().getValue(BlockDispenser.FACING);
                BlockPosition var4 = var0.pos().relative(var3);
                if (var2.isEmptyBlock(var4) && BlockWitherSkull.canSpawnMob(var2, var4, var1)) {
                    var2.setBlock(var4, (IBlockData)Blocks.WITHER_SKELETON_SKULL.defaultBlockState().setValue(BlockSkull.ROTATION, RotationSegment.convertToSegment(var3)), 3);
                    var2.gameEvent(null, GameEvent.BLOCK_PLACE, var4);
                    TileEntity var5 = var2.getBlockEntity(var4);
                    if (var5 instanceof TileEntitySkull) {
                        BlockWitherSkull.checkSpawn(var2, var4, (TileEntitySkull)var5);
                    }
                    var1.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(ItemArmor.dispenseArmor(var0, var1));
                }
                return var1;
            }
        });
        BlockDispenser.registerBehavior(Blocks.CARVED_PUMPKIN, new DispenseBehaviorMaybe(){

            @Override
            protected ItemStack execute(SourceBlock var0, ItemStack var1) {
                WorldServer var2 = var0.level();
                BlockPosition var3 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING));
                BlockPumpkinCarved var4 = (BlockPumpkinCarved)Blocks.CARVED_PUMPKIN;
                if (var2.isEmptyBlock(var3) && var4.canSpawnGolem(var2, var3)) {
                    if (!var2.isClientSide) {
                        var2.setBlock(var3, var4.defaultBlockState(), 3);
                        var2.gameEvent(null, GameEvent.BLOCK_PLACE, var3);
                    }
                    var1.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(ItemArmor.dispenseArmor(var0, var1));
                }
                return var1;
            }
        });
        BlockDispenser.registerBehavior(Blocks.SHULKER_BOX.asItem(), new DispenseBehaviorShulkerBox());
        for (EnumColor var7 : EnumColor.values()) {
            BlockDispenser.registerBehavior(BlockShulkerBox.getBlockByColor(var7).asItem(), new DispenseBehaviorShulkerBox());
        }
        BlockDispenser.registerBehavior(Items.GLASS_BOTTLE.asItem(), new DispenseBehaviorMaybe(){
            private final DispenseBehaviorItem defaultDispenseItemBehavior = new DispenseBehaviorItem();

            private ItemStack takeLiquid(SourceBlock var0, ItemStack var1, ItemStack var2) {
                var1.shrink(1);
                if (var1.isEmpty()) {
                    var0.level().gameEvent(null, GameEvent.FLUID_PICKUP, var0.pos());
                    return var2.copy();
                }
                if (var0.blockEntity().addItem(var2.copy()) < 0) {
                    this.defaultDispenseItemBehavior.dispense(var0, var2.copy());
                }
                return var1;
            }

            @Override
            public ItemStack execute(SourceBlock var02, ItemStack var1) {
                this.setSuccess(false);
                WorldServer var2 = var02.level();
                BlockPosition var3 = var02.pos().relative(var02.state().getValue(BlockDispenser.FACING));
                IBlockData var4 = var2.getBlockState(var3);
                if (var4.is(TagsBlock.BEEHIVES, var0 -> var0.hasProperty(BlockBeehive.HONEY_LEVEL) && var0.getBlock() instanceof BlockBeehive) && var4.getValue(BlockBeehive.HONEY_LEVEL) >= 5) {
                    ((BlockBeehive)var4.getBlock()).releaseBeesAndResetHoneyLevel(var2, var4, var3, null, TileEntityBeehive.ReleaseStatus.BEE_RELEASED);
                    this.setSuccess(true);
                    return this.takeLiquid(var02, var1, new ItemStack(Items.HONEY_BOTTLE));
                }
                if (var2.getFluidState(var3).is(TagsFluid.WATER)) {
                    this.setSuccess(true);
                    return this.takeLiquid(var02, var1, PotionUtil.setPotion(new ItemStack(Items.POTION), Potions.WATER));
                }
                return super.execute(var02, var1);
            }
        });
        BlockDispenser.registerBehavior(Items.GLOWSTONE, new DispenseBehaviorMaybe(){

            @Override
            public ItemStack execute(SourceBlock var0, ItemStack var1) {
                EnumDirection var2 = var0.state().getValue(BlockDispenser.FACING);
                BlockPosition var3 = var0.pos().relative(var2);
                WorldServer var4 = var0.level();
                IBlockData var5 = var4.getBlockState(var3);
                this.setSuccess(true);
                if (var5.is(Blocks.RESPAWN_ANCHOR)) {
                    if (var5.getValue(BlockRespawnAnchor.CHARGE) != 4) {
                        BlockRespawnAnchor.charge(null, var4, var3, var5);
                        var1.shrink(1);
                    } else {
                        this.setSuccess(false);
                    }
                    return var1;
                }
                return super.execute(var0, var1);
            }
        });
        BlockDispenser.registerBehavior(Items.SHEARS.asItem(), new DispenseBehaviorShears());
        BlockDispenser.registerBehavior(Items.HONEYCOMB, new DispenseBehaviorMaybe(){

            @Override
            public ItemStack execute(SourceBlock var0, ItemStack var1) {
                BlockPosition var2 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING));
                WorldServer var3 = var0.level();
                IBlockData var4 = var3.getBlockState(var2);
                Optional<IBlockData> var5 = HoneycombItem.getWaxed(var4);
                if (var5.isPresent()) {
                    var3.setBlockAndUpdate(var2, var5.get());
                    var3.levelEvent(3003, var2, 0);
                    var1.shrink(1);
                    this.setSuccess(true);
                    return var1;
                }
                return super.execute(var0, var1);
            }
        });
        BlockDispenser.registerBehavior(Items.POTION, new DispenseBehaviorItem(){
            private final DispenseBehaviorItem defaultDispenseItemBehavior = new DispenseBehaviorItem();

            @Override
            public ItemStack execute(SourceBlock var0, ItemStack var1) {
                if (PotionUtil.getPotion(var1) != Potions.WATER) {
                    return this.defaultDispenseItemBehavior.dispense(var0, var1);
                }
                WorldServer var2 = var0.level();
                BlockPosition var3 = var0.pos();
                BlockPosition var4 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING));
                if (var2.getBlockState(var4).is(TagsBlock.CONVERTABLE_TO_MUD)) {
                    if (!var2.isClientSide) {
                        for (int var5 = 0; var5 < 5; ++var5) {
                            var2.sendParticles(Particles.SPLASH, (double)var3.getX() + var2.random.nextDouble(), var3.getY() + 1, (double)var3.getZ() + var2.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                        }
                    }
                    var2.playSound(null, var3, SoundEffects.BOTTLE_EMPTY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    var2.gameEvent(null, GameEvent.FLUID_PLACE, var3);
                    var2.setBlockAndUpdate(var4, Blocks.MUD.defaultBlockState());
                    return new ItemStack(Items.GLASS_BOTTLE);
                }
                return this.defaultDispenseItemBehavior.dispense(var0, var1);
            }
        });
    }

    public static Vec3D getEntityPokingOutOfBlockPos(SourceBlock var0, EntityTypes<?> var1, EnumDirection var2) {
        return var0.center().add((double)var2.getStepX() * (0.5000099999997474 - (double)var1.getWidth() / 2.0), (double)var2.getStepY() * (0.5000099999997474 - (double)var1.getHeight() / 2.0) - (double)var1.getHeight() / 2.0, (double)var2.getStepZ() * (0.5000099999997474 - (double)var1.getWidth() / 2.0));
    }
}

