/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.dispenser.DispenseBehaviorMaybe;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;

public class DispenseBehaviorShears
extends DispenseBehaviorMaybe {
    @Override
    protected ItemStack execute(SourceBlock var0, ItemStack var1) {
        WorldServer var2 = var0.level();
        if (!var2.isClientSide()) {
            BlockPosition var3 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING));
            this.setSuccess(DispenseBehaviorShears.tryShearBeehive(var2, var3) || DispenseBehaviorShears.tryShearLivingEntity(var2, var3));
            if (this.isSuccess() && var1.hurt(1, var2.getRandom(), null)) {
                var1.setCount(0);
            }
        }
        return var1;
    }

    private static boolean tryShearBeehive(WorldServer var02, BlockPosition var1) {
        int var3;
        IBlockData var2 = var02.getBlockState(var1);
        if (var2.is(TagsBlock.BEEHIVES, var0 -> var0.hasProperty(BlockBeehive.HONEY_LEVEL) && var0.getBlock() instanceof BlockBeehive) && (var3 = var2.getValue(BlockBeehive.HONEY_LEVEL).intValue()) >= 5) {
            var02.playSound(null, var1, SoundEffects.BEEHIVE_SHEAR, SoundCategory.BLOCKS, 1.0f, 1.0f);
            BlockBeehive.dropHoneycomb(var02, var1);
            ((BlockBeehive)var2.getBlock()).releaseBeesAndResetHoneyLevel(var02, var2, var1, null, TileEntityBeehive.ReleaseStatus.BEE_RELEASED);
            var02.gameEvent(null, GameEvent.SHEAR, var1);
            return true;
        }
        return false;
    }

    private static boolean tryShearLivingEntity(WorldServer var0, BlockPosition var1) {
        List<Entity> var2 = var0.getEntitiesOfClass(EntityLiving.class, new AxisAlignedBB(var1), IEntitySelector.NO_SPECTATORS);
        for (EntityLiving entityLiving : var2) {
            IShearable var5;
            if (!(entityLiving instanceof IShearable) || !(var5 = (IShearable)((Object)entityLiving)).readyForShearing()) continue;
            var5.shear(SoundCategory.BLOCKS);
            var0.gameEvent(null, GameEvent.SHEAR, var1);
            return true;
        }
        return false;
    }
}

