/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;

public class DispenseBehaviorItem
implements IDispenseBehavior {
    @Override
    public final ItemStack dispense(SourceBlock var0, ItemStack var1) {
        ItemStack var2 = this.execute(var0, var1);
        this.playSound(var0);
        this.playAnimation(var0, var0.state().getValue(BlockDispenser.FACING));
        return var2;
    }

    protected ItemStack execute(SourceBlock var0, ItemStack var1) {
        EnumDirection var2 = var0.state().getValue(BlockDispenser.FACING);
        IPosition var3 = BlockDispenser.getDispensePosition(var0);
        ItemStack var4 = var1.split(1);
        DispenseBehaviorItem.spawnItem(var0.level(), var4, 6, var2, var3);
        return var1;
    }

    public static void spawnItem(World var0, ItemStack var1, int var2, EnumDirection var3, IPosition var4) {
        double var5 = var4.x();
        double var7 = var4.y();
        double var9 = var4.z();
        var7 = var3.getAxis() == EnumDirection.EnumAxis.Y ? (var7 -= 0.125) : (var7 -= 0.15625);
        EntityItem var11 = new EntityItem(var0, var5, var7, var9, var1);
        double var12 = var0.random.nextDouble() * 0.1 + 0.2;
        var11.setDeltaMovement(var0.random.triangle((double)var3.getStepX() * var12, 0.0172275 * (double)var2), var0.random.triangle(0.2, 0.0172275 * (double)var2), var0.random.triangle((double)var3.getStepZ() * var12, 0.0172275 * (double)var2));
        var0.addFreshEntity(var11);
    }

    protected void playSound(SourceBlock var0) {
        var0.level().levelEvent(1000, var0.pos(), 0);
    }

    protected void playAnimation(SourceBlock var0, EnumDirection var1) {
        var0.level().levelEvent(2000, var0.pos(), var1.get3DDataValue());
    }
}

