/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.Lifecycle;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Cloner;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.apache.commons.lang3.mutable.MutableObject;

public class RegistrySetBuilder {
    private final List<i<?>> entries = new ArrayList();

    static <T> HolderGetter<T> wrapContextLookup(final HolderLookup.c<T> var0) {
        return new c<T>(var0){

            @Override
            public Optional<Holder.c<T>> get(ResourceKey<T> var02) {
                return var0.get(var02);
            }
        };
    }

    static <T> HolderLookup.c<T> lookupFromMap(final ResourceKey<? extends IRegistry<? extends T>> var0, final Lifecycle var1, final Map<ResourceKey<T>, Holder.c<T>> var2) {
        return new HolderLookup.c<T>(){

            @Override
            public ResourceKey<? extends IRegistry<? extends T>> key() {
                return var0;
            }

            @Override
            public Lifecycle registryLifecycle() {
                return var1;
            }

            @Override
            public Optional<Holder.c<T>> get(ResourceKey<T> var02) {
                return Optional.ofNullable((Holder.c)var2.get(var02));
            }

            @Override
            public Stream<Holder.c<T>> listElements() {
                return var2.values().stream();
            }

            @Override
            public Optional<HolderSet.Named<T>> get(TagKey<T> var02) {
                return Optional.empty();
            }

            @Override
            public Stream<HolderSet.Named<T>> listTags() {
                return Stream.empty();
            }
        };
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends IRegistry<T>> var0, Lifecycle var1, g<T> var2) {
        this.entries.add(new i<T>(var0, var1, var2));
        return this;
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends IRegistry<T>> var0, g<T> var1) {
        return this.add(var0, Lifecycle.stable(), var1);
    }

    private a createState(IRegistryCustom var0) {
        a var12 = a.create(var0, this.entries.stream().map(i::key));
        this.entries.forEach(var1 -> var1.apply(var12));
        return var12;
    }

    private static HolderLookup.b buildProviderWithContext(IRegistryCustom var02, Stream<HolderLookup.c<?>> var1) {
        Stream<HolderLookup.c> var2 = var02.registries().map(var0 -> var0.value().asLookup());
        return HolderLookup.b.create(Stream.concat(var2, var1));
    }

    public HolderLookup.b build(IRegistryCustom var0) {
        a var12 = this.createState(var0);
        Stream<HolderLookup.c<?>> var2 = this.entries.stream().map(var1 -> var1.collectRegisteredValues(var12).buildAsLookup(var0.owner));
        HolderLookup.b var3 = RegistrySetBuilder.buildProviderWithContext(var0, var2);
        var12.reportNotCollectedHolders();
        var12.reportUnclaimedRegisteredValues();
        var12.throwOnError();
        return var3;
    }

    private HolderLookup.b createLazyFullPatchedRegistries(IRegistryCustom var0, HolderLookup.b var1, Cloner.a var2, Map<ResourceKey<? extends IRegistry<?>>, h<?>> var3, HolderLookup.b var4) {
        b var52 = new b();
        MutableObject var6 = new MutableObject();
        List var7 = var3.keySet().stream().map(var5 -> this.createLazyFullPatchedRegistries(var52, var2, (ResourceKey)var5, var4, var1, (MutableObject<HolderLookup.b>)var6)).peek(var52::add).collect(Collectors.toUnmodifiableList());
        HolderLookup.b var8 = RegistrySetBuilder.buildProviderWithContext(var0, var7.stream());
        var6.setValue((Object)var8);
        return var8;
    }

    private <T> HolderLookup.c<T> createLazyFullPatchedRegistries(HolderOwner<T> var0, Cloner.a var1, ResourceKey<? extends IRegistry<? extends T>> var2, HolderLookup.b var3, HolderLookup.b var4, MutableObject<HolderLookup.b> var52) {
        Cloner var6 = var1.cloner(var2);
        if (var6 == null) {
            throw new NullPointerException("No cloner for " + var2.location());
        }
        HashMap var7 = new HashMap();
        HolderLookup.c var8 = var3.lookupOrThrow(var2);
        var8.listElements().forEach(var5 -> {
            ResourceKey var6 = var5.key();
            d var7 = new d(var0, var6);
            var7.supplier = () -> var6.clone(var5.value(), var3, (HolderLookup.b)var52.getValue());
            var7.put(var6, var7);
        });
        HolderLookup.c var9 = var4.lookupOrThrow(var2);
        var9.listElements().forEach(var5 -> {
            ResourceKey var62 = var5.key();
            var7.computeIfAbsent(var62, var6 -> {
                d var7 = new d(var0, var62);
                var7.supplier = () -> var6.clone(var5.value(), var4, (HolderLookup.b)var52.getValue());
                return var7;
            });
        });
        Lifecycle var10 = var8.registryLifecycle().add(var9.registryLifecycle());
        return RegistrySetBuilder.lookupFromMap(var2, var10, var7);
    }

    public e buildPatch(IRegistryCustom var0, HolderLookup.b var12, Cloner.a var2) {
        a var3 = this.createState(var0);
        HashMap var4 = new HashMap();
        this.entries.stream().map(var1 -> var1.collectRegisteredValues(var3)).forEach(var1 -> var4.put((ResourceKey<IRegistry<?>>)var1.key, (h<?>)var1));
        Set var5 = var0.listRegistries().collect(Collectors.toUnmodifiableSet());
        var12.listRegistries().filter(var1 -> !var5.contains(var1)).forEach(var1 -> var4.putIfAbsent((ResourceKey<IRegistry<?>>)var1, new h(var1, Lifecycle.stable(), Map.of())));
        Stream<HolderLookup.c<?>> var6 = var4.values().stream().map(var1 -> var1.buildAsLookup(var0.owner));
        HolderLookup.b var7 = RegistrySetBuilder.buildProviderWithContext(var0, var6);
        var3.reportUnclaimedRegisteredValues();
        var3.throwOnError();
        HolderLookup.b var8 = this.createLazyFullPatchedRegistries(var0, var12, var2, var4, var7);
        return new e(var8, var7);
    }

    record i<T>(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle, g<T> bootstrap) {
        void apply(a var0) {
            this.bootstrap.run(var0.bootstapContext());
        }

        public h<T> collectRegisteredValues(a var0) {
            HashMap var1 = new HashMap();
            Iterator<Map.Entry<ResourceKey<?>, f<?>>> var2 = var0.registeredValues.entrySet().iterator();
            while (var2.hasNext()) {
                Map.Entry<ResourceKey<?>, f<?>> var3 = var2.next();
                ResourceKey<?> var4 = var3.getKey();
                if (!var4.isFor(this.key)) continue;
                ResourceKey<?> var5 = var4;
                f<?> var6 = var3.getValue();
                Holder.c<Object> var7 = var0.lookup.holders.remove(var4);
                var1.put(var5, new k(var6, Optional.ofNullable(var7)));
                var2.remove();
            }
            return new h(this.key, this.lifecycle, var1);
        }
    }

    @FunctionalInterface
    public static interface g<T> {
        public void run(BootstapContext<T> var1);
    }

    static final class a
    extends Record {
        final b owner;
        final j lookup;
        final Map<MinecraftKey, HolderGetter<?>> registries;
        final Map<ResourceKey<?>, f<?>> registeredValues;
        final List<RuntimeException> errors;

        private a(b var0, j var1, Map<MinecraftKey, HolderGetter<?>> var2, Map<ResourceKey<?>, f<?>> var3, List<RuntimeException> var4) {
            this.owner = var0;
            this.lookup = var1;
            this.registries = var2;
            this.registeredValues = var3;
            this.errors = var4;
        }

        public static a create(IRegistryCustom var0, Stream<ResourceKey<? extends IRegistry<?>>> var12) {
            b var22 = new b();
            ArrayList<RuntimeException> var3 = new ArrayList<RuntimeException>();
            j var4 = new j(var22);
            ImmutableMap.Builder var5 = ImmutableMap.builder();
            var0.registries().forEach(var1 -> var5.put((Object)var1.key().location(), RegistrySetBuilder.wrapContextLookup(var1.value().asLookup())));
            var12.forEach(var2 -> var5.put((Object)var2.location(), (Object)var4));
            return new a(var22, var4, (Map<MinecraftKey, HolderGetter<?>>)var5.build(), new HashMap(), (List<RuntimeException>)var3);
        }

        public <T> BootstapContext<T> bootstapContext() {
            return new BootstapContext<T>(){

                @Override
                public Holder.c<T> register(ResourceKey<T> var0, T var1, Lifecycle var2) {
                    f var3 = registeredValues.put(var0, new f(var1, var2));
                    if (var3 != null) {
                        errors.add(new IllegalStateException("Duplicate registration for " + var0 + ", new=" + var1 + ", old=" + var3.value));
                    }
                    return lookup.getOrCreate(var0);
                }

                @Override
                public <S> HolderGetter<S> lookup(ResourceKey<? extends IRegistry<? extends S>> var0) {
                    return registries.getOrDefault(var0.location(), lookup);
                }
            };
        }

        public void reportUnclaimedRegisteredValues() {
            this.registeredValues.forEach((var0, var1) -> this.errors.add(new IllegalStateException("Orpaned value " + var1.value + " for key " + var0)));
        }

        public void reportNotCollectedHolders() {
            for (ResourceKey<Object> var1 : this.lookup.holders.keySet()) {
                this.errors.add(new IllegalStateException("Unreferenced key: " + var1));
            }
        }

        public void throwOnError() {
            if (!this.errors.isEmpty()) {
                IllegalStateException var0 = new IllegalStateException("Errors during registry creation");
                for (RuntimeException var2 : this.errors) {
                    var0.addSuppressed(var2);
                }
                throw var0;
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "owner;lookup;registries;registeredValues;errors", "owner", "lookup", "registries", "registeredValues", "errors"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "owner;lookup;registries;registeredValues;errors", "owner", "lookup", "registries", "registeredValues", "errors"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "owner;lookup;registries;registeredValues;errors", "owner", "lookup", "registries", "registeredValues", "errors"}, this, var0);
        }

        public b owner() {
            return this.owner;
        }

        public j lookup() {
            return this.lookup;
        }

        public Map<MinecraftKey, HolderGetter<?>> registries() {
            return this.registries;
        }

        public Map<ResourceKey<?>, f<?>> registeredValues() {
            return this.registeredValues;
        }

        public List<RuntimeException> errors() {
            return this.errors;
        }
    }

    static class b
    implements HolderOwner<Object> {
        private final Set<HolderOwner<?>> owners = Sets.newIdentityHashSet();

        b() {
        }

        @Override
        public boolean canSerializeIn(HolderOwner<Object> var0) {
            return this.owners.contains(var0);
        }

        public void add(HolderOwner<?> var0) {
            this.owners.add(var0);
        }

        public <T> HolderOwner<T> cast() {
            return this;
        }
    }

    public record e(HolderLookup.b full, HolderLookup.b patches) {
    }

    static final class h<T>
    extends Record {
        final ResourceKey<? extends IRegistry<? extends T>> key;
        private final Lifecycle lifecycle;
        private final Map<ResourceKey<T>, k<T>> values;

        h(ResourceKey<? extends IRegistry<? extends T>> var0, Lifecycle var1, Map<ResourceKey<T>, k<T>> var2) {
            this.key = var0;
            this.lifecycle = var1;
            this.values = var2;
        }

        public HolderLookup.c<T> buildAsLookup(b var0) {
            Map var12 = this.values.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, var1 -> {
                k var2 = (k)var1.getValue();
                Holder.c var3 = var2.holder().orElseGet(() -> Holder.c.createStandAlone(var0.cast(), (ResourceKey)var1.getKey()));
                var3.bindValue(var2.value().value());
                return var3;
            }));
            HolderLookup.c var2 = RegistrySetBuilder.lookupFromMap(this.key, this.lifecycle, var12);
            var0.add(var2);
            return var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "key;lifecycle;values", "key", "lifecycle", "values"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "key;lifecycle;values", "key", "lifecycle", "values"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "key;lifecycle;values", "key", "lifecycle", "values"}, this, var0);
        }

        public ResourceKey<? extends IRegistry<? extends T>> key() {
            return this.key;
        }

        public Lifecycle lifecycle() {
            return this.lifecycle;
        }

        public Map<ResourceKey<T>, k<T>> values() {
            return this.values;
        }
    }

    static class d<T>
    extends Holder.c<T> {
        @Nullable
        Supplier<T> supplier;

        protected d(HolderOwner<T> var0, @Nullable ResourceKey<T> var1) {
            super(Holder.c.a.STAND_ALONE, var0, var1, null);
        }

        @Override
        protected void bindValue(T var0) {
            super.bindValue(var0);
            this.supplier = null;
        }

        @Override
        public T value() {
            if (this.supplier != null) {
                this.bindValue(this.supplier.get());
            }
            return super.value();
        }
    }

    record k<T>(f<T> value, Optional<Holder.c<T>> holder) {
    }

    static final class f<T>
    extends Record {
        final T value;
        private final Lifecycle lifecycle;

        f(T var0, Lifecycle var1) {
            this.value = var0;
            this.lifecycle = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{f.class, "value;lifecycle", "value", "lifecycle"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{f.class, "value;lifecycle", "value", "lifecycle"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{f.class, "value;lifecycle", "value", "lifecycle"}, this, var0);
        }

        public T value() {
            return this.value;
        }

        public Lifecycle lifecycle() {
            return this.lifecycle;
        }
    }

    static class j
    extends c<Object> {
        final Map<ResourceKey<Object>, Holder.c<Object>> holders = new HashMap<ResourceKey<Object>, Holder.c<Object>>();

        public j(HolderOwner<Object> var0) {
            super(var0);
        }

        @Override
        public Optional<Holder.c<Object>> get(ResourceKey<Object> var0) {
            return Optional.of(this.getOrCreate(var0));
        }

        <T> Holder.c<T> getOrCreate(ResourceKey<T> var02) {
            return this.holders.computeIfAbsent(var02, var0 -> Holder.c.createStandAlone(this.owner, var0));
        }
    }

    static abstract class c<T>
    implements HolderGetter<T> {
        protected final HolderOwner<T> owner;

        protected c(HolderOwner<T> var0) {
            this.owner = var0;
        }

        @Override
        public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
            return Optional.of(HolderSet.emptyNamed(this.owner, var0));
        }
    }
}

