/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.ResourceKey;

public class LayeredRegistryAccess<T> {
    private final List<T> keys;
    private final List<IRegistryCustom.Dimension> values;
    private final IRegistryCustom.Dimension composite;

    public LayeredRegistryAccess(List<T> var0) {
        this(var0, SystemUtils.make(() -> {
            Object[] var1 = new IRegistryCustom.Dimension[var0.size()];
            Arrays.fill(var1, IRegistryCustom.EMPTY);
            return Arrays.asList(var1);
        }));
    }

    private LayeredRegistryAccess(List<T> var0, List<IRegistryCustom.Dimension> var1) {
        this.keys = List.copyOf(var0);
        this.values = List.copyOf(var1);
        this.composite = new IRegistryCustom.c(LayeredRegistryAccess.collectRegistries(var1.stream())).freeze();
    }

    private int getLayerIndexOrThrow(T var0) {
        int var1 = this.keys.indexOf(var0);
        if (var1 == -1) {
            throw new IllegalStateException("Can't find " + var0 + " inside " + this.keys);
        }
        return var1;
    }

    public IRegistryCustom.Dimension getLayer(T var0) {
        int var1 = this.getLayerIndexOrThrow(var0);
        return this.values.get(var1);
    }

    public IRegistryCustom.Dimension getAccessForLoading(T var0) {
        int var1 = this.getLayerIndexOrThrow(var0);
        return this.getCompositeAccessForLayers(0, var1);
    }

    public IRegistryCustom.Dimension getAccessFrom(T var0) {
        int var1 = this.getLayerIndexOrThrow(var0);
        return this.getCompositeAccessForLayers(var1, this.values.size());
    }

    private IRegistryCustom.Dimension getCompositeAccessForLayers(int var0, int var1) {
        return new IRegistryCustom.c(LayeredRegistryAccess.collectRegistries(this.values.subList(var0, var1).stream())).freeze();
    }

    public LayeredRegistryAccess<T> replaceFrom(T var0, IRegistryCustom.Dimension ... var1) {
        return this.replaceFrom(var0, Arrays.asList(var1));
    }

    public LayeredRegistryAccess<T> replaceFrom(T var0, List<IRegistryCustom.Dimension> var1) {
        int var2 = this.getLayerIndexOrThrow(var0);
        if (var1.size() > this.values.size() - var2) {
            throw new IllegalStateException("Too many values to replace");
        }
        ArrayList<IRegistryCustom.Dimension> var3 = new ArrayList<IRegistryCustom.Dimension>();
        for (int var4 = 0; var4 < var2; ++var4) {
            var3.add(this.values.get(var4));
        }
        var3.addAll(var1);
        while (var3.size() < this.values.size()) {
            var3.add(IRegistryCustom.EMPTY);
        }
        return new LayeredRegistryAccess<T>(this.keys, var3);
    }

    public IRegistryCustom.Dimension compositeAccess() {
        return this.composite;
    }

    private static Map<ResourceKey<? extends IRegistry<?>>, IRegistry<?>> collectRegistries(Stream<? extends IRegistryCustom> var0) {
        HashMap var1 = new HashMap();
        var0.forEach(var12 -> var12.registries().forEach(var1 -> {
            if (var1.put(var1.key(), var1.value()) != null) {
                throw new IllegalStateException("Duplicated registry " + var1.key());
            }
        }));
        return var1;
    }
}

