/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.google.common.collect.Maps;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import java.util.Locale;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentAngle;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentInventorySlot;
import net.minecraft.commands.arguments.ArgumentMathOperation;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentNBTBase;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.ArgumentProfile;
import net.minecraft.commands.arguments.ArgumentScoreboardCriteria;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentScoreboardTeam;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.commands.arguments.ArgumentUUID;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.commands.arguments.HeightmapTypeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.commands.arguments.StyleArgument;
import net.minecraft.commands.arguments.TemplateMirrorArgument;
import net.minecraft.commands.arguments.TemplateRotationArgument;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentRotationAxis;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.commands.synchronization.brigadier.ArgumentSerializerString;
import net.minecraft.commands.synchronization.brigadier.DoubleArgumentInfo;
import net.minecraft.commands.synchronization.brigadier.FloatArgumentInfo;
import net.minecraft.commands.synchronization.brigadier.IntegerArgumentInfo;
import net.minecraft.commands.synchronization.brigadier.LongArgumentInfo;
import net.minecraft.core.IRegistry;
import net.minecraft.gametest.framework.GameTestHarnessTestClassArgument;
import net.minecraft.gametest.framework.GameTestHarnessTestFunctionArgument;

public class ArgumentTypeInfos {
    private static final Map<Class<?>, ArgumentTypeInfo<?, ?>> BY_CLASS = Maps.newHashMap();

    private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.a<A>> ArgumentTypeInfo<A, T> register(IRegistry<ArgumentTypeInfo<?, ?>> var0, String var1, Class<? extends A> var2, ArgumentTypeInfo<A, T> var3) {
        BY_CLASS.put(var2, var3);
        return IRegistry.register(var0, var1, var3);
    }

    public static ArgumentTypeInfo<?, ?> bootstrap(IRegistry<ArgumentTypeInfo<?, ?>> var0) {
        ArgumentTypeInfos.register(var0, "brigadier:bool", BoolArgumentType.class, SingletonArgumentInfo.contextFree(BoolArgumentType::bool));
        ArgumentTypeInfos.register(var0, "brigadier:float", FloatArgumentType.class, new FloatArgumentInfo());
        ArgumentTypeInfos.register(var0, "brigadier:double", DoubleArgumentType.class, new DoubleArgumentInfo());
        ArgumentTypeInfos.register(var0, "brigadier:integer", IntegerArgumentType.class, new IntegerArgumentInfo());
        ArgumentTypeInfos.register(var0, "brigadier:long", LongArgumentType.class, new LongArgumentInfo());
        ArgumentTypeInfos.register(var0, "brigadier:string", StringArgumentType.class, new ArgumentSerializerString());
        ArgumentTypeInfos.register(var0, "entity", ArgumentEntity.class, new ArgumentEntity.Info());
        ArgumentTypeInfos.register(var0, "game_profile", ArgumentProfile.class, SingletonArgumentInfo.contextFree(ArgumentProfile::gameProfile));
        ArgumentTypeInfos.register(var0, "block_pos", ArgumentPosition.class, SingletonArgumentInfo.contextFree(ArgumentPosition::blockPos));
        ArgumentTypeInfos.register(var0, "column_pos", ArgumentVec2I.class, SingletonArgumentInfo.contextFree(ArgumentVec2I::columnPos));
        ArgumentTypeInfos.register(var0, "vec3", ArgumentVec3.class, SingletonArgumentInfo.contextFree(ArgumentVec3::vec3));
        ArgumentTypeInfos.register(var0, "vec2", ArgumentVec2.class, SingletonArgumentInfo.contextFree(ArgumentVec2::vec2));
        ArgumentTypeInfos.register(var0, "block_state", ArgumentTile.class, SingletonArgumentInfo.contextAware(ArgumentTile::block));
        ArgumentTypeInfos.register(var0, "block_predicate", ArgumentBlockPredicate.class, SingletonArgumentInfo.contextAware(ArgumentBlockPredicate::blockPredicate));
        ArgumentTypeInfos.register(var0, "item_stack", ArgumentItemStack.class, SingletonArgumentInfo.contextAware(ArgumentItemStack::item));
        ArgumentTypeInfos.register(var0, "item_predicate", ArgumentItemPredicate.class, SingletonArgumentInfo.contextAware(ArgumentItemPredicate::itemPredicate));
        ArgumentTypeInfos.register(var0, "color", ArgumentChatFormat.class, SingletonArgumentInfo.contextFree(ArgumentChatFormat::color));
        ArgumentTypeInfos.register(var0, "component", ArgumentChatComponent.class, SingletonArgumentInfo.contextFree(ArgumentChatComponent::textComponent));
        ArgumentTypeInfos.register(var0, "style", StyleArgument.class, SingletonArgumentInfo.contextFree(StyleArgument::style));
        ArgumentTypeInfos.register(var0, "message", ArgumentChat.class, SingletonArgumentInfo.contextFree(ArgumentChat::message));
        ArgumentTypeInfos.register(var0, "nbt_compound_tag", ArgumentNBTTag.class, SingletonArgumentInfo.contextFree(ArgumentNBTTag::compoundTag));
        ArgumentTypeInfos.register(var0, "nbt_tag", ArgumentNBTBase.class, SingletonArgumentInfo.contextFree(ArgumentNBTBase::nbtTag));
        ArgumentTypeInfos.register(var0, "nbt_path", ArgumentNBTKey.class, SingletonArgumentInfo.contextFree(ArgumentNBTKey::nbtPath));
        ArgumentTypeInfos.register(var0, "objective", ArgumentScoreboardObjective.class, SingletonArgumentInfo.contextFree(ArgumentScoreboardObjective::objective));
        ArgumentTypeInfos.register(var0, "objective_criteria", ArgumentScoreboardCriteria.class, SingletonArgumentInfo.contextFree(ArgumentScoreboardCriteria::criteria));
        ArgumentTypeInfos.register(var0, "operation", ArgumentMathOperation.class, SingletonArgumentInfo.contextFree(ArgumentMathOperation::operation));
        ArgumentTypeInfos.register(var0, "particle", ArgumentParticle.class, SingletonArgumentInfo.contextAware(ArgumentParticle::particle));
        ArgumentTypeInfos.register(var0, "angle", ArgumentAngle.class, SingletonArgumentInfo.contextFree(ArgumentAngle::angle));
        ArgumentTypeInfos.register(var0, "rotation", ArgumentRotation.class, SingletonArgumentInfo.contextFree(ArgumentRotation::rotation));
        ArgumentTypeInfos.register(var0, "scoreboard_slot", ArgumentScoreboardSlot.class, SingletonArgumentInfo.contextFree(ArgumentScoreboardSlot::displaySlot));
        ArgumentTypeInfos.register(var0, "score_holder", ArgumentScoreholder.class, new ArgumentScoreholder.a());
        ArgumentTypeInfos.register(var0, "swizzle", ArgumentRotationAxis.class, SingletonArgumentInfo.contextFree(ArgumentRotationAxis::swizzle));
        ArgumentTypeInfos.register(var0, "team", ArgumentScoreboardTeam.class, SingletonArgumentInfo.contextFree(ArgumentScoreboardTeam::team));
        ArgumentTypeInfos.register(var0, "item_slot", ArgumentInventorySlot.class, SingletonArgumentInfo.contextFree(ArgumentInventorySlot::slot));
        ArgumentTypeInfos.register(var0, "resource_location", ArgumentMinecraftKeyRegistered.class, SingletonArgumentInfo.contextFree(ArgumentMinecraftKeyRegistered::id));
        ArgumentTypeInfos.register(var0, "function", ArgumentTag.class, SingletonArgumentInfo.contextFree(ArgumentTag::functions));
        ArgumentTypeInfos.register(var0, "entity_anchor", ArgumentAnchor.class, SingletonArgumentInfo.contextFree(ArgumentAnchor::anchor));
        ArgumentTypeInfos.register(var0, "int_range", ArgumentCriterionValue.b.class, SingletonArgumentInfo.contextFree(ArgumentCriterionValue::intRange));
        ArgumentTypeInfos.register(var0, "float_range", ArgumentCriterionValue.a.class, SingletonArgumentInfo.contextFree(ArgumentCriterionValue::floatRange));
        ArgumentTypeInfos.register(var0, "dimension", ArgumentDimension.class, SingletonArgumentInfo.contextFree(ArgumentDimension::dimension));
        ArgumentTypeInfos.register(var0, "gamemode", GameModeArgument.class, SingletonArgumentInfo.contextFree(GameModeArgument::gameMode));
        ArgumentTypeInfos.register(var0, "time", ArgumentTime.class, new ArgumentTime.a());
        ArgumentTypeInfos.register(var0, "resource_or_tag", ArgumentTypeInfos.fixClassType(ResourceOrTagArgument.class), new ResourceOrTagArgument.a());
        ArgumentTypeInfos.register(var0, "resource_or_tag_key", ArgumentTypeInfos.fixClassType(ResourceOrTagKeyArgument.class), new ResourceOrTagKeyArgument.a());
        ArgumentTypeInfos.register(var0, "resource", ArgumentTypeInfos.fixClassType(ResourceArgument.class), new ResourceArgument.a());
        ArgumentTypeInfos.register(var0, "resource_key", ArgumentTypeInfos.fixClassType(ResourceKeyArgument.class), new ResourceKeyArgument.a());
        ArgumentTypeInfos.register(var0, "template_mirror", TemplateMirrorArgument.class, SingletonArgumentInfo.contextFree(TemplateMirrorArgument::templateMirror));
        ArgumentTypeInfos.register(var0, "template_rotation", TemplateRotationArgument.class, SingletonArgumentInfo.contextFree(TemplateRotationArgument::templateRotation));
        ArgumentTypeInfos.register(var0, "heightmap", HeightmapTypeArgument.class, SingletonArgumentInfo.contextFree(HeightmapTypeArgument::heightmap));
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            ArgumentTypeInfos.register(var0, "test_argument", GameTestHarnessTestFunctionArgument.class, SingletonArgumentInfo.contextFree(GameTestHarnessTestFunctionArgument::testFunctionArgument));
            ArgumentTypeInfos.register(var0, "test_class", GameTestHarnessTestClassArgument.class, SingletonArgumentInfo.contextFree(GameTestHarnessTestClassArgument::testClassName));
        }
        return ArgumentTypeInfos.register(var0, "uuid", ArgumentUUID.class, SingletonArgumentInfo.contextFree(ArgumentUUID::uuid));
    }

    private static <T extends ArgumentType<?>> Class<T> fixClassType(Class<? super T> var0) {
        return var0;
    }

    public static boolean isClassRecognized(Class<?> var0) {
        return BY_CLASS.containsKey(var0);
    }

    public static <A extends ArgumentType<?>> ArgumentTypeInfo<A, ?> byClass(A var0) {
        ArgumentTypeInfo<?, ?> var1 = BY_CLASS.get(var0.getClass());
        if (var1 == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unrecognized argument type %s (%s)", var0, var0.getClass()));
        }
        return var1;
    }

    public static <A extends ArgumentType<?>> ArgumentTypeInfo.a<A> unpack(A var0) {
        return ArgumentTypeInfos.byClass(var0).unpack(var0);
    }
}

