/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public class ResourceOrTagArgument<T>
implements ArgumentType<c<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012", "#skeletons", "#minecraft:skeletons");
    private static final Dynamic2CommandExceptionType ERROR_UNKNOWN_TAG = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("argument.resource_tag.not_found", var0, var1));
    private static final Dynamic3CommandExceptionType ERROR_INVALID_TAG_TYPE = new Dynamic3CommandExceptionType((var0, var1, var2) -> IChatBaseComponent.translatableEscape("argument.resource_tag.invalid_type", var0, var1, var2));
    private final HolderLookup<T> registryLookup;
    final ResourceKey<? extends IRegistry<T>> registryKey;

    public ResourceOrTagArgument(CommandBuildContext var0, ResourceKey<? extends IRegistry<T>> var1) {
        this.registryKey = var1;
        this.registryLookup = var0.holderLookup(var1);
    }

    public static <T> ResourceOrTagArgument<T> resourceOrTag(CommandBuildContext var0, ResourceKey<? extends IRegistry<T>> var1) {
        return new ResourceOrTagArgument<T>(var0, var1);
    }

    public static <T> c<T> getResourceOrTag(CommandContext<CommandListenerWrapper> var0, String var1, ResourceKey<IRegistry<T>> var2) throws CommandSyntaxException {
        c var3 = (c)var0.getArgument(var1, c.class);
        Optional<c<T>> var4 = var3.cast(var2);
        return var4.orElseThrow(() -> (CommandSyntaxException)((Object)((Object)var3.unwrap().map(var1 -> {
            ResourceKey var2 = var1.key();
            return ResourceArgument.ERROR_INVALID_RESOURCE_TYPE.create((Object)var2.location(), (Object)var2.registry(), (Object)var2.location());
        }, var1 -> {
            TagKey var2 = var1.key();
            return ERROR_INVALID_TAG_TYPE.create((Object)var2.location(), var2.registry(), (Object)var2.location());
        }))));
    }

    public c<T> parse(StringReader var0) throws CommandSyntaxException {
        if (var0.canRead() && var0.peek() == '#') {
            int var1 = var0.getCursor();
            try {
                var0.skip();
                MinecraftKey var2 = MinecraftKey.read(var0);
                TagKey var3 = TagKey.create(this.registryKey, var2);
                HolderSet.Named var4 = this.registryLookup.get(var3).orElseThrow(() -> ERROR_UNKNOWN_TAG.create((Object)var2, (Object)this.registryKey.location()));
                return new d(var4);
            }
            catch (CommandSyntaxException var2) {
                var0.setCursor(var1);
                throw var2;
            }
        }
        MinecraftKey var1 = MinecraftKey.read(var0);
        ResourceKey var2 = ResourceKey.create(this.registryKey, var1);
        Holder.c var3 = this.registryLookup.get(var2).orElseThrow(() -> ResourceArgument.ERROR_UNKNOWN_RESOURCE.create((Object)var1, (Object)this.registryKey.location()));
        return new b(var3);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        ICompletionProvider.suggestResource(this.registryLookup.listTagIds().map(TagKey::location), var1, "#");
        return ICompletionProvider.suggestResource(this.registryLookup.listElementIds().map(ResourceKey::location), var1);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static interface c<T>
    extends Predicate<Holder<T>> {
        public Either<Holder.c<T>, HolderSet.Named<T>> unwrap();

        public <E> Optional<c<E>> cast(ResourceKey<? extends IRegistry<E>> var1);

        public String asPrintable();
    }

    record d<T>(HolderSet.Named<T> tag) implements c<T>
    {
        @Override
        public Either<Holder.c<T>, HolderSet.Named<T>> unwrap() {
            return Either.right(this.tag);
        }

        @Override
        public <E> Optional<c<E>> cast(ResourceKey<? extends IRegistry<E>> var0) {
            return this.tag.key().isFor(var0) ? Optional.of(this) : Optional.empty();
        }

        @Override
        public boolean test(Holder<T> var0) {
            return this.tag.contains(var0);
        }

        @Override
        public String asPrintable() {
            return "#" + this.tag.key().location();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Holder)object);
        }
    }

    record b<T>(Holder.c<T> value) implements c<T>
    {
        @Override
        public Either<Holder.c<T>, HolderSet.Named<T>> unwrap() {
            return Either.left(this.value);
        }

        @Override
        public <E> Optional<c<E>> cast(ResourceKey<? extends IRegistry<E>> var0) {
            return this.value.key().isFor(var0) ? Optional.of(this) : Optional.empty();
        }

        @Override
        public boolean test(Holder<T> var0) {
            return var0.equals(this.value);
        }

        @Override
        public String asPrintable() {
            return this.value.key().location().toString();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Holder)object);
        }
    }

    public static class net.minecraft.commands.arguments.ResourceOrTagArgument$a<T>
    implements ArgumentTypeInfo<ResourceOrTagArgument<T>, a> {
        @Override
        public void serializeToNetwork(a var0, PacketDataSerializer var1) {
            var1.writeResourceKey(var0.registryKey);
        }

        @Override
        public a deserializeFromNetwork(PacketDataSerializer var0) {
            return new a(var0.readRegistryKey());
        }

        @Override
        public void serializeToJson(a var0, JsonObject var1) {
            var1.addProperty("registry", var0.registryKey.location().toString());
        }

        @Override
        public a unpack(ResourceOrTagArgument<T> var0) {
            return new a(var0.registryKey);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.a deserializeFromNetwork(PacketDataSerializer packetDataSerializer) {
            return this.deserializeFromNetwork(packetDataSerializer);
        }

        public final class a
        implements ArgumentTypeInfo.a<ResourceOrTagArgument<T>> {
            final ResourceKey<? extends IRegistry<T>> registryKey;

            a(ResourceKey var1) {
                this.registryKey = var1;
            }

            @Override
            public ResourceOrTagArgument<T> instantiate(CommandBuildContext var0) {
                return new ResourceOrTagArgument(var0, this.registryKey);
            }

            @Override
            public ArgumentTypeInfo<ResourceOrTagArgument<T>, ?> type() {
                return a.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
                return this.instantiate(commandBuildContext);
            }
        }
    }
}

