/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import net.minecraft.SystemUtils;

public class ParserUtils {
    private static final Field JSON_READER_POS = SystemUtils.make(() -> {
        try {
            Field var0 = JsonReader.class.getDeclaredField("pos");
            var0.setAccessible(true);
            return var0;
        }
        catch (NoSuchFieldException var0) {
            throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", var0);
        }
    });
    private static final Field JSON_READER_LINESTART = SystemUtils.make(() -> {
        try {
            Field var0 = JsonReader.class.getDeclaredField("lineStart");
            var0.setAccessible(true);
            return var0;
        }
        catch (NoSuchFieldException var0) {
            throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", var0);
        }
    });

    private static int getPos(JsonReader var0) {
        try {
            return JSON_READER_POS.getInt(var0) - JSON_READER_LINESTART.getInt(var0) + 1;
        }
        catch (IllegalAccessException var1) {
            throw new IllegalStateException("Couldn't read position of JsonReader", var1);
        }
    }

    public static <T> T parseJson(com.mojang.brigadier.StringReader var0, Codec<T> var1) {
        JsonReader var2 = new JsonReader((Reader)new StringReader(var0.getRemaining()));
        var2.setLenient(false);
        try {
            JsonElement var3 = Streams.parse((JsonReader)var2);
            Object t2 = SystemUtils.getOrThrow(var1.parse((DynamicOps)JsonOps.INSTANCE, (Object)var3), JsonParseException::new);
            return t2;
        }
        catch (StackOverflowError var3) {
            throw new JsonParseException((Throwable)var3);
        }
        finally {
            var0.setCursor(var0.getCursor() + ParserUtils.getPos(var2));
        }
    }
}

