/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.phys.Vec3D;

public record LightningBoltPredicate(CriterionConditionValue.IntegerRange blocksSetOnFire, Optional<CriterionConditionEntity> entityStruck) implements EntitySubPredicate
{
    public static final MapCodec<LightningBoltPredicate> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(CriterionConditionValue.IntegerRange.CODEC, "blocks_set_on_fire", CriterionConditionValue.IntegerRange.ANY).forGetter(LightningBoltPredicate::blocksSetOnFire), (App)ExtraCodecs.strictOptionalField(CriterionConditionEntity.CODEC, "entity_struck").forGetter(LightningBoltPredicate::entityStruck)).apply((Applicative)var0, LightningBoltPredicate::new));

    public static LightningBoltPredicate blockSetOnFire(CriterionConditionValue.IntegerRange var0) {
        return new LightningBoltPredicate(var0, Optional.empty());
    }

    @Override
    public EntitySubPredicate.a type() {
        return EntitySubPredicate.b.LIGHTNING;
    }

    @Override
    public boolean matches(Entity var0, WorldServer var1, @Nullable Vec3D var22) {
        if (!(var0 instanceof EntityLightning)) {
            return false;
        }
        EntityLightning var3 = (EntityLightning)var0;
        return this.blocksSetOnFire.matches(var3.getBlocksSetOnFire()) && (this.entityStruck.isEmpty() || var3.getHitEntities().anyMatch(var2 -> this.entityStruck.get().matches(var1, var22, (Entity)var2)));
    }
}

