/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.IRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3D;

public class EntityVariantPredicate<V> {
    private final Function<Entity, Optional<V>> getter;
    private final EntitySubPredicate.a type;

    public static <V> EntityVariantPredicate<V> create(IRegistry<V> var0, Function<Entity, Optional<V>> var1) {
        return new EntityVariantPredicate<V>(var0.byNameCodec(), var1);
    }

    public static <V> EntityVariantPredicate<V> create(Codec<V> var0, Function<Entity, Optional<V>> var1) {
        return new EntityVariantPredicate<V>(var0, var1);
    }

    private EntityVariantPredicate(Codec<V> var0, Function<Entity, Optional<V>> var12) {
        this.getter = var12;
        MapCodec var2 = RecordCodecBuilder.mapCodec(var1 -> var1.group((App)var0.fieldOf("variant").forGetter(a::variant)).apply((Applicative)var1, this::createPredicate));
        this.type = new EntitySubPredicate.a((MapCodec<? extends EntitySubPredicate>)var2);
    }

    public EntitySubPredicate.a type() {
        return this.type;
    }

    public a<V> createPredicate(V var0) {
        return new a<V>(this.type, this.getter, var0);
    }

    public record a<V>(EntitySubPredicate.a type, Function<Entity, Optional<V>> getter, V variant) implements EntitySubPredicate
    {
        @Override
        public boolean matches(Entity var02, WorldServer var1, @Nullable Vec3D var2) {
            return this.getter.apply(var02).filter(var0 -> var0.equals(this.variant)).isPresent();
        }
    }
}

