/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionDistance;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionLocation;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.phys.Vec3D;

public class DistanceTrigger
extends CriterionTriggerAbstract<a> {
    @Override
    public Codec<a> codec() {
        return a.CODEC;
    }

    public void trigger(EntityPlayer var0, Vec3D var1) {
        Vec3D var2 = var0.position();
        this.trigger(var0, (T var3) -> var3.matches(var0.serverLevel(), var1, var2));
    }

    public record a(Optional<ContextAwarePredicate> player, Optional<CriterionConditionLocation> startPosition, Optional<CriterionConditionDistance> distance) implements CriterionTriggerAbstract.a
    {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(CriterionConditionEntity.ADVANCEMENT_CODEC, "player").forGetter(a::player), (App)ExtraCodecs.strictOptionalField(CriterionConditionLocation.CODEC, "start_position").forGetter(a::startPosition), (App)ExtraCodecs.strictOptionalField(CriterionConditionDistance.CODEC, "distance").forGetter(a::distance)).apply((Applicative)var0, a::new));

        public static Criterion<a> fallFromHeight(CriterionConditionEntity.a var0, CriterionConditionDistance var1, CriterionConditionLocation.a var2) {
            return CriterionTriggers.FALL_FROM_HEIGHT.createCriterion(new a(Optional.of(CriterionConditionEntity.wrap(var0)), Optional.of(var2.build()), Optional.of(var1)));
        }

        public static Criterion<a> rideEntityInLava(CriterionConditionEntity.a var0, CriterionConditionDistance var1) {
            return CriterionTriggers.RIDE_ENTITY_IN_LAVA_TRIGGER.createCriterion(new a(Optional.of(CriterionConditionEntity.wrap(var0)), Optional.empty(), Optional.of(var1)));
        }

        public static Criterion<a> travelledThroughNether(CriterionConditionDistance var0) {
            return CriterionTriggers.NETHER_TRAVEL.createCriterion(new a(Optional.empty(), Optional.empty(), Optional.of(var0)));
        }

        public boolean matches(WorldServer var0, Vec3D var1, Vec3D var2) {
            if (this.startPosition.isPresent() && !this.startPosition.get().matches(var0, var1.x, var1.y, var1.z)) {
                return false;
            }
            return !this.distance.isPresent() || this.distance.get().matches(var1.x, var1.y, var1.z, var2.x, var2.y, var2.z);
        }
    }
}

