/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootTableInfo;

public class CriterionTriggerChanneledLightning
extends CriterionTriggerAbstract<a> {
    @Override
    public Codec<a> codec() {
        return a.CODEC;
    }

    @Override
    public void trigger(EntityPlayer var0, Collection<? extends Entity> var12) {
        List var2 = var12.stream().map(var1 -> CriterionConditionEntity.createContext(var0, var1)).collect(Collectors.toList());
        this.trigger(var0, (T var1) -> var1.matches(var2));
    }

    public record a(Optional<ContextAwarePredicate> player, List<ContextAwarePredicate> victims) implements CriterionTriggerAbstract.a
    {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(CriterionConditionEntity.ADVANCEMENT_CODEC, "player").forGetter(a::player), (App)ExtraCodecs.strictOptionalField(CriterionConditionEntity.ADVANCEMENT_CODEC.listOf(), "victims", List.of()).forGetter(a::victims)).apply((Applicative)var0, a::new));

        public static Criterion<a> channeledLightning(CriterionConditionEntity.a ... var0) {
            return CriterionTriggers.CHANNELED_LIGHTNING.createCriterion(new a(Optional.empty(), CriterionConditionEntity.wrap(var0)));
        }

        public boolean matches(Collection<? extends LootTableInfo> var0) {
            for (ContextAwarePredicate var2 : this.victims) {
                boolean var3 = false;
                for (LootTableInfo lootTableInfo : var0) {
                    if (!var2.matches(lootTableInfo)) continue;
                    var3 = true;
                    break;
                }
                if (var3) continue;
                return false;
            }
            return true;
        }

        @Override
        public void validate(CriterionValidator var0) {
            CriterionTriggerAbstract.a.super.validate(var0);
            var0.validateEntities(this.victims, ".victims");
        }
    }
}

