/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionDistance;
import net.minecraft.advancements.critereon.CriterionConditionEntityEquipment;
import net.minecraft.advancements.critereon.CriterionConditionEntityFlags;
import net.minecraft.advancements.critereon.CriterionConditionEntityType;
import net.minecraft.advancements.critereon.CriterionConditionLocation;
import net.minecraft.advancements.critereon.CriterionConditionMobEffect;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityProperty;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeamBase;

public record CriterionConditionEntity(Optional<CriterionConditionEntityType> entityType, Optional<CriterionConditionDistance> distanceToPlayer, Optional<CriterionConditionLocation> location, Optional<CriterionConditionLocation> steppingOnLocation, Optional<CriterionConditionMobEffect> effects, Optional<CriterionConditionNBT> nbt, Optional<CriterionConditionEntityFlags> flags, Optional<CriterionConditionEntityEquipment> equipment, Optional<EntitySubPredicate> subPredicate, Optional<CriterionConditionEntity> vehicle, Optional<CriterionConditionEntity> passenger, Optional<CriterionConditionEntity> targetedEntity, Optional<String> team) {
    public static final Codec<CriterionConditionEntity> CODEC = ExtraCodecs.recursive("EntityPredicate", var0 -> RecordCodecBuilder.create(var1 -> var1.group((App)ExtraCodecs.strictOptionalField(CriterionConditionEntityType.CODEC, "type").forGetter(CriterionConditionEntity::entityType), (App)ExtraCodecs.strictOptionalField(CriterionConditionDistance.CODEC, "distance").forGetter(CriterionConditionEntity::distanceToPlayer), (App)ExtraCodecs.strictOptionalField(CriterionConditionLocation.CODEC, "location").forGetter(CriterionConditionEntity::location), (App)ExtraCodecs.strictOptionalField(CriterionConditionLocation.CODEC, "stepping_on").forGetter(CriterionConditionEntity::steppingOnLocation), (App)ExtraCodecs.strictOptionalField(CriterionConditionMobEffect.CODEC, "effects").forGetter(CriterionConditionEntity::effects), (App)ExtraCodecs.strictOptionalField(CriterionConditionNBT.CODEC, "nbt").forGetter(CriterionConditionEntity::nbt), (App)ExtraCodecs.strictOptionalField(CriterionConditionEntityFlags.CODEC, "flags").forGetter(CriterionConditionEntity::flags), (App)ExtraCodecs.strictOptionalField(CriterionConditionEntityEquipment.CODEC, "equipment").forGetter(CriterionConditionEntity::equipment), (App)ExtraCodecs.strictOptionalField(EntitySubPredicate.CODEC, "type_specific").forGetter(CriterionConditionEntity::subPredicate), (App)ExtraCodecs.strictOptionalField(var0, "vehicle").forGetter(CriterionConditionEntity::vehicle), (App)ExtraCodecs.strictOptionalField(var0, "passenger").forGetter(CriterionConditionEntity::passenger), (App)ExtraCodecs.strictOptionalField(var0, "targeted_entity").forGetter(CriterionConditionEntity::targetedEntity), (App)ExtraCodecs.strictOptionalField(Codec.STRING, "team").forGetter(CriterionConditionEntity::team)).apply((Applicative)var1, CriterionConditionEntity::new)));
    public static final Codec<ContextAwarePredicate> ADVANCEMENT_CODEC = ExtraCodecs.withAlternative(ContextAwarePredicate.CODEC, CODEC, CriterionConditionEntity::wrap);

    public static ContextAwarePredicate wrap(a var0) {
        return CriterionConditionEntity.wrap(var0.build());
    }

    public static Optional<ContextAwarePredicate> wrap(Optional<CriterionConditionEntity> var0) {
        return var0.map(CriterionConditionEntity::wrap);
    }

    public static List<ContextAwarePredicate> wrap(a ... var0) {
        return Stream.of(var0).map(CriterionConditionEntity::wrap).toList();
    }

    public static ContextAwarePredicate wrap(CriterionConditionEntity var0) {
        LootItemCondition var1 = LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, var0).build();
        return new ContextAwarePredicate(List.of(var1));
    }

    public boolean matches(EntityPlayer var0, @Nullable Entity var1) {
        return this.matches(var0.serverLevel(), var0.position(), var1);
    }

    public boolean matches(WorldServer var0, @Nullable Vec3D var1, @Nullable Entity var22) {
        Object var3;
        if (var22 == null) {
            return false;
        }
        if (this.entityType.isPresent() && !this.entityType.get().matches(var22.getType())) {
            return false;
        }
        if (var1 == null ? this.distanceToPlayer.isPresent() : this.distanceToPlayer.isPresent() && !this.distanceToPlayer.get().matches(var1.x, var1.y, var1.z, var22.getX(), var22.getY(), var22.getZ())) {
            return false;
        }
        if (this.location.isPresent() && !this.location.get().matches(var0, var22.getX(), var22.getY(), var22.getZ())) {
            return false;
        }
        if (this.steppingOnLocation.isPresent()) {
            var3 = Vec3D.atCenterOf(var22.getOnPos());
            if (!this.steppingOnLocation.get().matches(var0, ((Vec3D)var3).x(), ((Vec3D)var3).y(), ((Vec3D)var3).z())) {
                return false;
            }
        }
        if (this.effects.isPresent() && !this.effects.get().matches(var22)) {
            return false;
        }
        if (this.nbt.isPresent() && !this.nbt.get().matches(var22)) {
            return false;
        }
        if (this.flags.isPresent() && !this.flags.get().matches(var22)) {
            return false;
        }
        if (this.equipment.isPresent() && !this.equipment.get().matches(var22)) {
            return false;
        }
        if (this.subPredicate.isPresent() && !this.subPredicate.get().matches(var22, var0, var1)) {
            return false;
        }
        if (this.vehicle.isPresent() && !this.vehicle.get().matches(var0, var1, var22.getVehicle())) {
            return false;
        }
        if (this.passenger.isPresent() && var22.getPassengers().stream().noneMatch(var2 -> this.passenger.get().matches(var0, var1, (Entity)var2))) {
            return false;
        }
        if (this.targetedEntity.isPresent() && !this.targetedEntity.get().matches(var0, var1, var22 instanceof EntityInsentient ? ((EntityInsentient)var22).getTarget() : null)) {
            return false;
        }
        return !this.team.isPresent() || (var3 = var22.getTeam()) != null && this.team.get().equals(((ScoreboardTeamBase)var3).getName());
    }

    public static LootTableInfo createContext(EntityPlayer var0, Entity var1) {
        LootParams var2 = new LootParams.a(var0.serverLevel()).withParameter(LootContextParameters.THIS_ENTITY, var1).withParameter(LootContextParameters.ORIGIN, var0.position()).create(LootContextParameterSets.ADVANCEMENT_ENTITY);
        return new LootTableInfo.Builder(var2).create(Optional.empty());
    }

    public static class a {
        private Optional<CriterionConditionEntityType> entityType = Optional.empty();
        private Optional<CriterionConditionDistance> distanceToPlayer = Optional.empty();
        private Optional<CriterionConditionLocation> location = Optional.empty();
        private Optional<CriterionConditionLocation> steppingOnLocation = Optional.empty();
        private Optional<CriterionConditionMobEffect> effects = Optional.empty();
        private Optional<CriterionConditionNBT> nbt = Optional.empty();
        private Optional<CriterionConditionEntityFlags> flags = Optional.empty();
        private Optional<CriterionConditionEntityEquipment> equipment = Optional.empty();
        private Optional<EntitySubPredicate> subPredicate = Optional.empty();
        private Optional<CriterionConditionEntity> vehicle = Optional.empty();
        private Optional<CriterionConditionEntity> passenger = Optional.empty();
        private Optional<CriterionConditionEntity> targetedEntity = Optional.empty();
        private Optional<String> team = Optional.empty();

        public static a entity() {
            return new a();
        }

        public a of(EntityTypes<?> var0) {
            this.entityType = Optional.of(CriterionConditionEntityType.of(var0));
            return this;
        }

        public a of(TagKey<EntityTypes<?>> var0) {
            this.entityType = Optional.of(CriterionConditionEntityType.of(var0));
            return this;
        }

        public a entityType(CriterionConditionEntityType var0) {
            this.entityType = Optional.of(var0);
            return this;
        }

        public a distance(CriterionConditionDistance var0) {
            this.distanceToPlayer = Optional.of(var0);
            return this;
        }

        public a located(CriterionConditionLocation.a var0) {
            this.location = Optional.of(var0.build());
            return this;
        }

        public a steppingOn(CriterionConditionLocation.a var0) {
            this.steppingOnLocation = Optional.of(var0.build());
            return this;
        }

        public a effects(CriterionConditionMobEffect.a var0) {
            this.effects = var0.build();
            return this;
        }

        public a nbt(CriterionConditionNBT var0) {
            this.nbt = Optional.of(var0);
            return this;
        }

        public a flags(CriterionConditionEntityFlags.a var0) {
            this.flags = Optional.of(var0.build());
            return this;
        }

        public a equipment(CriterionConditionEntityEquipment.a var0) {
            this.equipment = Optional.of(var0.build());
            return this;
        }

        public a equipment(CriterionConditionEntityEquipment var0) {
            this.equipment = Optional.of(var0);
            return this;
        }

        public a subPredicate(EntitySubPredicate var0) {
            this.subPredicate = Optional.of(var0);
            return this;
        }

        public a vehicle(a var0) {
            this.vehicle = Optional.of(var0.build());
            return this;
        }

        public a passenger(a var0) {
            this.passenger = Optional.of(var0.build());
            return this;
        }

        public a targetedEntity(a var0) {
            this.targetedEntity = Optional.of(var0.build());
            return this;
        }

        public a team(String var0) {
            this.team = Optional.of(var0);
            return this;
        }

        public CriterionConditionEntity build() {
            return new CriterionConditionEntity(this.entityType, this.distanceToPlayer, this.location, this.steppingOnLocation, this.effects, this.nbt, this.flags, this.equipment, this.subPredicate, this.vehicle, this.passenger, this.targetedEntity, this.team);
        }
    }
}

