/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.advancements.critereon.CriterionTriggerProperties;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;

public record CriterionConditionBlock(Optional<TagKey<Block>> tag, Optional<HolderSet<Block>> blocks, Optional<CriterionTriggerProperties> properties, Optional<CriterionConditionNBT> nbt) {
    private static final Codec<HolderSet<Block>> BLOCKS_CODEC = BuiltInRegistries.BLOCK.holderByNameCodec().listOf().xmap(HolderSet::direct, var0 -> var0.stream().toList());
    public static final Codec<CriterionConditionBlock> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(TagKey.codec(Registries.BLOCK), "tag").forGetter(CriterionConditionBlock::tag), (App)ExtraCodecs.strictOptionalField(BLOCKS_CODEC, "blocks").forGetter(CriterionConditionBlock::blocks), (App)ExtraCodecs.strictOptionalField(CriterionTriggerProperties.CODEC, "state").forGetter(CriterionConditionBlock::properties), (App)ExtraCodecs.strictOptionalField(CriterionConditionNBT.CODEC, "nbt").forGetter(CriterionConditionBlock::nbt)).apply((Applicative)var0, CriterionConditionBlock::new));

    public boolean matches(WorldServer var0, BlockPosition var1) {
        TileEntity var3;
        if (!var0.isLoaded(var1)) {
            return false;
        }
        IBlockData var2 = var0.getBlockState(var1);
        if (this.tag.isPresent() && !var2.is(this.tag.get())) {
            return false;
        }
        if (this.blocks.isPresent() && !var2.is(this.blocks.get())) {
            return false;
        }
        if (this.properties.isPresent() && !this.properties.get().matches(var2)) {
            return false;
        }
        return !this.nbt.isPresent() || (var3 = var0.getBlockEntity(var1)) != null && this.nbt.get().matches(var3.saveWithFullMetadata());
    }

    public static class a {
        private Optional<HolderSet<Block>> blocks = Optional.empty();
        private Optional<TagKey<Block>> tag = Optional.empty();
        private Optional<CriterionTriggerProperties> properties = Optional.empty();
        private Optional<CriterionConditionNBT> nbt = Optional.empty();

        private a() {
        }

        public static a block() {
            return new a();
        }

        public a of(Block ... var0) {
            this.blocks = Optional.of(HolderSet.direct(Block::builtInRegistryHolder, var0));
            return this;
        }

        public a of(Collection<Block> var0) {
            this.blocks = Optional.of(HolderSet.direct(Block::builtInRegistryHolder, var0));
            return this;
        }

        public a of(TagKey<Block> var0) {
            this.tag = Optional.of(var0);
            return this;
        }

        public a hasNbt(NBTTagCompound var0) {
            this.nbt = Optional.of(new CriterionConditionNBT(var0));
            return this;
        }

        public a setProperties(CriterionTriggerProperties.a var0) {
            this.properties = var0.build();
            return this;
        }

        public CriterionConditionBlock build() {
            return new CriterionConditionBlock(this.tag, this.blocks, this.properties, this.nbt);
        }
    }
}

