/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ExtraCodecs;

public class AdvancementProgress
implements Comparable<AdvancementProgress> {
    private static final DateTimeFormatter OBTAINED_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    private static final Codec<Instant> OBTAINED_TIME_CODEC = ExtraCodecs.temporalCodec(OBTAINED_TIME_FORMAT).xmap(Instant::from, var0 -> var0.atZone(ZoneId.systemDefault()));
    private static final Codec<Map<String, CriterionProgress>> CRITERIA_CODEC = Codec.unboundedMap((Codec)Codec.STRING, OBTAINED_TIME_CODEC).xmap(var02 -> var02.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, var0 -> new CriterionProgress((Instant)var0.getValue()))), var02 -> var02.entrySet().stream().filter(var0 -> ((CriterionProgress)var0.getValue()).isDone()).collect(Collectors.toMap(Map.Entry::getKey, var0 -> Objects.requireNonNull(((CriterionProgress)var0.getValue()).getObtained()))));
    public static final Codec<AdvancementProgress> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ExtraCodecs.strictOptionalField(CRITERIA_CODEC, "criteria", Map.of()).forGetter(var0 -> var0.criteria), (App)Codec.BOOL.fieldOf("done").orElse((Object)true).forGetter(AdvancementProgress::isDone)).apply((Applicative)var02, (var0, var1) -> new AdvancementProgress(new HashMap<String, CriterionProgress>((Map<String, CriterionProgress>)var0))));
    private final Map<String, CriterionProgress> criteria;
    private AdvancementRequirements requirements = AdvancementRequirements.EMPTY;

    private AdvancementProgress(Map<String, CriterionProgress> var0) {
        this.criteria = var0;
    }

    public AdvancementProgress() {
        this.criteria = Maps.newHashMap();
    }

    public void update(AdvancementRequirements var0) {
        Set<String> var12 = var0.names();
        this.criteria.entrySet().removeIf(var1 -> !var12.contains(var1.getKey()));
        for (String var3 : var12) {
            this.criteria.putIfAbsent(var3, new CriterionProgress());
        }
        this.requirements = var0;
    }

    public boolean isDone() {
        return this.requirements.test(this::isCriterionDone);
    }

    public boolean hasProgress() {
        for (CriterionProgress var1 : this.criteria.values()) {
            if (!var1.isDone()) continue;
            return true;
        }
        return false;
    }

    public boolean grantProgress(String var0) {
        CriterionProgress var1 = this.criteria.get(var0);
        if (var1 != null && !var1.isDone()) {
            var1.grant();
            return true;
        }
        return false;
    }

    public boolean revokeProgress(String var0) {
        CriterionProgress var1 = this.criteria.get(var0);
        if (var1 != null && var1.isDone()) {
            var1.revoke();
            return true;
        }
        return false;
    }

    public String toString() {
        return "AdvancementProgress{criteria=" + this.criteria + ", requirements=" + this.requirements + "}";
    }

    public void serializeToNetwork(PacketDataSerializer var02) {
        var02.writeMap(this.criteria, PacketDataSerializer::writeUtf, (var0, var1) -> var1.serializeToNetwork((PacketDataSerializer)((Object)var0)));
    }

    public static AdvancementProgress fromNetwork(PacketDataSerializer var0) {
        Map<String, CriterionProgress> var1 = var0.readMap(PacketDataSerializer::readUtf, CriterionProgress::fromNetwork);
        return new AdvancementProgress(var1);
    }

    @Nullable
    public CriterionProgress getCriterion(String var0) {
        return this.criteria.get(var0);
    }

    private boolean isCriterionDone(String var0) {
        CriterionProgress var1 = this.getCriterion(var0);
        return var1 != null && var1.isDone();
    }

    public float getPercent() {
        if (this.criteria.isEmpty()) {
            return 0.0f;
        }
        float var0 = this.requirements.size();
        float var1 = this.countCompletedRequirements();
        return var1 / var0;
    }

    @Nullable
    public IChatBaseComponent getProgressText() {
        if (this.criteria.isEmpty()) {
            return null;
        }
        int var0 = this.requirements.size();
        if (var0 <= 1) {
            return null;
        }
        int var1 = this.countCompletedRequirements();
        return IChatBaseComponent.translatable("advancements.progress", var1, var0);
    }

    private int countCompletedRequirements() {
        return this.requirements.count(this::isCriterionDone);
    }

    public Iterable<String> getRemainingCriteria() {
        ArrayList var0 = Lists.newArrayList();
        for (Map.Entry<String, CriterionProgress> var2 : this.criteria.entrySet()) {
            if (var2.getValue().isDone()) continue;
            var0.add(var2.getKey());
        }
        return var0;
    }

    public Iterable<String> getCompletedCriteria() {
        ArrayList var0 = Lists.newArrayList();
        for (Map.Entry<String, CriterionProgress> var2 : this.criteria.entrySet()) {
            if (!var2.getValue().isDone()) continue;
            var0.add(var2.getKey());
        }
        return var0;
    }

    @Nullable
    public Instant getFirstProgressDate() {
        return this.criteria.values().stream().map(CriterionProgress::getObtained).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null);
    }

    @Override
    public int compareTo(AdvancementProgress var0) {
        Instant var1 = this.getFirstProgressDate();
        Instant var2 = var0.getFirstProgressDate();
        if (var1 == null && var2 != null) {
            return 1;
        }
        if (var1 != null && var2 == null) {
            return -1;
        }
        if (var1 == null && var2 == null) {
            return 0;
        }
        return var1.compareTo(var2);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((AdvancementProgress)object);
    }
}

