/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.slf4j.Logger;

public class Scoreboard {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, ScoreboardObjective> objectivesByName = Maps.newHashMap();
    private final Map<IScoreboardCriteria, List<ScoreboardObjective>> objectivesByCriteria = Maps.newHashMap();
    private final Map<String, Map<ScoreboardObjective, ScoreboardScore>> playerScores = Maps.newHashMap();
    private final Map<DisplaySlot, ScoreboardObjective> displayObjectives = new EnumMap<DisplaySlot, ScoreboardObjective>(DisplaySlot.class);
    private final Map<String, ScoreboardTeam> teamsByName = Maps.newHashMap();
    private final Map<String, ScoreboardTeam> teamsByPlayer = Maps.newHashMap();

    @Nullable
    public ScoreboardObjective getObjective(@Nullable String var0) {
        return this.objectivesByName.get(var0);
    }

    public ScoreboardObjective addObjective(String var02, IScoreboardCriteria var1, IChatBaseComponent var2, IScoreboardCriteria.EnumScoreboardHealthDisplay var3) {
        if (this.objectivesByName.containsKey(var02)) {
            throw new IllegalArgumentException("An objective with the name '" + var02 + "' already exists!");
        }
        ScoreboardObjective var4 = new ScoreboardObjective(this, var02, var1, var2, var3);
        this.objectivesByCriteria.computeIfAbsent(var1, var0 -> Lists.newArrayList()).add(var4);
        this.objectivesByName.put(var02, var4);
        this.onObjectiveAdded(var4);
        return var4;
    }

    public final void forAllObjectives(IScoreboardCriteria var0, String var1, Consumer<ScoreboardScore> var22) {
        this.objectivesByCriteria.getOrDefault(var0, Collections.emptyList()).forEach(var2 -> var22.accept(this.getOrCreatePlayerScore(var1, (ScoreboardObjective)var2)));
    }

    public boolean hasPlayerScore(String var0, ScoreboardObjective var1) {
        Map<ScoreboardObjective, ScoreboardScore> var2 = this.playerScores.get(var0);
        if (var2 == null) {
            return false;
        }
        ScoreboardScore var3 = var2.get(var1);
        return var3 != null;
    }

    public ScoreboardScore getOrCreatePlayerScore(String var02, ScoreboardObjective var12) {
        Map var2 = this.playerScores.computeIfAbsent(var02, var0 -> Maps.newHashMap());
        return var2.computeIfAbsent(var12, var1 -> {
            ScoreboardScore var2 = new ScoreboardScore(this, (ScoreboardObjective)var1, var02);
            var2.setScore(0);
            return var2;
        });
    }

    public Collection<ScoreboardScore> getPlayerScores(ScoreboardObjective var0) {
        ArrayList var1 = Lists.newArrayList();
        for (Map<ScoreboardObjective, ScoreboardScore> var3 : this.playerScores.values()) {
            ScoreboardScore var4 = var3.get(var0);
            if (var4 == null) continue;
            var1.add(var4);
        }
        var1.sort(ScoreboardScore.SCORE_COMPARATOR);
        return var1;
    }

    public Collection<ScoreboardObjective> getObjectives() {
        return this.objectivesByName.values();
    }

    public Collection<String> getObjectiveNames() {
        return this.objectivesByName.keySet();
    }

    public Collection<String> getTrackedPlayers() {
        return Lists.newArrayList(this.playerScores.keySet());
    }

    public void resetPlayerScore(String var0, @Nullable ScoreboardObjective var1) {
        if (var1 == null) {
            Map<ScoreboardObjective, ScoreboardScore> var2 = this.playerScores.remove(var0);
            if (var2 != null) {
                this.onPlayerRemoved(var0);
            }
        } else {
            Map<ScoreboardObjective, ScoreboardScore> var2 = this.playerScores.get(var0);
            if (var2 != null) {
                ScoreboardScore var3 = var2.remove(var1);
                if (var2.size() < 1) {
                    Map<ScoreboardObjective, ScoreboardScore> var4 = this.playerScores.remove(var0);
                    if (var4 != null) {
                        this.onPlayerRemoved(var0);
                    }
                } else if (var3 != null) {
                    this.onPlayerScoreRemoved(var0, var1);
                }
            }
        }
    }

    public Map<ScoreboardObjective, ScoreboardScore> getPlayerScores(String var0) {
        HashMap var1 = this.playerScores.get(var0);
        if (var1 == null) {
            var1 = Maps.newHashMap();
        }
        return var1;
    }

    public void removeObjective(ScoreboardObjective var0) {
        this.objectivesByName.remove(var0.getName());
        for (DisplaySlot var4 : DisplaySlot.values()) {
            if (this.getDisplayObjective(var4) != var0) continue;
            this.setDisplayObjective(var4, null);
        }
        List<ScoreboardObjective> var1 = this.objectivesByCriteria.get(var0.getCriteria());
        if (var1 != null) {
            var1.remove(var0);
        }
        for (Map<ScoreboardObjective, ScoreboardScore> var3 : this.playerScores.values()) {
            var3.remove(var0);
        }
        this.onObjectiveRemoved(var0);
    }

    public void setDisplayObjective(DisplaySlot var0, @Nullable ScoreboardObjective var1) {
        this.displayObjectives.put(var0, var1);
    }

    @Nullable
    public ScoreboardObjective getDisplayObjective(DisplaySlot var0) {
        return this.displayObjectives.get(var0);
    }

    @Nullable
    public ScoreboardTeam getPlayerTeam(String var0) {
        return this.teamsByName.get(var0);
    }

    public ScoreboardTeam addPlayerTeam(String var0) {
        ScoreboardTeam var1 = this.getPlayerTeam(var0);
        if (var1 != null) {
            LOGGER.warn("Requested creation of existing team '{}'", (Object)var0);
            return var1;
        }
        var1 = new ScoreboardTeam(this, var0);
        this.teamsByName.put(var0, var1);
        this.onTeamAdded(var1);
        return var1;
    }

    public void removePlayerTeam(ScoreboardTeam var0) {
        this.teamsByName.remove(var0.getName());
        for (String var2 : var0.getPlayers()) {
            this.teamsByPlayer.remove(var2);
        }
        this.onTeamRemoved(var0);
    }

    public boolean addPlayerToTeam(String var0, ScoreboardTeam var1) {
        if (this.getPlayersTeam(var0) != null) {
            this.removePlayerFromTeam(var0);
        }
        this.teamsByPlayer.put(var0, var1);
        return var1.getPlayers().add(var0);
    }

    public boolean removePlayerFromTeam(String var0) {
        ScoreboardTeam var1 = this.getPlayersTeam(var0);
        if (var1 != null) {
            this.removePlayerFromTeam(var0, var1);
            return true;
        }
        return false;
    }

    public void removePlayerFromTeam(String var0, ScoreboardTeam var1) {
        if (this.getPlayersTeam(var0) != var1) {
            throw new IllegalStateException("Player is either on another team or not on any team. Cannot remove from team '" + var1.getName() + "'.");
        }
        this.teamsByPlayer.remove(var0);
        var1.getPlayers().remove(var0);
    }

    public Collection<String> getTeamNames() {
        return this.teamsByName.keySet();
    }

    public Collection<ScoreboardTeam> getPlayerTeams() {
        return this.teamsByName.values();
    }

    @Nullable
    public ScoreboardTeam getPlayersTeam(String var0) {
        return this.teamsByPlayer.get(var0);
    }

    public void onObjectiveAdded(ScoreboardObjective var0) {
    }

    public void onObjectiveChanged(ScoreboardObjective var0) {
    }

    public void onObjectiveRemoved(ScoreboardObjective var0) {
    }

    public void onScoreChanged(ScoreboardScore var0) {
    }

    public void onPlayerRemoved(String var0) {
    }

    public void onPlayerScoreRemoved(String var0, ScoreboardObjective var1) {
    }

    public void onTeamAdded(ScoreboardTeam var0) {
    }

    public void onTeamChanged(ScoreboardTeam var0) {
    }

    public void onTeamRemoved(ScoreboardTeam var0) {
    }

    public void entityRemoved(Entity var0) {
        if (var0 instanceof EntityHuman || var0.isAlive()) {
            return;
        }
        String var1 = var0.getStringUUID();
        this.resetPlayerScore(var1, null);
        this.removePlayerFromTeam(var1);
    }

    protected NBTTagList savePlayerScores() {
        NBTTagList var0 = new NBTTagList();
        this.playerScores.values().stream().map(Map::values).forEach(var12 -> var12.forEach(var1 -> {
            NBTTagCompound var2 = new NBTTagCompound();
            var2.putString("Name", var1.getOwner());
            var2.putString("Objective", var1.getObjective().getName());
            var2.putInt("Score", var1.getScore());
            var2.putBoolean("Locked", var1.isLocked());
            var0.add(var2);
        }));
        return var0;
    }

    protected void loadPlayerScores(NBTTagList var0) {
        for (int var1 = 0; var1 < var0.size(); ++var1) {
            NBTTagCompound var2 = var0.getCompound(var1);
            String var3 = var2.getString("Name");
            String var4 = var2.getString("Objective");
            ScoreboardObjective var5 = this.getObjective(var4);
            if (var5 == null) {
                LOGGER.error("Unknown objective {} for name {}, ignoring", (Object)var4, (Object)var3);
                continue;
            }
            ScoreboardScore var6 = this.getOrCreatePlayerScore(var3, var5);
            var6.setScore(var2.getInt("Score"));
            if (!var2.contains("Locked")) continue;
            var6.setLocked(var2.getBoolean("Locked"));
        }
    }
}

