/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import net.minecraft.EnumChatFormat;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.slf4j.Logger;

public class PersistentScoreboard
extends PersistentBase {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String FILE_ID = "scoreboard";
    private final Scoreboard scoreboard;

    public PersistentScoreboard(Scoreboard var0) {
        this.scoreboard = var0;
    }

    public PersistentScoreboard load(NBTTagCompound var0) {
        this.loadObjectives(var0.getList("Objectives", 10));
        this.scoreboard.loadPlayerScores(var0.getList("PlayerScores", 10));
        if (var0.contains("DisplaySlots", 10)) {
            this.loadDisplaySlots(var0.getCompound("DisplaySlots"));
        }
        if (var0.contains("Teams", 9)) {
            this.loadTeams(var0.getList("Teams", 10));
        }
        return this;
    }

    private void loadTeams(NBTTagList var0) {
        for (int var1 = 0; var1 < var0.size(); ++var1) {
            Object var6;
            NBTTagCompound var2 = var0.getCompound(var1);
            String var3 = var2.getString("Name");
            ScoreboardTeam var4 = this.scoreboard.addPlayerTeam(var3);
            IChatMutableComponent var5 = IChatBaseComponent.ChatSerializer.fromJson(var2.getString("DisplayName"));
            if (var5 != null) {
                var4.setDisplayName(var5);
            }
            if (var2.contains("TeamColor", 8)) {
                var4.setColor(EnumChatFormat.getByName(var2.getString("TeamColor")));
            }
            if (var2.contains("AllowFriendlyFire", 99)) {
                var4.setAllowFriendlyFire(var2.getBoolean("AllowFriendlyFire"));
            }
            if (var2.contains("SeeFriendlyInvisibles", 99)) {
                var4.setSeeFriendlyInvisibles(var2.getBoolean("SeeFriendlyInvisibles"));
            }
            if (var2.contains("MemberNamePrefix", 8) && (var6 = IChatBaseComponent.ChatSerializer.fromJson(var2.getString("MemberNamePrefix"))) != null) {
                var4.setPlayerPrefix((IChatBaseComponent)var6);
            }
            if (var2.contains("MemberNameSuffix", 8) && (var6 = IChatBaseComponent.ChatSerializer.fromJson(var2.getString("MemberNameSuffix"))) != null) {
                var4.setPlayerSuffix((IChatBaseComponent)var6);
            }
            if (var2.contains("NameTagVisibility", 8) && (var6 = ScoreboardTeamBase.EnumNameTagVisibility.byName(var2.getString("NameTagVisibility"))) != null) {
                var4.setNameTagVisibility((ScoreboardTeamBase.EnumNameTagVisibility)((Object)var6));
            }
            if (var2.contains("DeathMessageVisibility", 8) && (var6 = ScoreboardTeamBase.EnumNameTagVisibility.byName(var2.getString("DeathMessageVisibility"))) != null) {
                var4.setDeathMessageVisibility((ScoreboardTeamBase.EnumNameTagVisibility)((Object)var6));
            }
            if (var2.contains("CollisionRule", 8) && (var6 = ScoreboardTeamBase.EnumTeamPush.byName(var2.getString("CollisionRule"))) != null) {
                var4.setCollisionRule((ScoreboardTeamBase.EnumTeamPush)((Object)var6));
            }
            this.loadTeamPlayers(var4, var2.getList("Players", 8));
        }
    }

    private void loadTeamPlayers(ScoreboardTeam var0, NBTTagList var1) {
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            this.scoreboard.addPlayerToTeam(var1.getString(var2), var0);
        }
    }

    private void loadDisplaySlots(NBTTagCompound var0) {
        for (String var2 : var0.getAllKeys()) {
            DisplaySlot var3 = DisplaySlot.CODEC.byName(var2);
            if (var3 == null) continue;
            String var4 = var0.getString(var2);
            ScoreboardObjective var5 = this.scoreboard.getObjective(var4);
            this.scoreboard.setDisplayObjective(var3, var5);
        }
    }

    private void loadObjectives(NBTTagList var0) {
        for (int var1 = 0; var1 < var0.size(); ++var1) {
            NBTTagCompound var2 = var0.getCompound(var1);
            String var3 = var2.getString("CriteriaName");
            IScoreboardCriteria var4 = IScoreboardCriteria.byName(var3).orElseGet(() -> {
                LOGGER.warn("Unknown scoreboard criteria {}, replacing with {}", (Object)var3, (Object)IScoreboardCriteria.DUMMY.getName());
                return IScoreboardCriteria.DUMMY;
            });
            String var5 = var2.getString("Name");
            IChatMutableComponent var6 = IChatBaseComponent.ChatSerializer.fromJson(var2.getString("DisplayName"));
            IScoreboardCriteria.EnumScoreboardHealthDisplay var7 = IScoreboardCriteria.EnumScoreboardHealthDisplay.byId(var2.getString("RenderType"));
            this.scoreboard.addObjective(var5, var4, var6, var7);
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound var0) {
        var0.put("Objectives", this.saveObjectives());
        var0.put("PlayerScores", this.scoreboard.savePlayerScores());
        var0.put("Teams", this.saveTeams());
        this.saveDisplaySlots(var0);
        return var0;
    }

    private NBTTagList saveTeams() {
        NBTTagList var0 = new NBTTagList();
        Collection<ScoreboardTeam> var1 = this.scoreboard.getPlayerTeams();
        for (ScoreboardTeam var3 : var1) {
            NBTTagCompound var4 = new NBTTagCompound();
            var4.putString("Name", var3.getName());
            var4.putString("DisplayName", IChatBaseComponent.ChatSerializer.toJson(var3.getDisplayName()));
            if (var3.getColor().getId() >= 0) {
                var4.putString("TeamColor", var3.getColor().getName());
            }
            var4.putBoolean("AllowFriendlyFire", var3.isAllowFriendlyFire());
            var4.putBoolean("SeeFriendlyInvisibles", var3.canSeeFriendlyInvisibles());
            var4.putString("MemberNamePrefix", IChatBaseComponent.ChatSerializer.toJson(var3.getPlayerPrefix()));
            var4.putString("MemberNameSuffix", IChatBaseComponent.ChatSerializer.toJson(var3.getPlayerSuffix()));
            var4.putString("NameTagVisibility", var3.getNameTagVisibility().name);
            var4.putString("DeathMessageVisibility", var3.getDeathMessageVisibility().name);
            var4.putString("CollisionRule", var3.getCollisionRule().name);
            NBTTagList var5 = new NBTTagList();
            for (String var7 : var3.getPlayers()) {
                var5.add(NBTTagString.valueOf(var7));
            }
            var4.put("Players", var5);
            var0.add(var4);
        }
        return var0;
    }

    private void saveDisplaySlots(NBTTagCompound var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        for (DisplaySlot var5 : DisplaySlot.values()) {
            ScoreboardObjective var6 = this.scoreboard.getDisplayObjective(var5);
            if (var6 == null) continue;
            var1.putString(var5.getSerializedName(), var6.getName());
        }
        if (!var1.isEmpty()) {
            var0.put("DisplaySlots", var1);
        }
    }

    private NBTTagList saveObjectives() {
        NBTTagList var0 = new NBTTagList();
        Collection<ScoreboardObjective> var1 = this.scoreboard.getObjectives();
        for (ScoreboardObjective var3 : var1) {
            NBTTagCompound var4 = new NBTTagCompound();
            var4.putString("Name", var3.getName());
            var4.putString("CriteriaName", var3.getCriteria().getName());
            var4.putString("DisplayName", IChatBaseComponent.ChatSerializer.toJson(var3.getDisplayName()));
            var4.putString("RenderType", var3.getRenderType().getId());
            var0.add(var4);
        }
        return var0;
    }
}

