/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.ScoreboardValue;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class NumberProviders {
    private static final Codec<NumberProvider> TYPED_CODEC = BuiltInRegistries.LOOT_NUMBER_PROVIDER_TYPE.byNameCodec().dispatch(NumberProvider::getType, LootNumberProviderType::codec);
    public static final Codec<NumberProvider> CODEC = ExtraCodecs.lazyInitializedCodec(() -> {
        Codec<UniformGenerator> var02 = ExtraCodecs.withAlternative(TYPED_CODEC, UniformGenerator.CODEC);
        return Codec.either(ConstantValue.INLINE_CODEC, var02).xmap(var0 -> (NumberProvider)var0.map(Function.identity(), Function.identity()), var0 -> {
            Either either;
            if (var0 instanceof ConstantValue) {
                ConstantValue var1 = (ConstantValue)var0;
                either = Either.left((Object)var1);
            } else {
                either = Either.right((Object)var0);
            }
            return either;
        });
    });
    public static final LootNumberProviderType CONSTANT = NumberProviders.register("constant", ConstantValue.CODEC);
    public static final LootNumberProviderType UNIFORM = NumberProviders.register("uniform", UniformGenerator.CODEC);
    public static final LootNumberProviderType BINOMIAL = NumberProviders.register("binomial", BinomialDistributionGenerator.CODEC);
    public static final LootNumberProviderType SCORE = NumberProviders.register("score", ScoreboardValue.CODEC);

    private static LootNumberProviderType register(String var0, Codec<? extends NumberProvider> var1) {
        return IRegistry.register(BuiltInRegistries.LOOT_NUMBER_PROVIDER_TYPE, new MinecraftKey(var0), new LootNumberProviderType(var1));
    }
}

