/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public record LootItemConditionRandomChanceWithLooting(float percent, float lootingMultiplier) implements LootItemCondition
{
    public static final Codec<LootItemConditionRandomChanceWithLooting> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.FLOAT.fieldOf("chance").forGetter(LootItemConditionRandomChanceWithLooting::percent), (App)Codec.FLOAT.fieldOf("looting_multiplier").forGetter(LootItemConditionRandomChanceWithLooting::lootingMultiplier)).apply((Applicative)var0, LootItemConditionRandomChanceWithLooting::new));

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.RANDOM_CHANCE_WITH_LOOTING;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.KILLER_ENTITY);
    }

    @Override
    public boolean test(LootTableInfo var0) {
        Entity var1 = var0.getParamOrNull(LootContextParameters.KILLER_ENTITY);
        int var2 = 0;
        if (var1 instanceof EntityLiving) {
            var2 = EnchantmentManager.getMobLooting((EntityLiving)var1);
        }
        return var0.getRandom().nextFloat() < this.percent + (float)var2 * this.lootingMultiplier;
    }

    public static LootItemCondition.a randomChanceAndLootingBoost(float var0, float var1) {
        return () -> new LootItemConditionRandomChanceWithLooting(var0, var1);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }
}

