/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class SetEnchantmentsFunction
extends LootItemFunctionConditional {
    public static final Codec<SetEnchantmentsFunction> CODEC = RecordCodecBuilder.create(var02 -> SetEnchantmentsFunction.commonFields(var02).and(var02.group((App)ExtraCodecs.strictOptionalField(Codec.unboundedMap(BuiltInRegistries.ENCHANTMENT.holderByNameCodec(), NumberProviders.CODEC), "enchantments", Map.of()).forGetter(var0 -> var0.enchantments), (App)Codec.BOOL.fieldOf("add").orElse((Object)false).forGetter(var0 -> var0.add))).apply((Applicative)var02, SetEnchantmentsFunction::new));
    private final Map<Holder<Enchantment>, NumberProvider> enchantments;
    private final boolean add;

    SetEnchantmentsFunction(List<LootItemCondition> var0, Map<Holder<Enchantment>, NumberProvider> var1, boolean var2) {
        super(var0);
        this.enchantments = Map.copyOf(var1);
        this.add = var2;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_ENCHANTMENTS;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return (Set)this.enchantments.values().stream().flatMap(var0 -> var0.getReferencedContextParams().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var12) {
        Object2IntOpenHashMap var22 = new Object2IntOpenHashMap();
        this.enchantments.forEach((arg_0, arg_1) -> SetEnchantmentsFunction.a((Object2IntMap)var22, var12, arg_0, arg_1));
        if (var0.getItem() == Items.BOOK) {
            ItemStack var3 = new ItemStack(Items.ENCHANTED_BOOK);
            var22.forEach((var1, var2) -> ItemEnchantedBook.addEnchantment(var3, new WeightedRandomEnchant((Enchantment)var1, (int)var2)));
            return var3;
        }
        Map<Enchantment, Integer> var3 = EnchantmentManager.getEnchantments(var0);
        if (this.add) {
            var22.forEach((var1, var2) -> SetEnchantmentsFunction.updateEnchantment(var3, var1, Math.max(var3.getOrDefault(var1, 0) + var2, 0)));
        } else {
            var22.forEach((var1, var2) -> SetEnchantmentsFunction.updateEnchantment(var3, var1, Math.max(var2, 0)));
        }
        EnchantmentManager.setEnchantments(var3, var0);
        return var0;
    }

    private static void updateEnchantment(Map<Enchantment, Integer> var0, Enchantment var1, int var2) {
        if (var2 == 0) {
            var0.remove(var1);
        } else {
            var0.put(var1, var2);
        }
    }

    private static /* synthetic */ void a(Object2IntMap var0, LootTableInfo var1, Holder var2, NumberProvider var3) {
        var0.put((Object)((Enchantment)var2.value()), var3.getInt(var1));
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final ImmutableMap.Builder<Holder<Enchantment>, NumberProvider> enchantments = ImmutableMap.builder();
        private final boolean add;

        public a() {
            this(false);
        }

        public a(boolean var0) {
            this.add = var0;
        }

        @Override
        protected a getThis() {
            return this;
        }

        public a withEnchantment(Enchantment var0, NumberProvider var1) {
            this.enchantments.put(var0.builtInRegistryHolder(), (Object)var1);
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new SetEnchantmentsFunction(this.getConditions(), (Map<Holder<Enchantment>, NumberProvider>)this.enchantments.build(), this.add);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

