/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.FunctionReference;
import net.minecraft.world.level.storage.loot.functions.LootEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.LootEnchantLevel;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyNBT;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyName;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyState;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionEnchant;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionExplorationMap;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionFillPlayerHead;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionLimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetAttribute;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetContents;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetDamage;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetLore;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetName;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetStewEffect;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetTag;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSmelt;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.SequenceFunction;
import net.minecraft.world.level.storage.loot.functions.SetBannerPatternFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetInstrumentFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;

public class LootItemFunctions {
    public static final BiFunction<ItemStack, LootTableInfo, ItemStack> IDENTITY = (var0, var1) -> var0;
    private static final Codec<LootItemFunction> TYPED_CODEC = BuiltInRegistries.LOOT_FUNCTION_TYPE.byNameCodec().dispatch("function", LootItemFunction::getType, LootItemFunctionType::codec);
    public static final Codec<LootItemFunction> CODEC = ExtraCodecs.lazyInitializedCodec(() -> ExtraCodecs.withAlternative(TYPED_CODEC, SequenceFunction.INLINE_CODEC));
    public static final LootItemFunctionType SET_COUNT = LootItemFunctions.register("set_count", LootItemFunctionSetCount.CODEC);
    public static final LootItemFunctionType ENCHANT_WITH_LEVELS = LootItemFunctions.register("enchant_with_levels", LootEnchantLevel.CODEC);
    public static final LootItemFunctionType ENCHANT_RANDOMLY = LootItemFunctions.register("enchant_randomly", LootItemFunctionEnchant.CODEC);
    public static final LootItemFunctionType SET_ENCHANTMENTS = LootItemFunctions.register("set_enchantments", SetEnchantmentsFunction.CODEC);
    public static final LootItemFunctionType SET_NBT = LootItemFunctions.register("set_nbt", LootItemFunctionSetTag.CODEC);
    public static final LootItemFunctionType FURNACE_SMELT = LootItemFunctions.register("furnace_smelt", LootItemFunctionSmelt.CODEC);
    public static final LootItemFunctionType LOOTING_ENCHANT = LootItemFunctions.register("looting_enchant", LootEnchantFunction.CODEC);
    public static final LootItemFunctionType SET_DAMAGE = LootItemFunctions.register("set_damage", LootItemFunctionSetDamage.CODEC);
    public static final LootItemFunctionType SET_ATTRIBUTES = LootItemFunctions.register("set_attributes", LootItemFunctionSetAttribute.CODEC);
    public static final LootItemFunctionType SET_NAME = LootItemFunctions.register("set_name", LootItemFunctionSetName.CODEC);
    public static final LootItemFunctionType EXPLORATION_MAP = LootItemFunctions.register("exploration_map", LootItemFunctionExplorationMap.CODEC);
    public static final LootItemFunctionType SET_STEW_EFFECT = LootItemFunctions.register("set_stew_effect", LootItemFunctionSetStewEffect.CODEC);
    public static final LootItemFunctionType COPY_NAME = LootItemFunctions.register("copy_name", LootItemFunctionCopyName.CODEC);
    public static final LootItemFunctionType SET_CONTENTS = LootItemFunctions.register("set_contents", LootItemFunctionSetContents.CODEC);
    public static final LootItemFunctionType LIMIT_COUNT = LootItemFunctions.register("limit_count", LootItemFunctionLimitCount.CODEC);
    public static final LootItemFunctionType APPLY_BONUS = LootItemFunctions.register("apply_bonus", LootItemFunctionApplyBonus.CODEC);
    public static final LootItemFunctionType SET_LOOT_TABLE = LootItemFunctions.register("set_loot_table", LootItemFunctionSetTable.CODEC);
    public static final LootItemFunctionType EXPLOSION_DECAY = LootItemFunctions.register("explosion_decay", LootItemFunctionExplosionDecay.CODEC);
    public static final LootItemFunctionType SET_LORE = LootItemFunctions.register("set_lore", LootItemFunctionSetLore.CODEC);
    public static final LootItemFunctionType FILL_PLAYER_HEAD = LootItemFunctions.register("fill_player_head", LootItemFunctionFillPlayerHead.CODEC);
    public static final LootItemFunctionType COPY_NBT = LootItemFunctions.register("copy_nbt", LootItemFunctionCopyNBT.CODEC);
    public static final LootItemFunctionType COPY_STATE = LootItemFunctions.register("copy_state", LootItemFunctionCopyState.CODEC);
    public static final LootItemFunctionType SET_BANNER_PATTERN = LootItemFunctions.register("set_banner_pattern", SetBannerPatternFunction.CODEC);
    public static final LootItemFunctionType SET_POTION = LootItemFunctions.register("set_potion", SetPotionFunction.CODEC);
    public static final LootItemFunctionType SET_INSTRUMENT = LootItemFunctions.register("set_instrument", SetInstrumentFunction.CODEC);
    public static final LootItemFunctionType REFERENCE = LootItemFunctions.register("reference", FunctionReference.CODEC);
    public static final LootItemFunctionType SEQUENCE = LootItemFunctions.register("sequence", SequenceFunction.CODEC);

    private static LootItemFunctionType register(String var0, Codec<? extends LootItemFunction> var1) {
        return IRegistry.register(BuiltInRegistries.LOOT_FUNCTION_TYPE, new MinecraftKey(var0), new LootItemFunctionType(var1));
    }

    public static BiFunction<ItemStack, LootTableInfo, ItemStack> compose(List<? extends BiFunction<ItemStack, LootTableInfo, ItemStack>> var0) {
        List<? extends BiFunction<ItemStack, LootTableInfo, ItemStack>> var12 = List.copyOf(var0);
        return switch (var12.size()) {
            case 0 -> IDENTITY;
            case 1 -> var12.get(0);
            case 2 -> {
                BiFunction<ItemStack, LootTableInfo, ItemStack> var2 = var12.get(0);
                BiFunction<ItemStack, LootTableInfo, ItemStack> var3 = var12.get(1);
                yield (var2, var3) -> (ItemStack)var3.apply((ItemStack)var2.apply((ItemStack)var2, (LootTableInfo)var3), (LootTableInfo)var3);
            }
            default -> (var1, var2) -> {
                for (BiFunction var4 : var12) {
                    var1 = (ItemStack)var4.apply(var1, var2);
                }
                return var1;
            };
        };
    }
}

