/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSuspiciousStew;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class LootItemFunctionSetStewEffect
extends LootItemFunctionConditional {
    private static final Codec<List<b>> EFFECTS_LIST = ExtraCodecs.validate(b.CODEC.listOf(), var0 -> {
        ObjectOpenHashSet var1 = new ObjectOpenHashSet();
        for (b var3 : var0) {
            if (var1.add(var3.effect())) continue;
            return DataResult.error(() -> "Encountered duplicate mob effect: '" + var3.effect() + "'");
        }
        return DataResult.success((Object)var0);
    });
    public static final Codec<LootItemFunctionSetStewEffect> CODEC = RecordCodecBuilder.create(var02 -> LootItemFunctionSetStewEffect.commonFields(var02).and((App)ExtraCodecs.strictOptionalField(EFFECTS_LIST, "effects", List.of()).forGetter(var0 -> var0.effects)).apply((Applicative)var02, LootItemFunctionSetStewEffect::new));
    private final List<b> effects;

    LootItemFunctionSetStewEffect(List<LootItemCondition> var0, List<b> var1) {
        super(var0);
        this.effects = var1;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_STEW_EFFECT;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return (Set)this.effects.stream().flatMap(var0 -> var0.duration().getReferencedContextParams().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        if (!var0.is(Items.SUSPICIOUS_STEW) || this.effects.isEmpty()) {
            return var0;
        }
        b var2 = SystemUtils.getRandom(this.effects, var1.getRandom());
        MobEffectList var3 = var2.effect().value();
        int var4 = var2.duration().getInt(var1);
        if (!var3.isInstantenous()) {
            var4 *= 20;
        }
        ItemSuspiciousStew.appendMobEffects(var0, List.of(new SuspiciousEffectHolder.a(var3, var4)));
        return var0;
    }

    public static a stewEffect() {
        return new a();
    }

    record b(Holder<MobEffectList> effect, NumberProvider duration) {
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("type").forGetter(b::effect), (App)NumberProviders.CODEC.fieldOf("duration").forGetter(b::duration)).apply((Applicative)var0, b::new));
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final ImmutableList.Builder<b> effects = ImmutableList.builder();

        @Override
        protected a getThis() {
            return this;
        }

        public a withEffect(MobEffectList var0, NumberProvider var1) {
            this.effects.add((Object)new b(var0.builtInRegistryHolder(), var1));
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionSetStewEffect(this.getConditions(), (List<b>)this.effects.build());
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

