/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class LootItemFunctionSetName
extends LootItemFunctionConditional {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<LootItemFunctionSetName> CODEC = RecordCodecBuilder.create(var02 -> LootItemFunctionSetName.commonFields(var02).and(var02.group((App)ExtraCodecs.strictOptionalField(ExtraCodecs.COMPONENT, "name").forGetter(var0 -> var0.name), (App)ExtraCodecs.strictOptionalField(LootTableInfo.EntityTarget.CODEC, "entity").forGetter(var0 -> var0.resolutionContext))).apply((Applicative)var02, LootItemFunctionSetName::new));
    private final Optional<IChatBaseComponent> name;
    private final Optional<LootTableInfo.EntityTarget> resolutionContext;

    private LootItemFunctionSetName(List<LootItemCondition> var0, Optional<IChatBaseComponent> var1, Optional<LootTableInfo.EntityTarget> var2) {
        super(var0);
        this.name = var1;
        this.resolutionContext = var2;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_NAME;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return this.resolutionContext.map(var0 -> Set.of(var0.getParam())).orElse(Set.of());
    }

    public static UnaryOperator<IChatBaseComponent> createResolver(LootTableInfo var02, @Nullable LootTableInfo.EntityTarget var1) {
        Entity var22;
        if (var1 != null && (var22 = var02.getParamOrNull(var1.getParam())) != null) {
            CommandListenerWrapper var3 = var22.createCommandSourceStack().withPermission(2);
            return var2 -> {
                try {
                    return ChatComponentUtils.updateForEntity(var3, var2, var22, 0);
                }
                catch (CommandSyntaxException var3) {
                    LOGGER.warn("Failed to resolve text component", (Throwable)var3);
                    return var2;
                }
            };
        }
        return var0 -> var0;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        this.name.ifPresent(var2 -> var0.setHoverName((IChatBaseComponent)LootItemFunctionSetName.createResolver(var1, this.resolutionContext.orElse(null)).apply((IChatBaseComponent)var2)));
        return var0;
    }

    public static LootItemFunctionConditional.a<?> setName(IChatBaseComponent var0) {
        return LootItemFunctionSetName.simpleBuilder(var1 -> new LootItemFunctionSetName((List<LootItemCondition>)var1, Optional.of(var0), Optional.empty()));
    }

    public static LootItemFunctionConditional.a<?> setName(IChatBaseComponent var0, LootTableInfo.EntityTarget var1) {
        return LootItemFunctionSetName.simpleBuilder(var2 -> new LootItemFunctionSetName((List<LootItemCondition>)var2, Optional.of(var0), Optional.of(var1)));
    }
}

