/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionSetContents
extends LootItemFunctionConditional {
    public static final Codec<LootItemFunctionSetContents> CODEC = RecordCodecBuilder.create(var02 -> LootItemFunctionSetContents.commonFields(var02).and(var02.group((App)BuiltInRegistries.BLOCK_ENTITY_TYPE.holderByNameCodec().fieldOf("type").forGetter(var0 -> var0.type), (App)LootEntries.CODEC.listOf().fieldOf("entries").forGetter(var0 -> var0.entries))).apply((Applicative)var02, LootItemFunctionSetContents::new));
    private final Holder<TileEntityTypes<?>> type;
    private final List<LootEntryAbstract> entries;

    LootItemFunctionSetContents(List<LootItemCondition> var0, Holder<TileEntityTypes<?>> var1, List<LootEntryAbstract> var2) {
        super(var0);
        this.type = var1;
        this.entries = List.copyOf(var2);
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_CONTENTS;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        if (var0.isEmpty()) {
            return var0;
        }
        NonNullList<ItemStack> var2 = NonNullList.create();
        this.entries.forEach(var22 -> var22.expand(var1, var2 -> var2.createItemStack(LootTable.createStackSplitter(var1.getLevel(), var2::add), var1)));
        NBTTagCompound var3 = new NBTTagCompound();
        ContainerUtil.saveAllItems(var3, var2);
        NBTTagCompound var4 = ItemBlock.getBlockEntityData(var0);
        if (var4 == null) {
            var4 = var3;
        } else {
            var4.merge(var3);
        }
        ItemBlock.setBlockEntityData(var0, this.type.value(), var4);
        return var0;
    }

    @Override
    public void validate(LootCollector var0) {
        super.validate(var0);
        for (int var1 = 0; var1 < this.entries.size(); ++var1) {
            this.entries.get(var1).validate(var0.forChild(".entry[" + var1 + "]"));
        }
    }

    public static a setContents(TileEntityTypes<?> var0) {
        return new a(var0);
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final ImmutableList.Builder<LootEntryAbstract> entries = ImmutableList.builder();
        private final TileEntityTypes<?> type;

        public a(TileEntityTypes<?> var0) {
            this.type = var0;
        }

        @Override
        protected a getThis() {
            return this;
        }

        public a withEntry(LootEntryAbstract.a<?> var0) {
            this.entries.add((Object)var0.build());
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionSetContents(this.getConditions(), this.type.builtInRegistryHolder(), (List<LootEntryAbstract>)this.entries.build());
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

