/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.entries.LootSelectorEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootSelectorLootTable
extends LootSelectorEntry {
    public static final Codec<LootSelectorLootTable> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)MinecraftKey.CODEC.fieldOf("name").forGetter(var0 -> var0.name)).and(LootSelectorLootTable.singletonFields(var02)).apply((Applicative)var02, LootSelectorLootTable::new));
    private final MinecraftKey name;

    private LootSelectorLootTable(MinecraftKey var0, int var1, int var2, List<LootItemCondition> var3, List<LootItemFunction> var4) {
        super(var1, var2, var3, var4);
        this.name = var0;
    }

    @Override
    public LootEntryType getType() {
        return LootEntries.REFERENCE;
    }

    @Override
    public void createItemStack(Consumer<ItemStack> var0, LootTableInfo var1) {
        LootTable var2 = var1.getResolver().getLootTable(this.name);
        var2.getRandomItemsRaw(var1, var0);
    }

    @Override
    public void validate(LootCollector var0) {
        LootDataId<LootTable> var1 = new LootDataId<LootTable>(LootDataType.TABLE, this.name);
        if (var0.hasVisitedElement(var1)) {
            var0.reportProblem("Table " + this.name + " is recursively called");
            return;
        }
        super.validate(var0);
        var0.resolver().getElementOptional(var1).ifPresentOrElse(var2 -> var2.validate(var0.enterElement("->{" + this.name + "}", var1)), () -> var0.reportProblem("Unknown loot table called " + this.name));
    }

    public static LootSelectorEntry.a<?> lootTableReference(MinecraftKey var0) {
        return LootSelectorLootTable.simpleBuilder((var1, var2, var3, var4) -> new LootSelectorLootTable(var0, var1, var2, var3, var4));
    }
}

